/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridFS {
    public static final int DEFAULT_CHUNKSIZE = 262144;
    public static final String DEFAULT_BUCKET = "fs";
    protected final DB _db;
    protected final String _bucketName;
    protected final DBCollection _filesCollection;
    protected final DBCollection _chunkCollection;

    public GridFS(DB db) {
        this(db, DEFAULT_BUCKET);
    }

    public GridFS(DB db, String bucket) {
        this._db = db;
        this._bucketName = bucket;
        this._filesCollection = this._db.getCollection(this._bucketName + ".files");
        this._chunkCollection = this._db.getCollection(this._bucketName + ".chunks");
        this._chunkCollection.ensureIndex(BasicDBObjectBuilder.start().add("files_id", 1).add("n", 1).get());
        this._filesCollection.setObjectClass(GridFSDBFile.class);
    }

    public DBCursor getFileList() {
        return this._filesCollection.find().sort(new BasicDBObject("filename", (Object)1));
    }

    public DBCursor getFileList(DBObject query) {
        return this._filesCollection.find(query).sort(new BasicDBObject("filename", (Object)1));
    }

    public GridFSDBFile find(ObjectId id) {
        return this.findOne(id);
    }

    public GridFSDBFile findOne(ObjectId id) {
        return this.findOne(new BasicDBObject("_id", id));
    }

    public GridFSDBFile findOne(String filename) {
        return this.findOne(new BasicDBObject("filename", filename));
    }

    public GridFSDBFile findOne(DBObject query) {
        return this._fix(this._filesCollection.findOne(query));
    }

    public List<GridFSDBFile> find(String filename) {
        return this.find(new BasicDBObject("filename", filename));
    }

    public List<GridFSDBFile> find(DBObject query) {
        ArrayList<GridFSDBFile> files = new ArrayList<GridFSDBFile>();
        DBCursor c = this._filesCollection.find(query);
        while (c.hasNext()) {
            files.add(this._fix(c.next()));
        }
        return files;
    }

    private GridFSDBFile _fix(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof GridFSDBFile)) {
            throw new RuntimeException("somehow didn't get a GridFSDBFile");
        }
        GridFSDBFile f = (GridFSDBFile)o;
        f._fs = this;
        return f;
    }

    public void remove(ObjectId id) {
        this._filesCollection.remove(new BasicDBObject("_id", id));
        this._chunkCollection.remove(new BasicDBObject("files_id", id));
    }

    public void remove(String filename) {
        this.remove(new BasicDBObject("filename", filename));
    }

    public void remove(DBObject query) {
        for (GridFSDBFile f : this.find(query)) {
            f.remove();
        }
    }

    public GridFSInputFile createFile(byte[] data) {
        return this.createFile(new ByteArrayInputStream(data));
    }

    public GridFSInputFile createFile(File f) throws IOException {
        return this.createFile(new FileInputStream(f), f.getName());
    }

    public GridFSInputFile createFile(InputStream in) {
        return this.createFile(in, null);
    }

    public GridFSInputFile createFile(InputStream in, String filename) {
        return new GridFSInputFile(this, in, filename);
    }

    public String getBucketName() {
        return this._bucketName;
    }

    public DB getDB() {
        return this._db;
    }
}

