/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimplePool<T> {
    final int _max;
    private LinkedList<T> _stored = new LinkedList();

    public SimplePool(int max) {
        this._max = max;
    }

    public SimplePool() {
        this._max = 1000;
    }

    protected abstract T createNew();

    protected boolean ok(T t) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        LinkedList<T> linkedList = this._stored;
        synchronized (linkedList) {
            if (this._stored.size() > 0) {
                return this._stored.removeFirst();
            }
        }
        return this.createNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(T t) {
        if (!this.ok(t)) {
            return;
        }
        LinkedList<T> linkedList = this._stored;
        synchronized (linkedList) {
            if (this._stored.size() > this._max) {
                return;
            }
            this._stored.addFirst(t);
        }
    }
}

