/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoURI {
    final String _username;
    final char[] _password;
    final List<String> _hosts;
    final String _database;
    final String _collection;

    public MongoURI(String uri) {
        String optionsPart;
        String nsPart;
        String serverPart;
        if (!uri.startsWith("mongodb://")) {
            throw new IllegalArgumentException("uri needs to start with mongodb://");
        }
        int idx = (uri = uri.substring(10)).lastIndexOf("/");
        if (idx < 0) {
            serverPart = uri;
            nsPart = null;
            optionsPart = null;
        } else {
            serverPart = uri.substring(0, idx);
            nsPart = uri.substring(idx + 1);
            if ((idx = nsPart.indexOf("?")) >= 0) {
                optionsPart = nsPart.substring(idx + 1);
                nsPart = nsPart.substring(0, idx);
            } else {
                optionsPart = null;
            }
        }
        LinkedList<String> all = new LinkedList<String>();
        if (serverPart.indexOf("@") > 0) {
            int idx2 = serverPart.indexOf("@");
            this._username = serverPart.substring(0, idx2);
            serverPart = serverPart.substring(idx2 + 1);
            idx2 = serverPart.indexOf(":");
            this._password = serverPart.substring(0, idx2).toCharArray();
            serverPart = serverPart.substring(idx2 + 1);
        } else {
            this._username = null;
            this._password = null;
        }
        for (String s : serverPart.split(",")) {
            all.add(s);
        }
        this._hosts = Collections.unmodifiableList(all);
        if (nsPart != null) {
            idx = nsPart.indexOf(".");
            if (idx < 0) {
                this._database = nsPart;
                this._collection = null;
            } else {
                this._database = nsPart.substring(0, idx);
                this._collection = nsPart.substring(idx + 1);
            }
        } else {
            this._database = null;
            this._collection = null;
        }
        if (optionsPart != null && optionsPart.length() > 0) {
            throw new RuntimeException("not done");
        }
    }

    public String getUsername() {
        return this._username;
    }

    public char[] getPassword() {
        return this._password;
    }

    public List<String> getHosts() {
        return this._hosts;
    }

    public String getDatabase() {
        return this._database;
    }

    public String getCollection() {
        return this._collection;
    }
}

