/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObjectCodec;
import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBRefCodecProvider;
import com.mongodb.DocumentToDBRefTransformer;
import com.mongodb.Function;
import com.mongodb.ListDatabasesIterableImpl;
import com.mongodb.Mongo;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDatabaseImpl;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.gridfs.codecs.GridFSFileCodecProvider;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class MongoClient
extends Mongo
implements Closeable {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new DBRefCodecProvider(), new DocumentCodecProvider(new DocumentToDBRefTransformer()), new DBObjectCodecProvider(), new BsonValueCodecProvider(), new IterableCodecProvider(new DocumentToDBRefTransformer()), new GeoJsonCodecProvider(), new GridFSFileCodecProvider()));

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    public MongoClient() {
        this(new ServerAddress());
    }

    public MongoClient(String host) {
        this(new ServerAddress(host));
    }

    public MongoClient(String host, MongoClientOptions options) {
        this(new ServerAddress(host), options);
    }

    public MongoClient(String host, int port) {
        this(new ServerAddress(host, port));
    }

    public MongoClient(ServerAddress addr) {
        this(addr, new MongoClientOptions.Builder().build());
    }

    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList) {
        this(addr, credentialsList, new MongoClientOptions.Builder().build());
    }

    public MongoClient(ServerAddress addr, MongoClientOptions options) {
        super(addr, options);
    }

    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(addr, credentialsList, options);
    }

    public MongoClient(List<ServerAddress> seeds) {
        this(seeds, new MongoClientOptions.Builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this(seeds, credentialsList, new MongoClientOptions.Builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, MongoClientOptions options) {
        super(seeds, options);
    }

    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(seeds, credentialsList, options);
    }

    public MongoClient(MongoClientURI uri) {
        super(uri);
    }

    @Override
    public MongoClientOptions getMongoClientOptions() {
        return super.getMongoClientOptions();
    }

    @Override
    public List<MongoCredential> getCredentialsList() {
        return super.getCredentialsList();
    }

    public MongoIterable<String> listDatabaseNames() {
        return new ListDatabasesIterableImpl<BsonDocument>(BsonDocument.class, MongoClient.getDefaultCodecRegistry(), ReadPreference.primary(), this.createOperationExecutor()).map(new Function<BsonDocument, String>(){

            @Override
            public String apply(BsonDocument result) {
                return result.getString("name").getValue();
            }
        });
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clazz, this.getMongoClientOptions().getCodecRegistry(), ReadPreference.primary(), this.createOperationExecutor());
    }

    public MongoDatabase getDatabase(String databaseName) {
        MongoClientOptions clientOptions = this.getMongoClientOptions();
        return new MongoDatabaseImpl(databaseName, clientOptions.getCodecRegistry(), clientOptions.getReadPreference(), clientOptions.getWriteConcern(), clientOptions.getReadConcern(), this.createOperationExecutor());
    }

    static DBObjectCodec getCommandCodec() {
        return new DBObjectCodec(MongoClient.getDefaultCodecRegistry());
    }
}

