/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import org.bson.assertions.Assertions;

public final class MongoAwsKmsProviderOptions {
    private final String accessKeyId;
    private final String secretAccessKey;

    public static Builder builder() {
        return new Builder();
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    private MongoAwsKmsProviderOptions(Builder builder) {
        this.accessKeyId = (String)Assertions.notNull((String)"AWS KMS provider accessKeyId", (Object)builder.accessKeyId);
        this.secretAccessKey = (String)Assertions.notNull((String)"AWS KMS provider secretAccessKey", (Object)builder.secretAccessKey);
    }

    public static final class Builder {
        private String accessKeyId;
        private String secretAccessKey;

        private Builder() {
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public MongoAwsKmsProviderOptions build() {
            return new MongoAwsKmsProviderOptions(this);
        }
    }
}

