/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.internal.crypt.capi.BinaryHolder;
import com.mongodb.internal.crypt.capi.CAPI;
import com.mongodb.internal.crypt.capi.CAPIHelper;
import com.mongodb.internal.crypt.capi.CipherCallback;
import com.mongodb.internal.crypt.capi.Logger;
import com.mongodb.internal.crypt.capi.Loggers;
import com.mongodb.internal.crypt.capi.MacCallback;
import com.mongodb.internal.crypt.capi.MessageDigestCallback;
import com.mongodb.internal.crypt.capi.MongoCrypt;
import com.mongodb.internal.crypt.capi.MongoCryptContext;
import com.mongodb.internal.crypt.capi.MongoCryptContextImpl;
import com.mongodb.internal.crypt.capi.MongoCryptOptions;
import com.mongodb.internal.crypt.capi.MongoDataKeyOptions;
import com.mongodb.internal.crypt.capi.MongoExplicitEncryptOptions;
import com.mongodb.internal.crypt.capi.MongoRewrapManyDataKeyOptions;
import com.mongodb.internal.crypt.capi.SecureRandomCallback;
import com.mongodb.internal.crypt.capi.SigningRSAESPKCSCallback;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.assertions.Assertions;

class MongoCryptImpl
implements MongoCrypt {
    private static final Logger LOGGER = Loggers.getLogger();
    private final CAPI.mongocrypt_t wrapped;
    private final LogCallback logCallback;
    private final CipherCallback aesCBC256EncryptCallback;
    private final CipherCallback aesCBC256DecryptCallback;
    private final CipherCallback aesCTR256EncryptCallback;
    private final CipherCallback aesCTR256DecryptCallback;
    private final MacCallback hmacSha512Callback;
    private final MacCallback hmacSha256Callback;
    private final MessageDigestCallback sha256Callback;
    private final SecureRandomCallback secureRandomCallback;
    private final SigningRSAESPKCSCallback signingRSAESPKCSCallback;
    private final AtomicBoolean closed = new AtomicBoolean();

    MongoCryptImpl(MongoCryptOptions options) {
        Long keyExpirationMS;
        this.wrapped = CAPI.mongocrypt_new();
        if (this.wrapped == null) {
            throw new MongoCryptException("Unable to create new mongocrypt object");
        }
        this.logCallback = new LogCallback();
        CAPI.mongocrypt_setopt_enable_multiple_collinfo(this.wrapped);
        this.configure(() -> CAPI.mongocrypt_setopt_log_handler(this.wrapped, this.logCallback, null));
        if (CAPI.mongocrypt_is_crypto_available()) {
            LOGGER.debug("libmongocrypt is compiled with cryptography support, so not registering Java callbacks");
            this.aesCBC256EncryptCallback = null;
            this.aesCBC256DecryptCallback = null;
            this.aesCTR256EncryptCallback = null;
            this.aesCTR256DecryptCallback = null;
            this.hmacSha512Callback = null;
            this.hmacSha256Callback = null;
            this.sha256Callback = null;
            this.secureRandomCallback = null;
            this.signingRSAESPKCSCallback = null;
        } else {
            LOGGER.debug("libmongocrypt is compiled without cryptography support, so registering Java callbacks");
            this.aesCBC256EncryptCallback = new CipherCallback("AES", "AES/CBC/NoPadding", 1);
            this.aesCBC256DecryptCallback = new CipherCallback("AES", "AES/CBC/NoPadding", 2);
            this.aesCTR256EncryptCallback = new CipherCallback("AES", "AES/CTR/NoPadding", 1);
            this.aesCTR256DecryptCallback = new CipherCallback("AES", "AES/CTR/NoPadding", 2);
            this.hmacSha512Callback = new MacCallback("HmacSHA512");
            this.hmacSha256Callback = new MacCallback("HmacSHA256");
            this.sha256Callback = new MessageDigestCallback("SHA-256");
            this.secureRandomCallback = new SecureRandomCallback(new SecureRandom());
            this.configure(() -> CAPI.mongocrypt_setopt_crypto_hooks(this.wrapped, this.aesCBC256EncryptCallback, this.aesCBC256DecryptCallback, this.secureRandomCallback, this.hmacSha512Callback, this.hmacSha256Callback, this.sha256Callback, null));
            this.signingRSAESPKCSCallback = new SigningRSAESPKCSCallback();
            this.configure(() -> CAPI.mongocrypt_setopt_crypto_hook_sign_rsaes_pkcs1_v1_5(this.wrapped, this.signingRSAESPKCSCallback, null));
            this.configure(() -> CAPI.mongocrypt_setopt_aes_256_ctr(this.wrapped, this.aesCTR256EncryptCallback, this.aesCTR256DecryptCallback, null));
        }
        if (options.getLocalKmsProviderOptions() != null) {
            MongoCryptImpl.withBinaryHolder(options.getLocalKmsProviderOptions().getLocalMasterKey(), (CAPI.mongocrypt_binary_t binary) -> this.configure(() -> CAPI.mongocrypt_setopt_kms_provider_local(this.wrapped, binary)));
        }
        if (options.getAwsKmsProviderOptions() != null) {
            this.configure(() -> CAPI.mongocrypt_setopt_kms_provider_aws(this.wrapped, new CAPI.cstring(options.getAwsKmsProviderOptions().getAccessKeyId()), -1, new CAPI.cstring(options.getAwsKmsProviderOptions().getSecretAccessKey()), -1));
        }
        if (options.isNeedsKmsCredentialsStateEnabled()) {
            CAPI.mongocrypt_setopt_use_need_kms_credentials_state(this.wrapped);
        }
        if (options.getKmsProviderOptions() != null) {
            MongoCryptImpl.withBinaryHolder(options.getKmsProviderOptions(), (CAPI.mongocrypt_binary_t binary) -> this.configure(() -> CAPI.mongocrypt_setopt_kms_providers(this.wrapped, binary)));
        }
        if (options.getLocalSchemaMap() != null) {
            BsonDocument localSchemaMapDocument = new BsonDocument();
            localSchemaMapDocument.putAll(options.getLocalSchemaMap());
            MongoCryptImpl.withBinaryHolder(localSchemaMapDocument, (CAPI.mongocrypt_binary_t binary) -> this.configure(() -> CAPI.mongocrypt_setopt_schema_map(this.wrapped, binary)));
        }
        if (options.isBypassQueryAnalysis()) {
            CAPI.mongocrypt_setopt_bypass_query_analysis(this.wrapped);
        }
        if ((keyExpirationMS = options.getKeyExpirationMS()) != null) {
            this.configure(() -> CAPI.mongocrypt_setopt_key_expiration(this.wrapped, keyExpirationMS));
        }
        if (options.getEncryptedFieldsMap() != null) {
            BsonDocument localEncryptedFieldsMap = new BsonDocument();
            localEncryptedFieldsMap.putAll(options.getEncryptedFieldsMap());
            MongoCryptImpl.withBinaryHolder(localEncryptedFieldsMap, (CAPI.mongocrypt_binary_t binary) -> this.configure(() -> CAPI.mongocrypt_setopt_encrypted_field_config_map(this.wrapped, binary)));
        }
        options.getSearchPaths().forEach(p -> CAPI.mongocrypt_setopt_append_crypt_shared_lib_search_path(this.wrapped, new CAPI.cstring((String)p)));
        if (options.getExtraOptions().containsKey((Object)"cryptSharedLibPath")) {
            CAPI.mongocrypt_setopt_set_crypt_shared_lib_path_override(this.wrapped, new CAPI.cstring(options.getExtraOptions().getString((Object)"cryptSharedLibPath").getValue()));
        }
        this.configure(() -> CAPI.mongocrypt_init(this.wrapped));
    }

    @Override
    public MongoCryptContext createEncryptionContext(String database, BsonDocument commandDocument) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        Assertions.notNull((String)"database", (Object)database);
        Assertions.notNull((String)"commandDocument", (Object)commandDocument);
        return this.createMongoCryptContext(commandDocument, this.createNewMongoCryptContext(), (context, binary) -> CAPI.mongocrypt_ctx_encrypt_init(context, new CAPI.cstring(database), -1, binary));
    }

    @Override
    public MongoCryptContext createDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        return this.createMongoCryptContext(document, this.createNewMongoCryptContext(), CAPI::mongocrypt_ctx_decrypt_init);
    }

    @Override
    public MongoCryptContext createDataKeyContext(String kmsProvider, MongoDataKeyOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = this.createNewMongoCryptContext();
        BsonDocument keyDocument = new BsonDocument("provider", (BsonValue)new BsonString(kmsProvider));
        BsonDocument masterKey = options.getMasterKey();
        if (masterKey != null) {
            masterKey.forEach((arg_0, arg_1) -> ((BsonDocument)keyDocument).append(arg_0, arg_1));
        }
        MongoCryptImpl.withBinaryHolder(keyDocument, (CAPI.mongocrypt_binary_t binary) -> this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_key_encryption_key(context, binary)));
        if (options.getKeyAltNames() != null) {
            for (String cur : options.getKeyAltNames()) {
                MongoCryptImpl.withBinaryHolder(new BsonDocument("keyAltName", (BsonValue)new BsonString(cur)), (CAPI.mongocrypt_binary_t binary) -> this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_key_alt_name(context, binary)));
            }
        }
        if (options.getKeyMaterial() != null) {
            MongoCryptImpl.withBinaryHolder(new BsonDocument("keyMaterial", (BsonValue)new BsonBinary(options.getKeyMaterial())), (CAPI.mongocrypt_binary_t binary) -> this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_key_material(context, binary)));
        }
        this.configureContext(context, () -> CAPI.mongocrypt_ctx_datakey_init(context));
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createExplicitEncryptionContext(BsonDocument document, MongoExplicitEncryptOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        return this.createMongoCryptContext(document, this.configureExplicitEncryption(options), CAPI::mongocrypt_ctx_explicit_encrypt_init);
    }

    @Override
    public MongoCryptContext createEncryptExpressionContext(BsonDocument document, MongoExplicitEncryptOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        return this.createMongoCryptContext(document, this.configureExplicitEncryption(options), CAPI::mongocrypt_ctx_explicit_encrypt_expression_init);
    }

    @Override
    public MongoCryptContext createExplicitDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        return this.createMongoCryptContext(document, this.createNewMongoCryptContext(), CAPI::mongocrypt_ctx_explicit_decrypt_init);
    }

    @Override
    public MongoCryptContext createRewrapManyDatakeyContext(BsonDocument filter, MongoRewrapManyDataKeyOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = this.createNewMongoCryptContext();
        if (options != null && options.getProvider() != null) {
            BsonDocument keyDocument = new BsonDocument("provider", (BsonValue)new BsonString(options.getProvider()));
            BsonDocument masterKey = options.getMasterKey();
            if (masterKey != null) {
                masterKey.forEach((arg_0, arg_1) -> ((BsonDocument)keyDocument).append(arg_0, arg_1));
            }
            MongoCryptImpl.withBinaryHolder(keyDocument, (CAPI.mongocrypt_binary_t binary) -> this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_key_encryption_key(context, binary)));
        }
        return this.createMongoCryptContext(filter, context, CAPI::mongocrypt_ctx_rewrap_many_datakey_init);
    }

    @Override
    public String getCryptSharedLibVersionString() {
        CAPI.cstring versionString = CAPI.mongocrypt_crypt_shared_lib_version_string(this.wrapped, null);
        return versionString == null ? null : versionString.toString();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            CAPI.mongocrypt_destroy(this.wrapped);
        }
    }

    private MongoCryptContext createMongoCryptContext(BsonDocument document, CAPI.mongocrypt_ctx_t context, BiFunction<CAPI.mongocrypt_ctx_t, CAPI.mongocrypt_binary_t, Boolean> configureFunction) {
        MongoCryptImpl.withBinaryHolder(document, (CAPI.mongocrypt_binary_t binary) -> {
            if (!((Boolean)configureFunction.apply(context, (CAPI.mongocrypt_binary_t)((Object)binary))).booleanValue()) {
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
        });
        if (CAPI.mongocrypt_ctx_state(context) == 0) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        return new MongoCryptContextImpl(context);
    }

    private CAPI.mongocrypt_ctx_t createNewMongoCryptContext() {
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        return context;
    }

    private CAPI.mongocrypt_ctx_t configureExplicitEncryption(MongoExplicitEncryptOptions options) {
        CAPI.mongocrypt_ctx_t context = this.createNewMongoCryptContext();
        if (options.getKeyId() != null) {
            MongoCryptImpl.withBinaryHolder(ByteBuffer.wrap(options.getKeyId().getData()), (CAPI.mongocrypt_binary_t binary) -> this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_key_id(context, binary)));
        }
        if (options.getKeyAltName() != null) {
            MongoCryptImpl.withBinaryHolder(new BsonDocument("keyAltName", (BsonValue)new BsonString(options.getKeyAltName())), (CAPI.mongocrypt_binary_t binary) -> this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_key_alt_name(context, binary)));
        }
        if (options.getAlgorithm() != null) {
            this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_algorithm(context, new CAPI.cstring(options.getAlgorithm()), -1));
        }
        if (options.getQueryType() != null) {
            this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_query_type(context, new CAPI.cstring(options.getQueryType()), -1));
        }
        if (options.getContentionFactor() != null) {
            this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_contention_factor(context, options.getContentionFactor()));
        }
        if (options.getRangeOptions() != null) {
            MongoCryptImpl.withBinaryHolder(options.getRangeOptions(), (CAPI.mongocrypt_binary_t binary) -> this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_algorithm_range(context, binary)));
        }
        if (options.getTextOptions() != null) {
            MongoCryptImpl.withBinaryHolder(options.getTextOptions(), (CAPI.mongocrypt_binary_t binary) -> this.configureContext(context, () -> CAPI.mongocrypt_ctx_setopt_algorithm_text(context, binary)));
        }
        return context;
    }

    private void configure(Supplier<Boolean> successSupplier) {
        if (!successSupplier.get().booleanValue()) {
            this.throwExceptionFromStatus();
        }
    }

    private void configureContext(CAPI.mongocrypt_ctx_t context, Supplier<Boolean> successSupplier) {
        if (!successSupplier.get().booleanValue()) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
    }

    private void throwExceptionFromStatus() {
        CAPI.mongocrypt_status_t status = CAPI.mongocrypt_status_new();
        CAPI.mongocrypt_status(this.wrapped, status);
        MongoCryptException e = new MongoCryptException(CAPI.mongocrypt_status_message(status, null).toString(), CAPI.mongocrypt_status_code(status));
        CAPI.mongocrypt_status_destroy(status);
        throw e;
    }

    private static void withBinaryHolder(ByteBuffer value, Consumer<CAPI.mongocrypt_binary_t> consumer) {
        try (BinaryHolder binaryHolder = CAPIHelper.toBinary(value);){
            consumer.accept(binaryHolder.getBinary());
        }
    }

    private static void withBinaryHolder(BsonDocument value, Consumer<CAPI.mongocrypt_binary_t> consumer) {
        try (BinaryHolder binaryHolder = CAPIHelper.toBinary(value);){
            consumer.accept(binaryHolder.getBinary());
        }
    }

    static class LogCallback
    implements CAPI.mongocrypt_log_fn_t {
        LogCallback() {
        }

        @Override
        public void log(int level, CAPI.cstring message, int messageLength, Pointer ctx) {
            if (level == 0) {
                LOGGER.error(message.toString());
            }
            if (level == 1) {
                LOGGER.error(message.toString());
            }
            if (level == 2) {
                LOGGER.warn(message.toString());
            }
            if (level == 3) {
                LOGGER.info(message.toString());
            }
            if (level == 4) {
                LOGGER.trace(message.toString());
            }
        }
    }
}

