/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.SSLSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import java.util.Collections;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;

@Immutable
public final class MongoClientOptions {
    private final String description;
    private final ReadPreference readPreference;
    private final WriteConcern writeConcern;
    private final List<MongoCredential> credentialList;
    private final CodecRegistry codecRegistry;
    private final ClusterSettings clusterSettings;
    private final SocketSettings socketSettings;
    private final SocketSettings heartbeatSocketSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final ServerSettings serverSettings;
    private final SSLSettings sslSettings;

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public List<MongoCredential> getCredentialList() {
        return this.credentialList;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public SSLSettings getSslSettings() {
        return this.sslSettings;
    }

    public SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    public SocketSettings getHeartbeatSocketSettings() {
        return this.heartbeatSocketSettings;
    }

    public ConnectionPoolSettings getConnectionPoolSettings() {
        return this.connectionPoolSettings;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    private MongoClientOptions(Builder builder) {
        this.description = builder.description;
        this.readPreference = builder.readPreference;
        this.writeConcern = builder.writeConcern;
        this.credentialList = builder.credentialList;
        this.codecRegistry = builder.codecRegistry;
        this.clusterSettings = builder.clusterSettings;
        this.serverSettings = builder.serverSettings;
        this.socketSettings = builder.socketSettings;
        this.heartbeatSocketSettings = builder.heartbeatSocketSettings;
        this.connectionPoolSettings = builder.connectionPoolSettings;
        this.sslSettings = builder.sslSettings;
    }

    public static final class Builder {
        private String description;
        private ReadPreference readPreference = ReadPreference.primary();
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private CodecRegistry codecRegistry = MongoClientImpl.getDefaultCodecRegistry();
        private ClusterSettings clusterSettings;
        private SocketSettings socketSettings = SocketSettings.builder().build();
        private SocketSettings heartbeatSocketSettings = SocketSettings.builder().build();
        private ConnectionPoolSettings connectionPoolSettings = ConnectionPoolSettings.builder().maxSize(100).maxWaitQueueSize(500).build();
        private ServerSettings serverSettings = ServerSettings.builder().build();
        private SSLSettings sslSettings = SSLSettings.builder().build();
        private List<MongoCredential> credentialList = Collections.emptyList();

        private Builder() {
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder clusterSettings(ClusterSettings clusterSettings) {
            this.clusterSettings = (ClusterSettings)Assertions.notNull((String)"clusterSettings", (Object)clusterSettings);
            return this;
        }

        public Builder socketSettings(SocketSettings socketSettings) {
            this.socketSettings = (SocketSettings)Assertions.notNull((String)"socketSettings", (Object)socketSettings);
            return this;
        }

        public Builder heartbeatSocketSettings(SocketSettings heartbeatSocketSettings) {
            this.heartbeatSocketSettings = (SocketSettings)Assertions.notNull((String)"heartbeatSocketSettings", (Object)heartbeatSocketSettings);
            return this;
        }

        public Builder connectionPoolSettings(ConnectionPoolSettings connectionPoolSettings) {
            this.connectionPoolSettings = (ConnectionPoolSettings)Assertions.notNull((String)"connectionPoolSettings", (Object)connectionPoolSettings);
            return this;
        }

        public Builder serverSettings(ServerSettings serverSettings) {
            this.serverSettings = (ServerSettings)Assertions.notNull((String)"serverSettings", (Object)serverSettings);
            return this;
        }

        public Builder sslSettings(SSLSettings sslSettings) {
            this.sslSettings = (SSLSettings)Assertions.notNull((String)"sslSettings", (Object)sslSettings);
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
            return this;
        }

        public Builder credentialList(List<MongoCredential> credentialList) {
            this.credentialList = Collections.unmodifiableList((List)Assertions.notNull((String)"credentialList", credentialList));
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
            return this;
        }

        public MongoClientOptions build() {
            return new MongoClientOptions(this);
        }
    }
}

