/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoClient;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

class KeyRetriever
implements Closeable {
    private final MongoClient client;
    private final boolean ownsClient;
    private final MongoNamespace namespace;

    KeyRetriever(MongoClient client, boolean ownsClient, MongoNamespace namespace) {
        this.client = (MongoClient)Assertions.notNull((String)"client", (Object)client);
        this.ownsClient = ownsClient;
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
    }

    public void find(BsonDocument keyFilter, SingleResultCallback<List<BsonDocument>> callback) {
        this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class).find((Bson)keyFilter).into(new ArrayList(), callback);
    }

    @Override
    public void close() {
        if (this.ownsClient) {
            this.client.close();
        }
    }
}

