/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.internal.CollectionInfoRetriever;
import com.mongodb.async.client.internal.CommandMarker;
import com.mongodb.async.client.internal.KeyManagementService;
import com.mongodb.async.client.internal.KeyRetriever;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoDataKeyOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.List;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

public class Crypt
implements Closeable {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoCrypt mongoCrypt;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService) {
        this(mongoCrypt, null, null, keyRetriever, keyManagementService, false);
    }

    Crypt(MongoCrypt mongoCrypt, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, KeyRetriever keyRetriever, KeyManagementService keyManagementService, boolean bypassAutoEncryption) {
        this.mongoCrypt = mongoCrypt;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.bypassAutoEncryption = bypassAutoEncryption;
    }

    public void encrypt(String databaseName, RawBsonDocument command, final SingleResultCallback<RawBsonDocument> callback) {
        Assertions.notNull((String)"databaseName", (Object)databaseName);
        Assertions.notNull((String)"command", (Object)command);
        if (this.bypassAutoEncryption) {
            callback.onResult((Object)command, null);
            return;
        }
        try {
            final MongoCryptContext encryptionContext = this.mongoCrypt.createEncryptionContext(databaseName, (BsonDocument)command);
            this.executeStateMachine(encryptionContext, databaseName, this.createCallback(new SingleResultCallback<RawBsonDocument>(){

                public void onResult(RawBsonDocument result, Throwable t) {
                    encryptionContext.close();
                    callback.onResult((Object)result, t);
                }
            }));
        }
        catch (MongoCryptException e) {
            callback.onResult(null, (Throwable)this.wrapInClientException(e));
        }
    }

    public void decrypt(RawBsonDocument commandResponse, final SingleResultCallback<RawBsonDocument> callback) {
        Assertions.notNull((String)"commandResponse", (Object)commandResponse);
        try {
            final MongoCryptContext decryptionContext = this.mongoCrypt.createDecryptionContext((BsonDocument)commandResponse);
            this.executeStateMachine(decryptionContext, null, this.createCallback(new SingleResultCallback<RawBsonDocument>(){

                public void onResult(RawBsonDocument result, Throwable t) {
                    decryptionContext.close();
                    callback.onResult((Object)result, t);
                }
            }));
        }
        catch (Throwable t) {
            callback.onResult(null, (Throwable)this.wrapInClientException(t));
        }
    }

    public void createDataKey(String kmsProvider, DataKeyOptions options, final SingleResultCallback<RawBsonDocument> callback) {
        Assertions.notNull((String)"kmsProvider", (Object)kmsProvider);
        Assertions.notNull((String)"options", (Object)options);
        try {
            final MongoCryptContext dataKeyCreationContext = this.mongoCrypt.createDataKeyContext(kmsProvider, MongoDataKeyOptions.builder().keyAltNames(options.getKeyAltNames()).masterKey(options.getMasterKey()).build());
            this.executeStateMachine(dataKeyCreationContext, null, this.createCallback(new SingleResultCallback<RawBsonDocument>(){

                public void onResult(RawBsonDocument result, Throwable t) {
                    dataKeyCreationContext.close();
                    callback.onResult((Object)result, t);
                }
            }));
        }
        catch (Throwable t) {
            callback.onResult(null, (Throwable)this.wrapInClientException(t));
        }
    }

    public void encryptExplicitly(BsonValue value, EncryptOptions options, final SingleResultCallback<BsonBinary> callback) {
        Assertions.notNull((String)"value", (Object)value);
        Assertions.notNull((String)"options", (Object)options);
        try {
            MongoExplicitEncryptOptions.Builder encryptOptionsBuilder = MongoExplicitEncryptOptions.builder().algorithm(options.getAlgorithm());
            if (options.getKeyId() != null) {
                encryptOptionsBuilder.keyId(options.getKeyId());
            }
            if (options.getKeyAltName() != null) {
                encryptOptionsBuilder.keyAltName(options.getKeyAltName());
            }
            final MongoCryptContext encryptionContext = this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", value), encryptOptionsBuilder.build());
            this.executeStateMachine(encryptionContext, null, this.createCallback(new SingleResultCallback<RawBsonDocument>(){

                public void onResult(RawBsonDocument result, Throwable t) {
                    encryptionContext.close();
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult((Object)result.getBinary((Object)"v"), null);
                    }
                }
            }));
        }
        catch (Throwable t) {
            callback.onResult(null, (Throwable)this.wrapInClientException(t));
        }
    }

    public void decryptExplicitly(BsonBinary value, final SingleResultCallback<BsonValue> callback) {
        Assertions.notNull((String)"value", (Object)value);
        try {
            final MongoCryptContext decryptionContext = this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", (BsonValue)value));
            this.executeStateMachine(decryptionContext, null, this.createCallback(new SingleResultCallback<RawBsonDocument>(){

                public void onResult(RawBsonDocument result, Throwable t) {
                    decryptionContext.close();
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult((Object)result.get((Object)"v"), null);
                    }
                }
            }));
        }
        catch (Throwable t) {
            callback.onResult(null, (Throwable)this.wrapInClientException(t));
        }
    }

    @Override
    public void close() {
        this.mongoCrypt.close();
        if (this.commandMarker != null) {
            this.commandMarker.close();
        }
        this.keyRetriever.close();
    }

    private void executeStateMachine(MongoCryptContext cryptContext, String databaseName, SingleResultCallback<RawBsonDocument> callback) {
        MongoCryptContext.State state = cryptContext.getState();
        switch (state) {
            case NEED_MONGO_COLLINFO: {
                this.collInfo(cryptContext, databaseName, callback);
                break;
            }
            case NEED_MONGO_MARKINGS: {
                this.mark(cryptContext, databaseName, callback);
                break;
            }
            case NEED_MONGO_KEYS: {
                this.fetchKeys(cryptContext, databaseName, callback);
                break;
            }
            case NEED_KMS: {
                this.decryptKeys(cryptContext, databaseName, callback);
                break;
            }
            case READY: {
                callback.onResult((Object)cryptContext.finish(), null);
                break;
            }
            default: {
                callback.onResult(null, (Throwable)new MongoInternalException("Unsupported encryptor state + " + state));
            }
        }
    }

    private void collInfo(final MongoCryptContext cryptContext, final String databaseName, final SingleResultCallback<RawBsonDocument> callback) {
        this.collectionInfoRetriever.filter(databaseName, (BsonDocument)cryptContext.getMongoOperation(), this.createCallback(new SingleResultCallback<BsonDocument>(){

            public void onResult(BsonDocument result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    try {
                        if (result != null) {
                            cryptContext.addMongoOperationResult(result);
                        }
                        cryptContext.completeMongoOperation();
                        Crypt.this.executeStateMachine(cryptContext, databaseName, (SingleResultCallback<RawBsonDocument>)callback);
                    }
                    catch (Throwable t1) {
                        callback.onResult(null, (Throwable)Crypt.this.wrapInClientException(t1));
                    }
                }
            }
        }));
    }

    private void mark(final MongoCryptContext cryptContext, final String databaseName, final SingleResultCallback<RawBsonDocument> callback) {
        this.commandMarker.mark(databaseName, cryptContext.getMongoOperation(), this.createCallback(new SingleResultCallback<RawBsonDocument>(){

            public void onResult(RawBsonDocument result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    try {
                        cryptContext.addMongoOperationResult((BsonDocument)result);
                        cryptContext.completeMongoOperation();
                        Crypt.this.executeStateMachine(cryptContext, databaseName, (SingleResultCallback<RawBsonDocument>)callback);
                    }
                    catch (Throwable t1) {
                        callback.onResult(null, (Throwable)Crypt.this.wrapInClientException(t1));
                    }
                }
            }
        }));
    }

    private void fetchKeys(final MongoCryptContext cryptContext, final String databaseName, final SingleResultCallback<RawBsonDocument> callback) {
        this.keyRetriever.find((BsonDocument)cryptContext.getMongoOperation(), this.createCallback(new SingleResultCallback<List<BsonDocument>>(){

            public void onResult(List<BsonDocument> results, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    try {
                        for (BsonDocument result : results) {
                            cryptContext.addMongoOperationResult(result);
                        }
                        cryptContext.completeMongoOperation();
                        Crypt.this.executeStateMachine(cryptContext, databaseName, (SingleResultCallback<RawBsonDocument>)callback);
                    }
                    catch (Throwable t1) {
                        callback.onResult(null, (Throwable)Crypt.this.wrapInClientException(t1));
                    }
                }
            }
        }));
    }

    private void decryptKeys(final MongoCryptContext cryptContext, final String databaseName, final SingleResultCallback<RawBsonDocument> callback) {
        MongoKeyDecryptor keyDecryptor = cryptContext.nextKeyDecryptor();
        if (keyDecryptor != null) {
            this.keyManagementService.decryptKey(keyDecryptor, this.createCallback(new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, (Throwable)Crypt.this.wrapInClientException(t));
                    } else {
                        Crypt.this.decryptKeys(cryptContext, databaseName, (SingleResultCallback<RawBsonDocument>)callback);
                    }
                }
            }));
        } else {
            try {
                cryptContext.completeKeyDecryptors();
                this.executeStateMachine(cryptContext, databaseName, callback);
            }
            catch (Throwable t1) {
                callback.onResult(null, (Throwable)this.wrapInClientException(t1));
            }
        }
    }

    private MongoClientException wrapInClientException(Throwable t) {
        return new MongoClientException("Exception in encryption library: " + t.getMessage(), t);
    }

    private <T> SingleResultCallback<T> createCallback(SingleResultCallback<T> callback) {
        return ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
    }
}

