/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.CursorType;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.OperationIterable;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.FindOperation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class FindIterableImpl<TDocument, TResult>
implements FindIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final AsyncOperationExecutor executor;
    private final FindOptions findOptions;
    private Bson filter;

    FindIterableImpl(MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, AsyncOperationExecutor executor, Bson filter, FindOptions findOptions) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.filter = (Bson)Assertions.notNull((String)"filter", (Object)filter);
        this.findOptions = (FindOptions)Assertions.notNull((String)"findOptions", (Object)findOptions);
    }

    @Override
    public FindIterable<TResult> filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public FindIterable<TResult> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public FindIterable<TResult> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public FindIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> batchSize(int batchSize) {
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public FindIterable<TResult> modifiers(Bson modifiers) {
        this.findOptions.modifiers(modifiers);
        return this;
    }

    @Override
    public FindIterable<TResult> projection(Bson projection) {
        this.findOptions.projection(projection);
        return this;
    }

    @Override
    public FindIterable<TResult> sort(Bson sort) {
        this.findOptions.sort(sort);
        return this;
    }

    @Override
    public FindIterable<TResult> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    public FindIterable<TResult> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindIterable<TResult> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public FindIterable<TResult> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public void first(SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute(this.createQueryOperation().batchSize(0).limit(-1)).first(callback);
    }

    @Override
    public void forEach(Block<? super TResult> block, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.execute().forEach(block, callback);
    }

    @Override
    public <A extends Collection<? super TResult>> void into(A target, SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.execute().into(target, callback);
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.execute().batchCursor(callback);
    }

    private MongoIterable<TResult> execute() {
        return this.execute(this.createQueryOperation());
    }

    private MongoIterable<TResult> execute(FindOperation<TResult> operation) {
        return new OperationIterable(operation, this.readPreference, this.executor);
    }

    private FindOperation<TResult> createQueryOperation() {
        return new FindOperation(this.namespace, (Decoder)this.codecRegistry.get(this.resultClass)).filter(this.toBsonDocument(this.filter)).batchSize(this.findOptions.getBatchSize()).skip(this.findOptions.getSkip()).limit(this.findOptions.getLimit()).maxTime(this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).maxAwaitTime(this.findOptions.getMaxAwaitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).modifiers(this.toBsonDocument(this.findOptions.getModifiers())).projection(this.toBsonDocument(this.findOptions.getProjection())).sort(this.toBsonDocument(this.findOptions.getSort())).cursorType(this.findOptions.getCursorType()).noCursorTimeout(this.findOptions.isNoCursorTimeout()).oplogReplay(this.findOptions.isOplogReplay()).partial(this.findOptions.isPartial()).slaveOk(this.readPreference.isSlaveOk()).readConcern(this.readConcern);
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(this.documentClass, this.codecRegistry);
    }
}

