/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Function;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.AsyncOperationExecutorImpl;
import com.mongodb.async.client.ListDatabasesIterable;
import com.mongodb.async.client.ListDatabasesIterableImpl;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoDatabaseImpl;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.connection.Cluster;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.operation.AsyncOperationExecutor;
import java.io.Closeable;
import java.io.IOException;
import org.bson.BsonDocument;
import org.bson.Document;

class MongoClientImpl
implements MongoClient {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final Cluster cluster;
    private final MongoClientSettings settings;
    private final AsyncOperationExecutor executor;
    private final Closeable externalResourceCloser;
    private final ServerSessionPool serverSessionPool;

    MongoClientImpl(MongoClientSettings settings, Cluster cluster, Closeable externalResourceCloser) {
        this(settings, cluster, null, externalResourceCloser);
    }

    MongoClientImpl(MongoClientSettings settings, Cluster cluster, AsyncOperationExecutor executor) {
        this(settings, cluster, executor, null);
    }

    private MongoClientImpl(MongoClientSettings settings, Cluster cluster, AsyncOperationExecutor executor, Closeable externalResourceCloser) {
        this.settings = (MongoClientSettings)Assertions.notNull((String)"settings", (Object)settings);
        this.cluster = (Cluster)Assertions.notNull((String)"cluster", (Object)cluster);
        this.executor = executor == null ? new AsyncOperationExecutorImpl(this) : executor;
        this.externalResourceCloser = externalResourceCloser;
        this.serverSessionPool = new ServerSessionPool(cluster);
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(name, this.settings.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getWriteConcern(), this.settings.getRetryWrites(), this.settings.getReadConcern(), this.executor);
    }

    @Override
    public void close() {
        this.serverSessionPool.close();
        this.cluster.close();
        if (this.externalResourceCloser != null) {
            try {
                this.externalResourceCloser.close();
            }
            catch (IOException e) {
                LOGGER.warn("Exception closing resource", (Throwable)e);
            }
        }
    }

    @Override
    public MongoClientSettings getSettings() {
        return this.settings;
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return new ListDatabasesIterableImpl<BsonDocument>(BsonDocument.class, MongoClients.getDefaultCodecRegistry(), ReadPreference.primary(), this.executor).map(new Function<BsonDocument, String>(){

            public String apply(BsonDocument document) {
                return document.getString((Object)"name").getValue();
            }
        });
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> resultClass) {
        return new ListDatabasesIterableImpl<T>(resultClass, this.settings.getCodecRegistry(), ReadPreference.primary(), this.executor);
    }

    Cluster getCluster() {
        return this.cluster;
    }

    ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }
}

