/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.session.ClientSession;
import java.util.Collection;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

abstract class MongoIterableImpl<TResult>
implements MongoIterable<TResult> {
    private final ClientSession clientSession;
    private final ReadConcern readConcern;
    private AsyncOperationExecutor executor;
    private ReadPreference readPreference;
    private Integer batchSize;

    MongoIterableImpl(ClientSession clientSession, AsyncOperationExecutor executor, ReadConcern readConcern, ReadPreference readPreference) {
        this.clientSession = clientSession;
        this.executor = (AsyncOperationExecutor)com.mongodb.assertions.Assertions.notNull((String)"executor", (Object)executor);
        this.readConcern = (ReadConcern)com.mongodb.assertions.Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.readPreference = (ReadPreference)com.mongodb.assertions.Assertions.notNull((String)"readPreference", (Object)readPreference);
    }

    abstract AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation();

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    AsyncOperationExecutor getExecutor() {
        return this.executor;
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void forEach(final Block<? super TResult> block, final SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    MongoIterableImpl.this.loopCursor(batchCursor, block, (SingleResultCallback<Void>)callback);
                }
            }
        });
    }

    @Override
    public <A extends Collection<? super TResult>> void into(final A target, final SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    MongoIterableImpl.this.loopCursor(batchCursor, new Block<TResult>(){

                        public void apply(TResult t) {
                            target.add(t);
                        }
                    }, (SingleResultCallback<Void>)((SingleResultCallback)new SingleResultCallback<Void>(){

                        public void onResult(Void result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult((Object)target, null);
                            }
                        }
                    }));
                }
            }
        });
    }

    @Override
    public void first(final SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(final AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    batchCursor.setBatchSize(1);
                    batchCursor.next(new SingleResultCallback<List<TResult>>(){

                        public void onResult(List<TResult> results, Throwable t) {
                            batchCursor.close();
                            if (t != null) {
                                callback.onResult(null, t);
                            } else if (results == null) {
                                callback.onResult(null, null);
                            } else {
                                callback.onResult(results.get(0), null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public MongoIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
        com.mongodb.assertions.Assertions.notNull((String)"callback", callback);
        this.executor.execute(this.asAsyncReadOperation(), this.readPreference, this.clientSession, callback);
    }

    BsonDocument toBsonDocumentOrNull(Bson document, CodecRegistry codecRegistry) {
        return this.toBsonDocumentOrNull(document, BsonDocument.class, codecRegistry);
    }

    <T> BsonDocument toBsonDocumentOrNull(Bson document, Class<T> documentClass, CodecRegistry codecRegistry) {
        return document == null ? null : document.toBsonDocument(documentClass, codecRegistry);
    }

    private void loopCursor(final AsyncBatchCursor<TResult> batchCursor, final Block<? super TResult> block, final SingleResultCallback<Void> callback) {
        batchCursor.next(new SingleResultCallback<List<TResult>>(){

            public void onResult(List<TResult> results, Throwable t) {
                if (t != null || results == null) {
                    batchCursor.close();
                    callback.onResult(null, t);
                } else {
                    try {
                        for (Object result : results) {
                            block.apply(result);
                        }
                        MongoIterableImpl.this.loopCursor(batchCursor, block, (SingleResultCallback<Void>)callback);
                    }
                    catch (Throwable tr) {
                        batchCursor.close();
                        callback.onResult(null, tr);
                    }
                }
            }
        });
    }
}

