/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AsyncOperationExecutorImpl;
import com.mongodb.async.client.ClientSessionHelper;
import com.mongodb.async.client.ListDatabasesIterable;
import com.mongodb.async.client.ListDatabasesIterableImpl;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoDatabaseImpl;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.connection.Cluster;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.session.ClientSession;
import java.io.Closeable;
import java.io.IOException;
import org.bson.BsonDocument;
import org.bson.Document;

class MongoClientImpl
implements MongoClient {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final Cluster cluster;
    private final MongoClientSettings settings;
    private final AsyncOperationExecutor executor;
    private final Closeable externalResourceCloser;
    private final ServerSessionPool serverSessionPool;
    private final ClientSessionHelper clientSessionHelper;

    MongoClientImpl(MongoClientSettings settings, Cluster cluster, Closeable externalResourceCloser) {
        this(settings, cluster, null, externalResourceCloser);
    }

    MongoClientImpl(MongoClientSettings settings, Cluster cluster, AsyncOperationExecutor executor) {
        this(settings, cluster, executor, null);
    }

    private MongoClientImpl(MongoClientSettings settings, Cluster cluster, AsyncOperationExecutor executor, Closeable externalResourceCloser) {
        this.settings = (MongoClientSettings)Assertions.notNull((String)"settings", (Object)settings);
        this.cluster = (Cluster)Assertions.notNull((String)"cluster", (Object)cluster);
        this.serverSessionPool = new ServerSessionPool(cluster);
        this.clientSessionHelper = new ClientSessionHelper(this, this.serverSessionPool);
        this.executor = executor == null ? new AsyncOperationExecutorImpl(this, this.clientSessionHelper) : executor;
        this.externalResourceCloser = externalResourceCloser;
    }

    @Override
    public void startSession(ClientSessionOptions options, final SingleResultCallback<ClientSession> callback) {
        Assertions.notNull((String)"callback", callback);
        this.clientSessionHelper.createClientSession((ClientSessionOptions)Assertions.notNull((String)"options", (Object)options), new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback((SingleResultCallback)callback, (Logger)LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else if (clientSession == null) {
                    errHandlingCallback.onResult(null, (Throwable)new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected"));
                } else {
                    errHandlingCallback.onResult((Object)clientSession, null);
                }
            }
        });
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(name, this.settings.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getWriteConcern(), this.settings.getRetryWrites(), this.settings.getReadConcern(), this.executor);
    }

    @Override
    public void close() {
        this.serverSessionPool.close();
        this.cluster.close();
        if (this.externalResourceCloser != null) {
            try {
                this.externalResourceCloser.close();
            }
            catch (IOException e) {
                LOGGER.warn("Exception closing resource", (Throwable)e);
            }
        }
    }

    @Override
    public MongoClientSettings getSettings() {
        return this.settings;
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    private MongoIterable<String> createListDatabaseNamesIterable(ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(new Function<BsonDocument, String>(){

            public String apply(BsonDocument result) {
                return result.getString((Object)"name").getValue();
            }
        });
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.createListDatabasesIterable(null, Document.class);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> resultClass) {
        return this.createListDatabasesIterable(null, resultClass);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListDatabasesIterable(clientSession, resultClass);
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.settings.getCodecRegistry(), ReadPreference.primary(), this.executor);
    }

    Cluster getCluster() {
        return this.cluster;
    }

    ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }
}

