/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.event.CommandListener;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;

@Immutable
@Deprecated
public final class MongoClientSettings {
    private final com.mongodb.MongoClientSettings wrapped;
    private final SocketSettings heartbeatSocketSettings;
    private final List<MongoCredential> credentialList;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoClientSettings settings) {
        return new Builder(settings);
    }

    static MongoClientSettings createFromClientSettings(com.mongodb.MongoClientSettings wrapped) {
        return new Builder(wrapped).build();
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Deprecated
    public List<MongoCredential> getCredentialList() {
        return this.credentialList;
    }

    @Nullable
    public MongoCredential getCredential() {
        Assertions.isTrue((String)"Single or no credential", (this.credentialList.size() <= 1 ? 1 : 0) != 0);
        return this.wrapped.getCredential();
    }

    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    public boolean getRetryWrites() {
        return this.wrapped.getRetryWrites();
    }

    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    @Nullable
    public StreamFactoryFactory getStreamFactoryFactory() {
        return this.wrapped.getStreamFactoryFactory();
    }

    public List<CommandListener> getCommandListeners() {
        return this.wrapped.getCommandListeners();
    }

    @Nullable
    public String getApplicationName() {
        return this.wrapped.getApplicationName();
    }

    public List<MongoCompressor> getCompressorList() {
        return this.wrapped.getCompressorList();
    }

    public ClusterSettings getClusterSettings() {
        return this.wrapped.getClusterSettings();
    }

    public SslSettings getSslSettings() {
        return this.wrapped.getSslSettings();
    }

    public SocketSettings getSocketSettings() {
        return this.wrapped.getSocketSettings();
    }

    public SocketSettings getHeartbeatSocketSettings() {
        return this.heartbeatSocketSettings != null ? this.heartbeatSocketSettings : this.wrapped.getHeartbeatSocketSettings();
    }

    public ConnectionPoolSettings getConnectionPoolSettings() {
        return this.wrapped.getConnectionPoolSettings();
    }

    public ServerSettings getServerSettings() {
        return this.wrapped.getServerSettings();
    }

    private MongoClientSettings(Builder builder) {
        this.wrapped = builder.wrappedBuilder.build();
        this.credentialList = builder.credentialList;
        this.heartbeatSocketSettings = builder.heartbeatSocketSettingsBuilder != null ? builder.heartbeatSocketSettingsBuilder.build() : null;
    }

    @NotThreadSafe
    public static final class Builder {
        private final MongoClientSettings.Builder wrappedBuilder;
        private List<MongoCredential> credentialList = Collections.emptyList();
        private SocketSettings.Builder heartbeatSocketSettingsBuilder = null;

        private Builder() {
            this.wrappedBuilder = com.mongodb.MongoClientSettings.builder();
        }

        private Builder(com.mongodb.MongoClientSettings settings) {
            Assertions.notNull((String)"settings", (Object)settings);
            this.wrappedBuilder = com.mongodb.MongoClientSettings.builder((com.mongodb.MongoClientSettings)settings);
            MongoCredential credential = settings.getCredential();
            if (credential != null) {
                this.credentialList(Collections.singletonList(credential));
            }
        }

        private Builder(MongoClientSettings settings) {
            this(((MongoClientSettings)Assertions.notNull((String)"settings", (Object)settings)).wrapped);
            this.credentialList = new ArrayList<MongoCredential>(settings.credentialList);
            if (settings.heartbeatSocketSettings != null) {
                this.heartbeatSocketSettings(settings.heartbeatSocketSettings);
            }
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            this.credentialList = new ArrayList<MongoCredential>(connectionString.getCredentialList());
            this.wrappedBuilder.applyConnectionString(connectionString);
            return this;
        }

        public Builder applyToClusterSettings(Block<ClusterSettings.Builder> block) {
            this.wrappedBuilder.applyToClusterSettings(block);
            return this;
        }

        public Builder applyToSocketSettings(Block<SocketSettings.Builder> block) {
            this.wrappedBuilder.applyToSocketSettings(block);
            return this;
        }

        public Builder applyToConnectionPoolSettings(Block<ConnectionPoolSettings.Builder> block) {
            this.wrappedBuilder.applyToConnectionPoolSettings(block);
            return this;
        }

        public Builder applyToServerSettings(Block<ServerSettings.Builder> block) {
            this.wrappedBuilder.applyToServerSettings(block);
            return this;
        }

        public Builder applyToSslSettings(Block<SslSettings.Builder> block) {
            this.wrappedBuilder.applyToSslSettings(block);
            return this;
        }

        @Deprecated
        public Builder clusterSettings(final ClusterSettings clusterSettings) {
            this.wrappedBuilder.applyToClusterSettings((Block)new Block<ClusterSettings.Builder>(){

                public void apply(ClusterSettings.Builder builder) {
                    builder.applySettings(clusterSettings);
                }
            });
            return this;
        }

        @Deprecated
        public Builder socketSettings(final SocketSettings socketSettings) {
            this.wrappedBuilder.applyToSocketSettings((Block)new Block<SocketSettings.Builder>(){

                public void apply(SocketSettings.Builder builder) {
                    builder.applySettings(socketSettings);
                }
            });
            return this;
        }

        @Deprecated
        public Builder heartbeatSocketSettings(SocketSettings heartbeatSocketSettings) {
            if (this.heartbeatSocketSettingsBuilder == null) {
                this.heartbeatSocketSettingsBuilder = SocketSettings.builder();
            }
            this.heartbeatSocketSettingsBuilder.applySettings(heartbeatSocketSettings);
            return this;
        }

        @Deprecated
        public Builder connectionPoolSettings(final ConnectionPoolSettings connectionPoolSettings) {
            this.wrappedBuilder.applyToConnectionPoolSettings((Block)new Block<ConnectionPoolSettings.Builder>(){

                public void apply(ConnectionPoolSettings.Builder builder) {
                    builder.applySettings(connectionPoolSettings);
                }
            });
            return this;
        }

        @Deprecated
        public Builder serverSettings(final ServerSettings serverSettings) {
            this.wrappedBuilder.applyToServerSettings((Block)new Block<ServerSettings.Builder>(){

                public void apply(ServerSettings.Builder builder) {
                    builder.applySettings(serverSettings);
                }
            });
            return this;
        }

        @Deprecated
        public Builder sslSettings(final SslSettings sslSettings) {
            this.wrappedBuilder.applyToSslSettings((Block)new Block<SslSettings.Builder>(){

                public void apply(SslSettings.Builder builder) {
                    builder.applySettings(sslSettings);
                }
            });
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.wrappedBuilder.readPreference(readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.wrappedBuilder.writeConcern(writeConcern);
            return this;
        }

        public Builder retryWrites(boolean retryWrites) {
            this.wrappedBuilder.retryWrites(retryWrites);
            return this;
        }

        public Builder readConcern(ReadConcern readConcern) {
            this.wrappedBuilder.readConcern(readConcern);
            return this;
        }

        @Deprecated
        public Builder credentialList(List<MongoCredential> credentialList) {
            this.credentialList = Collections.unmodifiableList((List)Assertions.notNull((String)"credentialList", credentialList));
            if (!credentialList.isEmpty()) {
                this.wrappedBuilder.credential(credentialList.get(credentialList.size() - 1));
            }
            return this;
        }

        public Builder credential(MongoCredential credential) {
            this.credentialList = Collections.singletonList(Assertions.notNull((String)"credential", (Object)credential));
            this.wrappedBuilder.credential(credential);
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.wrappedBuilder.codecRegistry(codecRegistry);
            return this;
        }

        public Builder streamFactoryFactory(StreamFactoryFactory streamFactoryFactory) {
            this.wrappedBuilder.streamFactoryFactory(streamFactoryFactory);
            return this;
        }

        public Builder addCommandListener(CommandListener commandListener) {
            this.wrappedBuilder.addCommandListener(commandListener);
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.wrappedBuilder.applicationName(applicationName);
            return this;
        }

        public Builder compressorList(List<MongoCompressor> compressorList) {
            this.wrappedBuilder.compressorList(compressorList);
            return this;
        }

        public MongoClientSettings build() {
            return new MongoClientSettings(this);
        }
    }
}

