/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadStream;
import java.nio.ByteBuffer;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class GridFSUploadPublisherImpl
implements GridFSUploadPublisher<Success> {
    private final GridFSUploadStream gridFSUploadStream;
    private final Publisher<ByteBuffer> source;

    GridFSUploadPublisherImpl(GridFSUploadStream gridFSUploadStream, Publisher<ByteBuffer> source) {
        this.gridFSUploadStream = gridFSUploadStream;
        this.source = source;
    }

    @Override
    public ObjectId getObjectId() {
        return this.gridFSUploadStream.getObjectId();
    }

    @Override
    public BsonValue getId() {
        return this.gridFSUploadStream.getId();
    }

    public void subscribe(Subscriber<? super Success> s) {
        s.onSubscribe((Subscription)new GridFSUploadSubscription(s));
    }

    GridFSUploadPublisher<ObjectId> withObjectId() {
        final GridFSUploadPublisherImpl wrapped = this;
        return new GridFSUploadPublisher<ObjectId>(){

            @Override
            public ObjectId getObjectId() {
                return wrapped.getObjectId();
            }

            @Override
            public BsonValue getId() {
                return wrapped.getId();
            }

            public void subscribe(final Subscriber<? super ObjectId> objectIdSub) {
                wrapped.subscribe((Subscriber<? super Success>)new Subscriber<Success>(){

                    public void onSubscribe(Subscription s) {
                        objectIdSub.onSubscribe(s);
                    }

                    public void onNext(Success success) {
                        objectIdSub.onNext((Object)this.getObjectId());
                    }

                    public void onError(Throwable t) {
                        objectIdSub.onError(t);
                    }

                    public void onComplete() {
                        objectIdSub.onComplete();
                    }
                });
            }
        };
    }

    static enum NextStep {
        SUBSCRIBE,
        REQUEST_MORE,
        COMPLETE,
        TERMINATE,
        DO_NOTHING;

    }

    static enum Action {
        WAITING,
        REQUESTING_MORE,
        IN_PROGRESS,
        TERMINATE,
        COMPLETE,
        FINISHED;

    }

    class GridFSUploadSubscription
    implements Subscription {
        private final Subscriber<? super Success> outerSubscriber;
        private boolean hasCompleted;
        private boolean unsubscribed;
        private Action currentAction = Action.WAITING;
        private Subscription sourceSubscription;
        private final Subscriber<ByteBuffer> sourceSubscriber = new Subscriber<ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSubscribe(Subscription s) {
                GridFSUploadSubscription gridFSUploadSubscription = GridFSUploadSubscription.this;
                synchronized (gridFSUploadSubscription) {
                    GridFSUploadSubscription.this.sourceSubscription = s;
                    GridFSUploadSubscription.this.currentAction = Action.WAITING;
                }
                GridFSUploadSubscription.this.tryProcess();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ByteBuffer byteBuffer) {
                GridFSUploadSubscription gridFSUploadSubscription = GridFSUploadSubscription.this;
                synchronized (gridFSUploadSubscription) {
                    GridFSUploadSubscription.this.currentAction = Action.IN_PROGRESS;
                }
                GridFSUploadPublisherImpl.this.gridFSUploadStream.write(byteBuffer).subscribe((Subscriber)new GridFSUploadStreamSubscriber(byteBuffer));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable t) {
                GridFSUploadSubscription gridFSUploadSubscription = GridFSUploadSubscription.this;
                synchronized (gridFSUploadSubscription) {
                    GridFSUploadSubscription.this.currentAction = Action.FINISHED;
                }
                GridFSUploadSubscription.this.outerSubscriber.onError(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete() {
                GridFSUploadSubscription gridFSUploadSubscription = GridFSUploadSubscription.this;
                synchronized (gridFSUploadSubscription) {
                    GridFSUploadSubscription.this.hasCompleted = true;
                    if (GridFSUploadSubscription.this.currentAction == Action.REQUESTING_MORE) {
                        GridFSUploadSubscription.this.currentAction = Action.COMPLETE;
                        GridFSUploadSubscription.this.tryProcess();
                    }
                }
            }

            class GridFSUploadStreamSubscriber
            implements Subscriber<Integer> {
                private final ByteBuffer byteBuffer;

                GridFSUploadStreamSubscriber(ByteBuffer byteBuffer) {
                    this.byteBuffer = byteBuffer;
                }

                public void onSubscribe(Subscription s) {
                    s.request(1L);
                }

                public void onNext(Integer integer) {
                }

                public void onError(Throwable t) {
                    GridFSUploadSubscription.this.terminate();
                    GridFSUploadSubscription.this.outerSubscriber.onError(t);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onComplete() {
                    if (this.byteBuffer.remaining() > 0) {
                        GridFSUploadSubscription.this.sourceSubscriber.onNext((Object)this.byteBuffer);
                    } else {
                        GridFSUploadSubscription gridFSUploadSubscription = GridFSUploadSubscription.this;
                        synchronized (gridFSUploadSubscription) {
                            if (GridFSUploadSubscription.this.hasCompleted) {
                                GridFSUploadSubscription.this.currentAction = Action.COMPLETE;
                            }
                            if (GridFSUploadSubscription.this.unsubscribed) {
                                GridFSUploadSubscription.this.currentAction = Action.TERMINATE;
                            }
                            if (GridFSUploadSubscription.this.currentAction != Action.COMPLETE && GridFSUploadSubscription.this.currentAction != Action.TERMINATE && GridFSUploadSubscription.this.currentAction != Action.FINISHED) {
                                GridFSUploadSubscription.this.currentAction = Action.WAITING;
                            }
                        }
                        GridFSUploadSubscription.this.tryProcess();
                    }
                }
            }
        };

        GridFSUploadSubscription(Subscriber<? super Success> outerSubscriber) {
            this.outerSubscriber = outerSubscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            boolean isUnsubscribed;
            GridFSUploadSubscription gridFSUploadSubscription = this;
            synchronized (gridFSUploadSubscription) {
                isUnsubscribed = this.unsubscribed;
                if (!isUnsubscribed && n < 1L) {
                    this.currentAction = Action.FINISHED;
                }
            }
            if (!isUnsubscribed && n < 1L) {
                this.outerSubscriber.onError((Throwable)new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                return;
            }
            this.tryProcess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            GridFSUploadSubscription gridFSUploadSubscription = this;
            synchronized (gridFSUploadSubscription) {
                this.unsubscribed = true;
            }
            this.terminate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryProcess() {
            NextStep nextStep;
            GridFSUploadSubscription gridFSUploadSubscription = this;
            synchronized (gridFSUploadSubscription) {
                switch (this.currentAction) {
                    case WAITING: {
                        nextStep = this.sourceSubscription == null ? NextStep.SUBSCRIBE : NextStep.REQUEST_MORE;
                        this.currentAction = Action.REQUESTING_MORE;
                        break;
                    }
                    case COMPLETE: {
                        nextStep = NextStep.COMPLETE;
                        this.currentAction = Action.FINISHED;
                        break;
                    }
                    case TERMINATE: {
                        nextStep = NextStep.TERMINATE;
                        this.currentAction = Action.FINISHED;
                        break;
                    }
                    default: {
                        nextStep = NextStep.DO_NOTHING;
                    }
                }
            }
            switch (nextStep) {
                case SUBSCRIBE: {
                    GridFSUploadPublisherImpl.this.source.subscribe(this.sourceSubscriber);
                    break;
                }
                case REQUEST_MORE: {
                    gridFSUploadSubscription = this;
                    synchronized (gridFSUploadSubscription) {
                        this.sourceSubscription.request(1L);
                        break;
                    }
                }
                case COMPLETE: {
                    GridFSUploadPublisherImpl.this.gridFSUploadStream.close().subscribe((Subscriber)new Subscriber<Success>(){

                        public void onSubscribe(Subscription s) {
                            s.request(1L);
                        }

                        public void onNext(Success success) {
                            GridFSUploadSubscription.this.outerSubscriber.onNext((Object)success);
                        }

                        public void onError(Throwable t) {
                            GridFSUploadSubscription.this.outerSubscriber.onError(t);
                        }

                        public void onComplete() {
                            GridFSUploadSubscription.this.outerSubscriber.onComplete();
                        }
                    });
                    break;
                }
                case TERMINATE: {
                    GridFSUploadPublisherImpl.this.gridFSUploadStream.abort().subscribe((Subscriber)new Subscriber<Success>(){

                        public void onSubscribe(Subscription s) {
                            s.request(1L);
                        }

                        public void onNext(Success success) {
                        }

                        public void onError(Throwable t) {
                        }

                        public void onComplete() {
                        }
                    });
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate() {
            GridFSUploadSubscription gridFSUploadSubscription = this;
            synchronized (gridFSUploadSubscription) {
                this.currentAction = Action.TERMINATE;
            }
            this.tryProcess();
        }
    }
}

