/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.ClientSessionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ClientSessionImpl;
import com.mongodb.reactivestreams.client.internal.ListDatabasesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoDatabaseImpl;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

public final class MongoClientImpl
implements MongoClient {
    private final com.mongodb.async.client.MongoClient wrapped;

    public MongoClientImpl(com.mongodb.async.client.MongoClient wrapped) {
        this.wrapped = (com.mongodb.async.client.MongoClient)Assertions.notNull((String)"wrapped", (Object)wrapped);
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(this.wrapped.getDatabase(name));
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @Override
    @Deprecated
    public MongoClientSettings getSettings() {
        return this.wrapped.getSettings();
    }

    @Override
    public Publisher<String> listDatabaseNames() {
        return new ObservableToPublisher<String>(Observables.observe((MongoIterable)this.wrapped.listDatabaseNames()));
    }

    @Override
    public Publisher<String> listDatabaseNames(ClientSession clientSession) {
        return new ObservableToPublisher<String>(Observables.observe((MongoIterable)this.wrapped.listDatabaseNames(clientSession.getWrapped())));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    @Override
    public <TResult> ListDatabasesPublisher<TResult> listDatabases(Class<TResult> clazz) {
        return new ListDatabasesPublisherImpl(this.wrapped.listDatabases(clazz));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    @Override
    public <TResult> ListDatabasesPublisher<TResult> listDatabases(ClientSession clientSession, Class<TResult> clazz) {
        return new ListDatabasesPublisherImpl(this.wrapped.listDatabases(clientSession.getWrapped(), clazz));
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl(this.wrapped.watch(pipeline, resultClass));
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return new ChangeStreamPublisherImpl(this.wrapped.watch(clientSession.getWrapped(), pipeline, resultClass));
    }

    @Override
    public Publisher<ClientSession> startSession() {
        return this.startSession(ClientSessionOptions.builder().build());
    }

    @Override
    public Publisher<ClientSession> startSession(final ClientSessionOptions options) {
        return new ObservableToPublisher<ClientSession>(Observables.observe((Block)new Block<SingleResultCallback<ClientSession>>(){

            public void apply(final SingleResultCallback<ClientSession> clientSessionSingleResultCallback) {
                MongoClientImpl.this.wrapped.startSession(options, (SingleResultCallback)new SingleResultCallback<com.mongodb.async.client.ClientSession>(){

                    public void onResult(com.mongodb.async.client.ClientSession result, Throwable t) {
                        if (t != null) {
                            clientSessionSingleResultCallback.onResult(null, t);
                        } else {
                            clientSessionSingleResultCallback.onResult((Object)new ClientSessionImpl(result, this), null);
                        }
                    }
                });
            }
        }));
    }
}

