/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.async.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.gridfs.AsyncInputStream;
import com.mongodb.reactivestreams.client.gridfs.AsyncOutputStream;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadStream;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadStream;
import com.mongodb.reactivestreams.client.internal.GridFSAsyncStreamHelper;
import com.mongodb.reactivestreams.client.internal.GridFSDownloadStreamImpl;
import com.mongodb.reactivestreams.client.internal.GridFSFindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.GridFSUploadStreamImpl;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.internal.PublisherHelper;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

public final class GridFSBucketImpl
implements com.mongodb.reactivestreams.client.gridfs.GridFSBucket {
    private final GridFSBucket wrapped;

    public GridFSBucketImpl(GridFSBucket wrapped) {
        this.wrapped = (GridFSBucket)Assertions.notNull((String)"GridFSBucket", (Object)wrapped);
    }

    @Override
    public String getBucketName() {
        return this.wrapped.getBucketName();
    }

    @Override
    public int getChunkSizeBytes() {
        return this.wrapped.getChunkSizeBytes();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.wrapped.withChunkSizeBytes(chunkSizeBytes));
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new GridFSBucketImpl(this.wrapped.withReadPreference(readPreference));
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new GridFSBucketImpl(this.wrapped.withWriteConcern(writeConcern));
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new GridFSBucketImpl(this.wrapped.withReadConcern(readConcern));
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename) {
        return new GridFSUploadStreamImpl(this.wrapped.openUploadStream(filename));
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename, GridFSUploadOptions options) {
        return new GridFSUploadStreamImpl(this.wrapped.openUploadStream(filename, options));
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id, String filename) {
        return new GridFSUploadStreamImpl(this.wrapped.openUploadStream(id, filename));
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id, String filename, GridFSUploadOptions options) {
        return new GridFSUploadStreamImpl(this.wrapped.openUploadStream(id, filename, options));
    }

    @Override
    public Publisher<ObjectId> uploadFromStream(final String filename, final AsyncInputStream source) {
        return new ObservableToPublisher<ObjectId>(Observables.observe((Block)new Block<SingleResultCallback<ObjectId>>(){

            public void apply(SingleResultCallback<ObjectId> callback) {
                GridFSBucketImpl.this.wrapped.uploadFromStream(filename, GridFSAsyncStreamHelper.toCallbackAsyncInputStream(source), callback);
            }
        }));
    }

    @Override
    public Publisher<ObjectId> uploadFromStream(final String filename, final AsyncInputStream source, final GridFSUploadOptions options) {
        return new ObservableToPublisher<ObjectId>(Observables.observe((Block)new Block<SingleResultCallback<ObjectId>>(){

            public void apply(SingleResultCallback<ObjectId> callback) {
                GridFSBucketImpl.this.wrapped.uploadFromStream(filename, GridFSAsyncStreamHelper.toCallbackAsyncInputStream(source), options, callback);
            }
        }));
    }

    @Override
    public Publisher<Success> uploadFromStream(final BsonValue id, final String filename, final AsyncInputStream source) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.uploadFromStream(id, filename, GridFSAsyncStreamHelper.toCallbackAsyncInputStream(source), PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> uploadFromStream(final BsonValue id, final String filename, final AsyncInputStream source, final GridFSUploadOptions options) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.uploadFromStream(id, filename, GridFSAsyncStreamHelper.toCallbackAsyncInputStream(source), options, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ObjectId id) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(id));
    }

    @Override
    public Publisher<Long> downloadToStream(final ObjectId id, final AsyncOutputStream destination) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(id, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), callback);
            }
        }));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(BsonValue id) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(id));
    }

    @Override
    public Publisher<Long> downloadToStream(final BsonValue id, final AsyncOutputStream destination) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(id, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), callback);
            }
        }));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(filename));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename, GridFSDownloadOptions options) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(filename, options));
    }

    @Override
    public Publisher<Long> downloadToStream(final String filename, final AsyncOutputStream destination) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(filename, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), callback);
            }
        }));
    }

    @Override
    public Publisher<Long> downloadToStream(final String filename, final AsyncOutputStream destination, final GridFSDownloadOptions options) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(filename, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), options, callback);
            }
        }));
    }

    @Override
    public GridFSFindPublisher find() {
        return new GridFSFindPublisherImpl(this.wrapped.find());
    }

    @Override
    public GridFSFindPublisher find(Bson filter) {
        return new GridFSFindPublisherImpl(this.wrapped.find(filter));
    }

    @Override
    public Publisher<Success> delete(final ObjectId id) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.delete(id, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> delete(final BsonValue id) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.delete(id, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> rename(final ObjectId id, final String newFilename) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.rename(id, newFilename, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> rename(final BsonValue id, final String newFilename) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.rename(id, newFilename, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> drop() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.drop(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }
}

