/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadStream;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.internal.PublisherHelper;
import java.nio.ByteBuffer;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

final class GridFSUploadStreamImpl
implements GridFSUploadStream {
    private final com.mongodb.async.client.gridfs.GridFSUploadStream wrapped;

    GridFSUploadStreamImpl(com.mongodb.async.client.gridfs.GridFSUploadStream wrapped) {
        this.wrapped = (com.mongodb.async.client.gridfs.GridFSUploadStream)Assertions.notNull((String)"GridFSUploadStream", (Object)wrapped);
    }

    @Override
    public ObjectId getObjectId() {
        return this.wrapped.getObjectId();
    }

    @Override
    public BsonValue getId() {
        return this.wrapped.getId();
    }

    @Override
    public Publisher<Integer> write(final ByteBuffer src) {
        return new ObservableToPublisher<Integer>(Observables.observe((Block)new Block<SingleResultCallback<Integer>>(){

            public void apply(SingleResultCallback<Integer> callback) {
                GridFSUploadStreamImpl.this.wrapped.write(src, callback);
            }
        }));
    }

    @Override
    public Publisher<Success> close() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSUploadStreamImpl.this.wrapped.close(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> abort() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSUploadStreamImpl.this.wrapped.abort(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }
}

