/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.async.client.AsyncMongoCollection;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.internal.AggregatePublisherImpl;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.DistinctPublisherImpl;
import com.mongodb.reactivestreams.client.internal.FindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ListIndexesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MapReducePublisherImpl;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

final class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final AsyncMongoCollection<TDocument> wrapped;

    MongoCollectionImpl(AsyncMongoCollection<TDocument> wrapped) {
        this.wrapped = (AsyncMongoCollection)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.wrapped.getDocumentClass();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withDocumentClass(clazz));
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withReadPreference(readPreference));
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withWriteConcern(writeConcern));
    }

    @Override
    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withReadConcern(readConcern));
    }

    @Override
    public Publisher<Long> estimatedDocumentCount() {
        return this.estimatedDocumentCount(new EstimatedDocumentCountOptions());
    }

    @Override
    public Publisher<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return Publishers.publish(callback -> this.wrapped.estimatedDocumentCount(options, callback));
    }

    @Override
    public Publisher<Long> countDocuments() {
        return this.countDocuments((Bson)new BsonDocument());
    }

    @Override
    public Publisher<Long> countDocuments(Bson filter) {
        return this.countDocuments(filter, new CountOptions());
    }

    @Override
    public Publisher<Long> countDocuments(Bson filter, CountOptions options) {
        return Publishers.publish(callback -> this.wrapped.countDocuments(filter, options, callback));
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession) {
        return this.countDocuments(clientSession, (Bson)new BsonDocument());
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession, Bson filter) {
        return this.countDocuments(clientSession, filter, new CountOptions());
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession, Bson filter, CountOptions options) {
        return Publishers.publish(callback -> this.wrapped.countDocuments(clientSession.getWrapped(), filter, options, callback));
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctPublisherImpl(this.wrapped.distinct(fieldName, resultClass)).filter(filter);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(ClientSession clientSession, String fieldName, Class<TResult> resultClass) {
        return this.distinct(clientSession, fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(ClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctPublisherImpl(this.wrapped.distinct(clientSession.getWrapped(), fieldName, resultClass)).filter(filter);
    }

    @Override
    public FindPublisher<TDocument> find() {
        return this.find((Bson)new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Class<TResult> clazz) {
        return this.find((Bson)new BsonDocument(), clazz);
    }

    @Override
    public FindPublisher<TDocument> find(Bson filter) {
        return this.find(filter, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Bson filter, Class<TResult> clazz) {
        return new FindPublisherImpl(this.wrapped.find(filter, clazz));
    }

    @Override
    public FindPublisher<TDocument> find(ClientSession clientSession) {
        return this.find(clientSession, (Bson)new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(ClientSession clientSession, Class<TResult> clazz) {
        return this.find(clientSession, (Bson)new BsonDocument(), clazz);
    }

    @Override
    public FindPublisher<TDocument> find(ClientSession clientSession, Bson filter) {
        return this.find(clientSession, filter, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(ClientSession clientSession, Bson filter, Class<TResult> clazz) {
        return new FindPublisherImpl(this.wrapped.find(clientSession.getWrapped(), filter, clazz));
    }

    @Override
    public AggregatePublisher<TDocument> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, this.getDocumentClass());
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> clazz) {
        return new AggregatePublisherImpl(this.wrapped.aggregate(pipeline, clazz));
    }

    @Override
    public AggregatePublisher<TDocument> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, this.getDocumentClass());
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> clazz) {
        return new AggregatePublisherImpl(this.wrapped.aggregate(clientSession.getWrapped(), pipeline, clazz));
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl(this.wrapped.watch(pipeline, resultClass));
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl(this.wrapped.watch(clientSession.getWrapped(), pipeline, resultClass));
    }

    @Override
    public MapReducePublisher<TDocument> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, this.getDocumentClass());
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> clazz) {
        return new MapReducePublisherImpl(this.wrapped.mapReduce(mapFunction, reduceFunction, clazz));
    }

    @Override
    public MapReducePublisher<TDocument> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.mapReduce(clientSession, mapFunction, reduceFunction, this.getDocumentClass());
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> clazz) {
        return new MapReducePublisherImpl(this.wrapped.mapReduce(clientSession.getWrapped(), mapFunction, reduceFunction, clazz));
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return Publishers.publish(callback -> this.wrapped.bulkWrite(requests, options, callback));
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(clientSession, requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return Publishers.publish(callback -> this.wrapped.bulkWrite(clientSession.getWrapped(), requests, options, callback));
    }

    @Override
    public Publisher<InsertOneResult> insertOne(TDocument document) {
        return this.insertOne(document, new InsertOneOptions());
    }

    @Override
    public Publisher<InsertOneResult> insertOne(TDocument document, InsertOneOptions options) {
        return Publishers.publish(callback -> this.wrapped.insertOne(document, options, callback));
    }

    @Override
    public Publisher<InsertOneResult> insertOne(ClientSession clientSession, TDocument document) {
        return this.insertOne(clientSession, document, new InsertOneOptions());
    }

    @Override
    public Publisher<InsertOneResult> insertOne(ClientSession clientSession, TDocument document, InsertOneOptions options) {
        return Publishers.publish(callback -> this.wrapped.insertOne(clientSession.getWrapped(), document, options, callback));
    }

    @Override
    public Publisher<InsertManyResult> insertMany(List<? extends TDocument> documents) {
        return this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public Publisher<InsertManyResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        return Publishers.publish(callback -> this.wrapped.insertMany(documents, options, callback));
    }

    @Override
    public Publisher<InsertManyResult> insertMany(ClientSession clientSession, List<? extends TDocument> documents) {
        return this.insertMany(clientSession, documents, new InsertManyOptions());
    }

    @Override
    public Publisher<InsertManyResult> insertMany(ClientSession clientSession, List<? extends TDocument> documents, InsertManyOptions options) {
        return Publishers.publish(callback -> this.wrapped.insertMany(clientSession.getWrapped(), documents, options, callback));
    }

    @Override
    public Publisher<DeleteResult> deleteOne(Bson filter) {
        return this.deleteOne(filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteOne(Bson filter, DeleteOptions options) {
        return Publishers.publish(callback -> this.wrapped.deleteOne(filter, options, callback));
    }

    @Override
    public Publisher<DeleteResult> deleteOne(ClientSession clientSession, Bson filter) {
        return this.deleteOne(clientSession, filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteOne(ClientSession clientSession, Bson filter, DeleteOptions options) {
        return Publishers.publish(callback -> this.wrapped.deleteOne(clientSession.getWrapped(), filter, options, callback));
    }

    @Override
    public Publisher<DeleteResult> deleteMany(Bson filter) {
        return this.deleteMany(filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteMany(Bson filter, DeleteOptions options) {
        return Publishers.publish(callback -> this.wrapped.deleteMany(filter, options, callback));
    }

    @Override
    public Publisher<DeleteResult> deleteMany(ClientSession clientSession, Bson filter) {
        return this.deleteMany(clientSession, filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteMany(ClientSession clientSession, Bson filter, DeleteOptions options) {
        return Publishers.publish(callback -> this.wrapped.deleteMany(clientSession.getWrapped(), filter, options, callback));
    }

    @Override
    public Publisher<UpdateResult> replaceOne(Bson filter, TDocument replacement) {
        return this.replaceOne(filter, replacement, new ReplaceOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(Bson filter, TDocument replacement, ReplaceOptions options) {
        return Publishers.publish(callback -> this.wrapped.replaceOne(filter, replacement, options, callback));
    }

    @Override
    public Publisher<UpdateResult> replaceOne(ClientSession clientSession, Bson filter, TDocument replacement) {
        return this.replaceOne(clientSession, filter, replacement, new ReplaceOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(ClientSession clientSession, Bson filter, TDocument replacement, ReplaceOptions options) {
        return Publishers.publish(callback -> this.wrapped.replaceOne(clientSession.getWrapped(), filter, replacement, options, callback));
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, Bson update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, Bson update, UpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.updateOne(filter, update, options, callback));
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, Bson update) {
        return this.updateOne(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, Bson update, UpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.updateOne(clientSession.getWrapped(), filter, update, options, callback));
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, List<? extends Bson> update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.updateOne(filter, update, options, callback));
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.updateOne(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.updateOne(clientSession.getWrapped(), filter, update, options, callback));
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, Bson update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, Bson update, UpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.updateMany(filter, update, options, callback));
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, Bson update) {
        return this.updateMany(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, Bson update, UpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.updateMany(clientSession.getWrapped(), filter, update, options, callback));
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, List<? extends Bson> update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.updateMany(filter, update, options, callback));
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.updateMany(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.updateMany(clientSession.getWrapped(), filter, update, options, callback));
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(Bson filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return Publishers.publish(callback -> this.wrapped.findOneAndDelete(filter, options, callback));
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(ClientSession clientSession, Bson filter) {
        return this.findOneAndDelete(clientSession, filter, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options) {
        return Publishers.publish(callback -> this.wrapped.findOneAndDelete(clientSession.getWrapped(), filter, options, callback));
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(Bson filter, TDocument replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return Publishers.publish(callback -> this.wrapped.findOneAndReplace(filter, replacement, options, callback));
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement) {
        return this.findOneAndReplace(clientSession, filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return Publishers.publish(callback -> this.wrapped.findOneAndReplace(clientSession.getWrapped(), filter, replacement, options, callback));
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(Bson filter, Bson update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.findOneAndUpdate(filter, update, options, callback));
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update) {
        return this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.findOneAndUpdate(clientSession.getWrapped(), filter, update, options, callback));
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(Bson filter, List<? extends Bson> update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.findOneAndUpdate(filter, update, options, callback));
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return Publishers.publish(callback -> this.wrapped.findOneAndUpdate(clientSession.getWrapped(), filter, update, options, callback));
    }

    @Override
    public Publisher<Void> drop() {
        return Publishers.publish(arg_0 -> this.wrapped.drop(arg_0));
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return Publishers.publish(callback -> this.wrapped.drop(clientSession.getWrapped(), callback));
    }

    @Override
    public Publisher<String> createIndex(Bson key) {
        return this.createIndex(key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(Bson key, IndexOptions options) {
        return Publishers.publish(callback -> this.wrapped.createIndex(key, options, callback));
    }

    @Override
    public Publisher<String> createIndex(ClientSession clientSession, Bson key) {
        return this.createIndex(clientSession, key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(ClientSession clientSession, Bson key, IndexOptions options) {
        return Publishers.publish(callback -> this.wrapped.createIndex(clientSession.getWrapped(), key, options, callback));
    }

    @Override
    public Publisher<String> createIndexes(List<IndexModel> indexes) {
        return this.createIndexes(indexes, new CreateIndexOptions());
    }

    @Override
    public Publisher<String> createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return Publishers.publishAndFlatten(callback -> this.wrapped.createIndexes(indexes, createIndexOptions, callback));
    }

    @Override
    public Publisher<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes) {
        return this.createIndexes(clientSession, indexes, new CreateIndexOptions());
    }

    @Override
    public Publisher<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return Publishers.publishAndFlatten(callback -> this.wrapped.createIndexes(clientSession.getWrapped(), indexes, createIndexOptions, callback));
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(Class<TResult> clazz) {
        return new ListIndexesPublisherImpl(this.wrapped.listIndexes(clazz));
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes(ClientSession clientSession) {
        return this.listIndexes(clientSession, Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(ClientSession clientSession, Class<TResult> clazz) {
        return new ListIndexesPublisherImpl(this.wrapped.listIndexes(clientSession.getWrapped(), clazz));
    }

    @Override
    public Publisher<Void> dropIndex(String indexName) {
        return this.dropIndex(indexName, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(Bson keys) {
        return this.dropIndex(keys, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(String indexName, DropIndexOptions dropIndexOptions) {
        return Publishers.publish(callback -> this.wrapped.dropIndex(indexName, dropIndexOptions, callback));
    }

    @Override
    public Publisher<Void> dropIndex(Bson keys, DropIndexOptions dropIndexOptions) {
        return Publishers.publish(callback -> this.wrapped.dropIndex(keys, dropIndexOptions, callback));
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, String indexName) {
        return this.dropIndex(clientSession, indexName, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, Bson keys) {
        return this.dropIndex(clientSession, keys, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions) {
        return Publishers.publish(callback -> this.wrapped.dropIndex(clientSession.getWrapped(), indexName, dropIndexOptions, callback));
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions) {
        return Publishers.publish(callback -> this.wrapped.dropIndex(clientSession.getWrapped(), keys, dropIndexOptions, callback));
    }

    @Override
    public Publisher<Void> dropIndexes() {
        return this.dropIndexes(new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndexes(DropIndexOptions dropIndexOptions) {
        return this.dropIndex("*", dropIndexOptions);
    }

    @Override
    public Publisher<Void> dropIndexes(ClientSession clientSession) {
        return this.dropIndexes(clientSession, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndexes(ClientSession clientSession, DropIndexOptions dropIndexOptions) {
        return this.dropIndex(clientSession, "*", dropIndexOptions);
    }

    @Override
    public Publisher<Void> renameCollection(MongoNamespace newCollectionNamespace) {
        return this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return Publishers.publish(callback -> this.wrapped.renameCollection(newCollectionNamespace, options, callback));
    }

    @Override
    public Publisher<Void> renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace) {
        return this.renameCollection(clientSession, newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Void> renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return Publishers.publish(callback -> this.wrapped.renameCollection(clientSession.getWrapped(), newCollectionNamespace, options, callback));
    }
}

