/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.reactivestreams.client.internal.AbstractSubscription;
import java.util.List;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class FlatteningSingleResultCallbackSubscription<TResult>
extends AbstractSubscription<TResult> {
    private final Block<SingleResultCallback<List<TResult>>> block;
    private boolean completed;

    FlatteningSingleResultCallbackSubscription(Block<SingleResultCallback<List<TResult>>> block, Subscriber<? super TResult> subscriber) {
        super(subscriber);
        this.block = block;
        subscriber.onSubscribe((Subscription)this);
    }

    @Override
    void requestInitialData() {
        this.block.apply((result, t) -> {
            if (t != null) {
                this.onError(t);
            } else {
                this.addToQueue(result);
                FlatteningSingleResultCallbackSubscription flatteningSingleResultCallbackSubscription = this;
                synchronized (flatteningSingleResultCallbackSubscription) {
                    this.completed = true;
                }
                this.tryProcessResultsQueue();
            }
        });
    }

    @Override
    boolean checkCompleted() {
        return this.completed;
    }
}

