/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSDownloadStream;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class GridFSDownloadPublisherImpl
implements GridFSDownloadPublisher {
    private final AsyncGridFSDownloadStream gridFSDownloadStream;
    private int bufferSizeBytes;

    GridFSDownloadPublisherImpl(AsyncGridFSDownloadStream gridFSDownloadStream) {
        this.gridFSDownloadStream = gridFSDownloadStream;
    }

    @Override
    public Publisher<GridFSFile> getGridFSFile() {
        return Publishers.publish(arg_0 -> ((AsyncGridFSDownloadStream)this.gridFSDownloadStream).getGridFSFile(arg_0));
    }

    @Override
    public GridFSDownloadPublisher bufferSizeBytes(int bufferSizeBytes) {
        this.bufferSizeBytes = bufferSizeBytes;
        return this;
    }

    public void subscribe(Subscriber<? super ByteBuffer> s) {
        s.onSubscribe((Subscription)new GridFSDownloadSubscription(s));
    }

    static enum NextStep {
        GET_FILE,
        READ,
        COMPLETE,
        TERMINATE,
        DO_NOTHING;

    }

    static enum Action {
        WAITING,
        IN_PROGRESS,
        TERMINATE,
        COMPLETE,
        FINISHED;

    }

    class GridFSDownloadSubscription
    implements Subscription {
        private final Subscriber<? super ByteBuffer> outerSubscriber;
        private GridFSFile gridFSFile;
        private long sizeRead = 0L;
        private long requested = 0L;
        private boolean unsubscribed;
        private int currentBatchSize = 0;
        private Action currentAction = Action.WAITING;
        private final Subscriber<GridFSFile> gridFSFileSubscriber = new Subscriber<GridFSFile>(){

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(GridFSFile result) {
                GridFSDownloadSubscription gridFSDownloadSubscription = GridFSDownloadSubscription.this;
                synchronized (gridFSDownloadSubscription) {
                    GridFSDownloadSubscription.this.gridFSFile = result;
                }
            }

            public void onError(Throwable t) {
                GridFSDownloadSubscription.this.outerSubscriber.onError(t);
                GridFSDownloadSubscription.this.terminate();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete() {
                GridFSDownloadSubscription gridFSDownloadSubscription = GridFSDownloadSubscription.this;
                synchronized (gridFSDownloadSubscription) {
                    GridFSDownloadSubscription.this.currentAction = Action.WAITING;
                }
                GridFSDownloadSubscription.this.tryProcess();
            }
        };

        GridFSDownloadSubscription(Subscriber<? super ByteBuffer> outerSubscriber) {
            this.outerSubscriber = outerSubscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            boolean isUnsubscribed;
            GridFSDownloadSubscription gridFSDownloadSubscription = this;
            synchronized (gridFSDownloadSubscription) {
                isUnsubscribed = this.unsubscribed;
                if (!isUnsubscribed && n < 1L) {
                    this.currentAction = Action.FINISHED;
                } else {
                    this.requested += n;
                }
            }
            if (!isUnsubscribed && n < 1L) {
                this.outerSubscriber.onError((Throwable)new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                return;
            }
            this.tryProcess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            GridFSDownloadSubscription gridFSDownloadSubscription = this;
            synchronized (gridFSDownloadSubscription) {
                this.unsubscribed = true;
            }
            this.terminate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryProcess() {
            NextStep nextStep;
            GridFSDownloadSubscription gridFSDownloadSubscription = this;
            synchronized (gridFSDownloadSubscription) {
                switch (this.currentAction) {
                    case WAITING: {
                        if (this.requested == 0L) {
                            nextStep = NextStep.DO_NOTHING;
                            break;
                        }
                        if (this.gridFSFile == null) {
                            nextStep = NextStep.GET_FILE;
                            this.currentAction = Action.IN_PROGRESS;
                            break;
                        }
                        if (this.sizeRead == this.gridFSFile.getLength()) {
                            nextStep = NextStep.COMPLETE;
                            this.currentAction = Action.FINISHED;
                            break;
                        }
                        --this.requested;
                        nextStep = NextStep.READ;
                        this.currentAction = Action.IN_PROGRESS;
                        break;
                    }
                    case COMPLETE: {
                        nextStep = NextStep.COMPLETE;
                        this.currentAction = Action.FINISHED;
                        break;
                    }
                    case TERMINATE: {
                        nextStep = NextStep.TERMINATE;
                        this.currentAction = Action.FINISHED;
                        break;
                    }
                    default: {
                        nextStep = NextStep.DO_NOTHING;
                    }
                }
            }
            switch (nextStep) {
                case GET_FILE: {
                    GridFSDownloadPublisherImpl.this.getGridFSFile().subscribe(this.gridFSFileSubscriber);
                    break;
                }
                case READ: {
                    long remaining;
                    int chunkSize;
                    GridFSDownloadSubscription gridFSDownloadSubscription2 = this;
                    synchronized (gridFSDownloadSubscription2) {
                        chunkSize = this.gridFSFile.getChunkSize();
                        remaining = this.gridFSFile.getLength() - this.sizeRead;
                    }
                    int byteBufferSize = Math.max(chunkSize, GridFSDownloadPublisherImpl.this.bufferSizeBytes);
                    if (remaining < Integer.MAX_VALUE) {
                        byteBufferSize = Math.min(Long.valueOf(remaining).intValue(), byteBufferSize);
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocate(byteBufferSize);
                    if (this.currentBatchSize == 0) {
                        this.currentBatchSize = Math.max(byteBufferSize / chunkSize, 1);
                        GridFSDownloadPublisherImpl.this.gridFSDownloadStream.batchSize(this.currentBatchSize);
                    }
                    Publishers.publish(callback -> GridFSDownloadPublisherImpl.this.gridFSDownloadStream.read(byteBuffer, callback)).subscribe((Subscriber)new GridFSDownloadStreamSubscriber(byteBuffer));
                    break;
                }
                case COMPLETE: 
                case TERMINATE: {
                    final boolean propagateToOuter = nextStep == NextStep.COMPLETE;
                    Publishers.publish(arg_0 -> ((AsyncGridFSDownloadStream)GridFSDownloadPublisherImpl.this.gridFSDownloadStream).close(arg_0)).subscribe((Subscriber)new Subscriber<Void>(){

                        public void onSubscribe(Subscription s) {
                            s.request(1L);
                        }

                        public void onNext(Void result) {
                        }

                        public void onError(Throwable t) {
                            if (propagateToOuter) {
                                GridFSDownloadSubscription.this.outerSubscriber.onError(t);
                            }
                        }

                        public void onComplete() {
                            if (propagateToOuter) {
                                GridFSDownloadSubscription.this.outerSubscriber.onComplete();
                            }
                        }
                    });
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate() {
            GridFSDownloadSubscription gridFSDownloadSubscription = this;
            synchronized (gridFSDownloadSubscription) {
                this.currentAction = Action.TERMINATE;
            }
            this.tryProcess();
        }

        class GridFSDownloadStreamSubscriber
        implements Subscriber<Integer> {
            private final ByteBuffer byteBuffer;

            GridFSDownloadStreamSubscriber(ByteBuffer byteBuffer) {
                this.byteBuffer = byteBuffer;
            }

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(Integer integer) {
                GridFSDownloadSubscription gridFSDownloadSubscription = GridFSDownloadSubscription.this;
                synchronized (gridFSDownloadSubscription) {
                    GridFSDownloadSubscription.this.sizeRead += integer.intValue();
                }
            }

            public void onError(Throwable t) {
                GridFSDownloadSubscription.this.terminate();
                GridFSDownloadSubscription.this.outerSubscriber.onError(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete() {
                if (this.byteBuffer.remaining() > 0) {
                    Publishers.publish(callback -> GridFSDownloadPublisherImpl.this.gridFSDownloadStream.read(this.byteBuffer, callback)).subscribe((Subscriber)new GridFSDownloadStreamSubscriber(this.byteBuffer));
                } else {
                    boolean hasTerminated;
                    GridFSDownloadSubscription gridFSDownloadSubscription = GridFSDownloadSubscription.this;
                    synchronized (gridFSDownloadSubscription) {
                        boolean bl = hasTerminated = GridFSDownloadSubscription.this.currentAction == Action.TERMINATE || GridFSDownloadSubscription.this.currentAction == Action.FINISHED;
                        if (!hasTerminated) {
                            GridFSDownloadSubscription.this.currentAction = Action.WAITING;
                            if (GridFSDownloadSubscription.this.sizeRead == GridFSDownloadSubscription.this.gridFSFile.getLength()) {
                                GridFSDownloadSubscription.this.currentAction = Action.COMPLETE;
                            }
                        }
                    }
                    if (!hasTerminated) {
                        ((Buffer)this.byteBuffer).flip();
                        GridFSDownloadSubscription.this.outerSubscriber.onNext((Object)this.byteBuffer);
                        GridFSDownloadSubscription.this.tryProcess();
                    }
                }
            }
        }
    }
}

