/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

final class FindPublisherImpl<T>
extends BatchCursorPublisher<T>
implements FindPublisher<T> {
    private final FindOptions findOptions;
    private Bson filter;

    FindPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, Bson filter) {
        super(clientSession, mongoOperationPublisher);
        this.filter = (Bson)Assertions.notNull((String)"filter", (Object)filter);
        this.findOptions = new FindOptions();
    }

    @Override
    public FindPublisher<T> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public FindPublisher<T> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public FindPublisher<T> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public FindPublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindPublisher<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public FindPublisher<T> collation(@Nullable Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    @Override
    public FindPublisher<T> projection(@Nullable Bson projection) {
        this.findOptions.projection(projection);
        return this;
    }

    @Override
    public FindPublisher<T> sort(@Nullable Bson sort) {
        this.findOptions.sort(sort);
        return this;
    }

    @Override
    public FindPublisher<T> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    @Deprecated
    public FindPublisher<T> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindPublisher<T> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public FindPublisher<T> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public FindPublisher<T> comment(@Nullable String comment) {
        this.findOptions.comment(comment);
        return this;
    }

    @Override
    public FindPublisher<T> hint(@Nullable Bson hint) {
        this.findOptions.hint(hint);
        return this;
    }

    @Override
    public FindPublisher<T> hintString(@Nullable String hint) {
        this.findOptions.hintString(hint);
        return this;
    }

    @Override
    public FindPublisher<T> max(@Nullable Bson max) {
        this.findOptions.max(max);
        return this;
    }

    @Override
    public FindPublisher<T> min(@Nullable Bson min) {
        this.findOptions.min(min);
        return this;
    }

    @Override
    public FindPublisher<T> returnKey(boolean returnKey) {
        this.findOptions.returnKey(returnKey);
        return this;
    }

    @Override
    public FindPublisher<T> showRecordId(boolean showRecordId) {
        this.findOptions.showRecordId(showRecordId);
        return this;
    }

    @Override
    public FindPublisher<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.findOptions.allowDiskUse(allowDiskUse);
        return this;
    }

    @Override
    public Publisher<Document> explain() {
        return this.publishExplain(Document.class, null);
    }

    @Override
    public Publisher<Document> explain(ExplainVerbosity verbosity) {
        return this.publishExplain(Document.class, (ExplainVerbosity)Assertions.notNull((String)"verbosity", (Object)verbosity));
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass) {
        return this.publishExplain(explainResultClass, null);
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        return this.publishExplain(explainResultClass, (ExplainVerbosity)Assertions.notNull((String)"verbosity", (Object)verbosity));
    }

    private <E> Publisher<E> publishExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        Assertions.notNull((String)"explainDocumentClass", explainResultClass);
        return this.getMongoOperationPublisher().createReadOperationMono(() -> this.asAsyncReadOperation().asAsyncExplainableOperation(verbosity, (Decoder)this.getCodecRegistry().get(explainResultClass)), this.getClientSession());
    }

    @Override
    AsyncExplainableReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation() {
        return this.getOperations().find(this.filter, this.getDocumentClass(), this.findOptions);
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncFirstReadOperation() {
        return this.getOperations().findFirst(this.filter, this.getDocumentClass(), this.findOptions);
    }
}

