/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.mongodb.reactivestreams.client.internal.VoidWriteOperationThenCursorReadOperation;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

final class MapReducePublisherImpl<T>
extends BatchCursorPublisher<T>
implements MapReducePublisher<T> {
    private final String mapFunction;
    private final String reduceFunction;
    private boolean inline = true;
    private String collectionName;
    private String finalizeFunction;
    private Bson scope;
    private Bson filter;
    private Bson sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private MapReduceAction action = MapReduceAction.REPLACE;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    MapReducePublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, String mapFunction, String reduceFunction) {
        super(clientSession, mongoOperationPublisher);
        this.mapFunction = (String)Assertions.notNull((String)"mapFunction", (Object)mapFunction);
        this.reduceFunction = (String)Assertions.notNull((String)"reduceFunction", (Object)reduceFunction);
    }

    @Override
    public MapReducePublisher<T> collectionName(String collectionName) {
        this.collectionName = (String)Assertions.notNull((String)"collectionName", (Object)collectionName);
        this.inline = false;
        return this;
    }

    @Override
    public MapReducePublisher<T> finalizeFunction(@Nullable String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    @Override
    public MapReducePublisher<T> scope(@Nullable Bson scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public MapReducePublisher<T> sort(@Nullable Bson sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public MapReducePublisher<T> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public MapReducePublisher<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public MapReducePublisher<T> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    @Override
    public MapReducePublisher<T> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public MapReducePublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReducePublisher<T> action(MapReduceAction action) {
        this.action = action;
        return this;
    }

    @Override
    public MapReducePublisher<T> databaseName(@Nullable String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Override
    @Deprecated
    public MapReducePublisher<T> sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    @Override
    @Deprecated
    public MapReducePublisher<T> nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    @Override
    public MapReducePublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public MapReducePublisher<T> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public Publisher<Void> toCollection() {
        if (this.inline) {
            throw new IllegalStateException("The options must specify a non-inline result");
        }
        return this.getMongoOperationPublisher().createWriteOperationMono(this::createMapReduceToCollectionOperation, this.getClientSession());
    }

    @Override
    public MapReducePublisher<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    ReadPreference getReadPreference() {
        if (this.inline) {
            return super.getReadPreference();
        }
        return ReadPreference.primary();
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        if (this.inline) {
            return this.createMapReduceInlineOperation();
        }
        return new VoidWriteOperationThenCursorReadOperation<T>(this.createMapReduceToCollectionOperation(), this.createFindOperation(initialBatchSize));
    }

    private WrappedMapReduceReadOperation<T> createMapReduceInlineOperation() {
        return new WrappedMapReduceReadOperation(this.getOperations().mapReduce(this.mapFunction, this.reduceFunction, this.finalizeFunction, this.getDocumentClass(), this.filter, this.limit, this.maxTimeMS, this.jsMode, this.scope, this.sort, this.verbose, this.collation));
    }

    private WrappedMapReduceWriteOperation createMapReduceToCollectionOperation() {
        return new WrappedMapReduceWriteOperation((AsyncWriteOperation<MapReduceStatistics>)this.getOperations().mapReduceToCollection(this.databaseName, this.collectionName, this.mapFunction, this.reduceFunction, this.finalizeFunction, this.filter, this.limit, this.maxTimeMS, this.jsMode, this.scope, this.sort, this.verbose, this.action, this.nonAtomic, this.sharded, this.bypassDocumentValidation, this.collation));
    }

    private AsyncReadOperation<AsyncBatchCursor<T>> createFindOperation(int initialBatchSize) {
        String dbName = this.databaseName != null ? this.databaseName : this.getNamespace().getDatabaseName();
        FindOptions findOptions = new FindOptions().collation(this.collation).batchSize(initialBatchSize);
        return this.getOperations().find(new MongoNamespace(dbName, this.collectionName), (Bson)new BsonDocument(), this.getDocumentClass(), findOptions);
    }

    static class WrappedMapReduceWriteOperation
    implements AsyncWriteOperation<Void> {
        private final AsyncWriteOperation<MapReduceStatistics> operation;

        WrappedMapReduceWriteOperation(AsyncWriteOperation<MapReduceStatistics> operation) {
            this.operation = operation;
        }

        AsyncWriteOperation<MapReduceStatistics> getOperation() {
            return this.operation;
        }

        public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
            this.operation.executeAsync(binding, (result, t) -> callback.onResult(null, t));
        }
    }

    static class WrappedMapReduceReadOperation<T>
    implements AsyncReadOperation<AsyncBatchCursor<T>> {
        private final AsyncReadOperation<MapReduceAsyncBatchCursor<T>> operation;

        WrappedMapReduceReadOperation(AsyncReadOperation<MapReduceAsyncBatchCursor<T>> operation) {
            this.operation = operation;
        }

        AsyncReadOperation<MapReduceAsyncBatchCursor<T>> getOperation() {
            return this.operation;
        }

        public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
            this.operation.executeAsync(binding, (arg_0, arg_1) -> callback.onResult(arg_0, arg_1));
        }
    }
}

