/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoSocketException;
import com.mongodb.ServerAddress;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.connection.AsynchronousChannelStream;
import java.io.Closeable;
import java.nio.channels.CompletionHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class KeyManagementService
implements Closeable {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final Map<String, SSLContext> kmsProviderSslContextMap;
    private final int timeoutMillis;
    private final TlsChannelStreamFactoryFactory tlsChannelStreamFactoryFactory;

    KeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap, int timeoutMillis) {
        this.kmsProviderSslContextMap = kmsProviderSslContextMap;
        this.tlsChannelStreamFactoryFactory = new TlsChannelStreamFactoryFactory();
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public void close() {
        this.tlsChannelStreamFactoryFactory.close();
    }

    Mono<Void> decryptKey(final MongoKeyDecryptor keyDecryptor) {
        SocketSettings socketSettings = SocketSettings.builder().connectTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).build();
        StreamFactory streamFactory = this.tlsChannelStreamFactoryFactory.create(socketSettings, SslSettings.builder().enabled(true).context(this.kmsProviderSslContextMap.get(keyDecryptor.getKmsProvider())).build());
        ServerAddress serverAddress = new ServerAddress(keyDecryptor.getHostName());
        LOGGER.info("Connecting to KMS server at " + serverAddress);
        return Mono.create(sink -> {
            final Stream stream = streamFactory.create(serverAddress);
            stream.openAsync((AsyncCompletionHandler)new AsyncCompletionHandler<Void>(){

                public void completed(Void ignored) {
                    KeyManagementService.this.streamWrite(stream, keyDecryptor, (MonoSink<Void>)sink);
                }

                public void failed(Throwable t) {
                    stream.close();
                    sink.error(t);
                }
            });
        }).onErrorMap(this::unWrapException);
    }

    private void streamWrite(final Stream stream, final MongoKeyDecryptor keyDecryptor, final MonoSink<Void> sink) {
        List<ByteBufNIO> byteBufs = Collections.singletonList(new ByteBufNIO(keyDecryptor.getMessage()));
        stream.writeAsync(byteBufs, (AsyncCompletionHandler)new AsyncCompletionHandler<Void>(){

            public void completed(Void aVoid) {
                KeyManagementService.this.streamRead(stream, keyDecryptor, (MonoSink<Void>)sink);
            }

            public void failed(Throwable t) {
                stream.close();
                sink.error(t);
            }
        });
    }

    private void streamRead(final Stream stream, final MongoKeyDecryptor keyDecryptor, final MonoSink<Void> sink) {
        int bytesNeeded = keyDecryptor.bytesNeeded();
        if (bytesNeeded > 0) {
            AsynchronousChannelStream asyncStream = (AsynchronousChannelStream)stream;
            final ByteBuf buffer = asyncStream.getBuffer(bytesNeeded);
            asyncStream.getChannel().read(buffer.asNIO(), (long)asyncStream.getSettings().getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, (CompletionHandler)new CompletionHandler<Integer, Void>(){

                @Override
                public void completed(Integer integer, Void aVoid) {
                    buffer.flip();
                    try {
                        keyDecryptor.feed(buffer.asNIO());
                        buffer.release();
                        KeyManagementService.this.streamRead(stream, keyDecryptor, (MonoSink<Void>)sink);
                    }
                    catch (Throwable t) {
                        sink.error(t);
                    }
                }

                @Override
                public void failed(Throwable t, Void aVoid) {
                    buffer.release();
                    stream.close();
                    sink.error(t);
                }
            });
        } else {
            stream.close();
            sink.success();
        }
    }

    private Throwable unWrapException(Throwable t) {
        return t instanceof MongoSocketException ? t.getCause() : t;
    }
}

