/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.TransportSettings;
import com.mongodb.internal.connection.AsynchronousSocketChannelStreamFactoryFactory;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.DefaultClusterFactory;
import com.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.internal.connection.StreamFactoryHelper;
import com.mongodb.internal.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.MongoClientImpl;
import com.mongodb.spi.dns.InetAddressResolver;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation);
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        if (settings.getSocketSettings().getProxySettings().isProxyEnabled()) {
            throw new MongoClientException("Proxy is not supported for reactive clients");
        }
        InetAddressResolver inetAddressResolver = ServerAddressHelper.getInetAddressResolver((MongoClientSettings)settings);
        TransportSettings transportSettings = settings.getTransportSettings();
        Object streamFactoryFactory = transportSettings != null ? StreamFactoryHelper.getStreamFactoryFactoryFromSettings((TransportSettings)transportSettings, (InetAddressResolver)inetAddressResolver) : (settings.getSslSettings().isEnabled() ? new TlsChannelStreamFactoryFactory(inetAddressResolver) : new AsynchronousSocketChannelStreamFactoryFactory(inetAddressResolver));
        StreamFactory streamFactory = MongoClients.getStreamFactory(streamFactoryFactory, settings, false);
        StreamFactory heartbeatStreamFactory = MongoClients.getStreamFactory(streamFactoryFactory, settings, true);
        MongoDriverInformation wrappedMongoDriverInformation = MongoClients.wrapMongoDriverInformation(mongoDriverInformation);
        Cluster cluster = MongoClients.createCluster(settings, wrappedMongoDriverInformation, streamFactory, heartbeatStreamFactory);
        return new MongoClientImpl(settings, wrappedMongoDriverInformation, cluster, (AutoCloseable)streamFactoryFactory);
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return MongoClientSettings.getDefaultCodecRegistry();
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory) {
        Assertions.notNull((String)"settings", (Object)settings);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), InternalConnectionPoolSettings.builder().prestartAsyncWorkManager(true).build(), streamFactory, heartbeatStreamFactory, settings.getCredential(), settings.getLoggerSettings(), EventListenerHelper.getCommandListener((List)settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList(), settings.getServerApi(), settings.getDnsClient());
    }

    private static MongoDriverInformation wrapMongoDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation) {
        return (mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation)).driverName("reactive-streams").build();
    }

    private static StreamFactory getStreamFactory(StreamFactoryFactory streamFactoryFactory, MongoClientSettings settings, boolean isHeartbeat) {
        return streamFactoryFactory.create(isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings(), settings.getSslSettings());
    }

    private MongoClients() {
    }
}

