/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.TransactionContext;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import org.bson.BsonTimestamp;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements AsyncReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final OperationContext operationContext;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, AsyncClusterAwareReadWriteBinding wrapped) {
        this.wrapped = ((AsyncClusterAwareReadWriteBinding)Assertions.notNull((String)"wrapped", (Object)wrapped)).retain();
        this.ownsSession = ownsSession;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.operationContext = wrapped.getOperationContext().withSessionContext((SessionContext)new AsyncClientSessionContext(session));
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.getConnectionSource((AsyncCallbackSupplier<AsyncConnectionSource>)((AsyncCallbackSupplier)arg_0 -> ((AsyncClusterAwareReadWriteBinding)this.wrapped).getReadConnectionSource(arg_0)), callback);
    }

    public void getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, SingleResultCallback<AsyncConnectionSource> callback) {
        this.getConnectionSource((AsyncCallbackSupplier<AsyncConnectionSource>)((AsyncCallbackSupplier)wrappedConnectionSourceCallback -> this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference, wrappedConnectionSourceCallback)), callback);
    }

    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.getConnectionSource((AsyncCallbackSupplier<AsyncConnectionSource>)((AsyncCallbackSupplier)arg_0 -> ((AsyncClusterAwareReadWriteBinding)this.wrapped).getWriteConnectionSource(arg_0)), callback);
    }

    private void getConnectionSource(AsyncCallbackSupplier<AsyncConnectionSource> connectionSourceSupplier, SingleResultCallback<AsyncConnectionSource> callback) {
        WrappingCallback wrappingCallback = new WrappingCallback(callback);
        if (!this.session.hasActiveTransaction()) {
            connectionSourceSupplier.get((SingleResultCallback)wrappingCallback);
            return;
        }
        if (TransactionContext.get((com.mongodb.session.ClientSession)this.session) == null) {
            connectionSourceSupplier.get((source, t) -> {
                if (t != null) {
                    wrappingCallback.onResult(null, t);
                } else {
                    ClusterType clusterType = ((AsyncConnectionSource)Assertions.assertNotNull((Object)source)).getServerDescription().getClusterType();
                    if (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED) {
                        TransactionContext transactionContext = new TransactionContext(clusterType);
                        this.session.setTransactionContext(source.getServerDescription().getAddress(), transactionContext);
                        transactionContext.release();
                    }
                    wrappingCallback.onResult((AsyncConnectionSource)source, (Throwable)null);
                }
            });
        } else {
            this.wrapped.getConnectionSource((ServerAddress)Assertions.assertNotNull((Object)this.session.getPinnedServerAddress()), (SingleResultCallback)wrappingCallback);
        }
    }

    public AsyncReadWriteBinding retain() {
        super.retain();
        return this;
    }

    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count;
    }

    private final class AsyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;

        AsyncClientSessionContext(ClientSession clientSession) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
        }

        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean isSnapshot() {
            Boolean snapshot = this.clientSession.getOptions().isSnapshot();
            return snapshot != null && snapshot != false;
        }

        public void setSnapshotTimestamp(@Nullable BsonTimestamp snapshotTimestamp) {
            this.clientSession.setSnapshotTimestamp(snapshotTimestamp);
        }

        @Nullable
        public BsonTimestamp getSnapshotTimestamp() {
            return this.clientSession.getSnapshotTimestamp();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return (ReadConcern)Assertions.assertNotNull((Object)this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return ClientSessionBinding.this.wrapped.getOperationContext().getSessionContext().getReadConcern();
        }
    }

    private class WrappingCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final SingleResultCallback<AsyncConnectionSource> callback;

        WrappingCallback(SingleResultCallback<AsyncConnectionSource> callback) {
            this.callback = callback;
        }

        public void onResult(@Nullable AsyncConnectionSource result, @Nullable Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                this.callback.onResult((Object)new SessionBindingAsyncConnectionSource((AsyncConnectionSource)Assertions.assertNotNull((Object)result)), null);
            }
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public OperationContext getOperationContext() {
            return ClientSessionBinding.this.operationContext;
        }

        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)ClientSessionBinding.this.session);
            if (transactionContext != null && transactionContext.isConnectionPinningRequired()) {
                AsyncConnection pinnedConnection = (AsyncConnection)transactionContext.getPinnedConnection();
                if (pinnedConnection == null) {
                    this.wrapped.getConnection((connection, t) -> {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            transactionContext.pinConnection((ReferenceCounted)((AsyncConnection)Assertions.assertNotNull((Object)connection)), AsyncConnection::markAsPinned);
                            callback.onResult(connection, null);
                        }
                    });
                } else {
                    callback.onResult((Object)pinnedConnection.retain(), null);
                }
            } else {
                this.wrapped.getConnection(callback);
            }
        }

        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                ClientSessionBinding.this.release();
            }
            return count;
        }
    }
}

