/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperationCursor;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bson.BsonString;
import org.bson.BsonValue;

final class ListIndexesPublisherImpl<T>
extends BatchCursorPublisher<T>
implements ListIndexesPublisher<T> {
    private long maxTimeMS;
    private BsonValue comment;

    ListIndexesPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher) {
        super(clientSession, mongoOperationPublisher);
    }

    @Override
    public ListIndexesPublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListIndexesPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListIndexesPublisher<T> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public ListIndexesPublisher<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public ListIndexesPublisher<T> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    ReadOperationCursor<T> asReadOperation(int initialBatchSize) {
        return this.getOperations().listIndexes(this.getDocumentClass(), Integer.valueOf(initialBatchSize), this.comment, this.getTimeoutMode());
    }

    @Override
    Function<Operations<?>, TimeoutSettings> getTimeoutSettings() {
        return operations -> operations.createTimeoutSettings(this.maxTimeMS);
    }
}

