/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.mongodb.reactivestreams.client.internal.TimeoutHelper;
import com.mongodb.reactivestreams.client.internal.gridfs.GridFSDownloadPublisherImpl;
import com.mongodb.reactivestreams.client.internal.gridfs.GridFSFindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.gridfs.GridFSUploadPublisherImpl;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class GridFSPublisherCreator {
    private GridFSPublisherCreator() {
    }

    public static GridFSUploadPublisherImpl createGridFSUploadPublisher(int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options, Publisher<ByteBuffer> source) {
        Assertions.notNull((String)"filesCollection", filesCollection);
        Assertions.notNull((String)"chunksCollection", chunksCollection);
        Assertions.notNull((String)"id", (Object)id);
        Assertions.notNull((String)"filename", (Object)filename);
        Assertions.notNull((String)"options", (Object)options);
        Integer chunkSize = options.getChunkSizeBytes();
        if (chunkSize == null) {
            chunkSize = chunkSizeBytes;
        }
        return new GridFSUploadPublisherImpl(clientSession, filesCollection, chunksCollection, id, filename, chunkSize, options.getMetadata(), source);
    }

    public static GridFSDownloadPublisherImpl createGridFSDownloadPublisher(MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, Function<Timeout, GridFSFindPublisher> publisher) {
        Assertions.notNull((String)"chunksCollection", chunksCollection);
        Assertions.notNull((String)"gridFSFileMono", publisher);
        return new GridFSDownloadPublisherImpl(clientSession, publisher, chunksCollection);
    }

    public static GridFSFindPublisher createGridFSFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, @Nullable Bson filter) {
        Assertions.notNull((String)"filesCollection", filesCollection);
        return new GridFSFindPublisherImpl(GridFSPublisherCreator.createFindPublisher(filesCollection, clientSession, filter));
    }

    public static GridFSFindPublisher createGridFSFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, @Nullable Bson filter, @Nullable Timeout timeout) {
        Assertions.notNull((String)"filesCollection", filesCollection);
        return new GridFSFindPublisherImpl(GridFSPublisherCreator.createFindPublisher(filesCollection, clientSession, filter, timeout));
    }

    public static GridFSFindPublisher createGridFSFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, String filename, GridFSDownloadOptions options, @Nullable Timeout timeout) {
        int sort;
        int skip;
        Assertions.notNull((String)"filesCollection", filesCollection);
        Assertions.notNull((String)"filename", (Object)filename);
        Assertions.notNull((String)"options", (Object)options);
        int revision = options.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort = 1;
        } else {
            skip = -revision - 1;
            sort = -1;
        }
        return GridFSPublisherCreator.createGridFSFindPublisher(filesCollection, clientSession, (Bson)new Document("filename", (Object)filename), timeout).skip(skip).sort((Bson)new Document("uploadDate", (Object)sort));
    }

    public static FindPublisher<GridFSFile> createFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, @Nullable Bson filter, @Nullable Timeout timeout) {
        Assertions.notNull((String)"filesCollection", filesCollection);
        FindPublisher<GridFSFile> publisher = clientSession == null ? TimeoutHelper.collectionWithTimeout(filesCollection, timeout).find() : TimeoutHelper.collectionWithTimeout(filesCollection, timeout).find(clientSession);
        if (filter != null) {
            publisher = publisher.filter(filter);
        }
        if (timeout != null) {
            publisher.timeoutMode(TimeoutMode.CURSOR_LIFETIME);
        }
        return publisher;
    }

    public static FindPublisher<GridFSFile> createFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, @Nullable Bson filter) {
        Assertions.notNull((String)"filesCollection", filesCollection);
        FindPublisher<GridFSFile> publisher = clientSession == null ? filesCollection.find() : filesCollection.find(clientSession);
        if (filter != null) {
            publisher = publisher.filter(filter);
        }
        if (filesCollection.getTimeout(TimeUnit.MILLISECONDS) != null) {
            publisher.timeoutMode(TimeoutMode.CURSOR_LIFETIME);
        }
        return publisher;
    }

    public static Publisher<Void> createDeletePublisher(MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, BsonValue id) {
        Assertions.notNull((String)"filesCollection", filesCollection);
        Assertions.notNull((String)"chunksCollection", chunksCollection);
        Assertions.notNull((String)"id", (Object)id);
        BsonDocument filter = new BsonDocument("_id", id);
        return Mono.defer(() -> {
            Timeout timeout = GridFSPublisherCreator.startTimeout(filesCollection.getTimeout(TimeUnit.MILLISECONDS));
            return TimeoutHelper.collectionWithTimeoutMono(filesCollection, timeout).flatMap(wrappedCollection -> {
                if (clientSession == null) {
                    return Mono.from(wrappedCollection.deleteOne((Bson)filter));
                }
                return Mono.from(wrappedCollection.deleteOne(clientSession, (Bson)filter));
            }).flatMap(deleteResult -> {
                if (deleteResult.wasAcknowledged() && deleteResult.getDeletedCount() == 0L) {
                    return Mono.error((Throwable)new MongoGridFSException(String.format("No file found with the ObjectId: %s", id)));
                }
                return TimeoutHelper.collectionWithTimeoutMono(chunksCollection, timeout);
            }).flatMap(wrappedCollection -> {
                if (clientSession == null) {
                    return Mono.from(wrappedCollection.deleteMany((Bson)new BsonDocument("files_id", id)));
                }
                return Mono.from(wrappedCollection.deleteMany(clientSession, (Bson)new BsonDocument("files_id", id)));
            }).then();
        });
    }

    public static Publisher<Void> createRenamePublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, BsonValue id, String newFilename) {
        Assertions.notNull((String)"filesCollection", filesCollection);
        Assertions.notNull((String)"id", (Object)id);
        Assertions.notNull((String)"newFilename", (Object)newFilename);
        BsonDocument filter = new BsonDocument("_id", id);
        BsonDocument update = new BsonDocument("$set", (BsonValue)new BsonDocument("filename", (BsonValue)new BsonString(newFilename)));
        Publisher<UpdateResult> publisher = clientSession == null ? filesCollection.updateOne((Bson)filter, (Bson)update) : filesCollection.updateOne(clientSession, (Bson)filter, (Bson)update);
        return Mono.from(publisher).flatMap(updateResult -> {
            if (updateResult.wasAcknowledged() && updateResult.getModifiedCount() == 0L) {
                throw new MongoGridFSException(String.format("No file found with the ObjectId: %s", id));
            }
            return Mono.empty();
        });
    }

    public static Publisher<Void> createDropPublisher(MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession) {
        return Mono.defer(() -> {
            Timeout timeout = GridFSPublisherCreator.startTimeout(filesCollection.getTimeout(TimeUnit.MILLISECONDS));
            return TimeoutHelper.collectionWithTimeoutMono(filesCollection, timeout).flatMap(wrappedCollection -> {
                if (clientSession == null) {
                    return Mono.from(wrappedCollection.drop());
                }
                return Mono.from(wrappedCollection.drop(clientSession));
            }).then(TimeoutHelper.collectionWithTimeoutDeferred(chunksCollection, timeout)).flatMap(wrappedCollection -> {
                if (clientSession == null) {
                    return Mono.from(wrappedCollection.drop());
                }
                return Mono.from(wrappedCollection.drop(clientSession));
            });
        });
    }

    @Nullable
    private static Timeout startTimeout(@Nullable Long timeoutMs) {
        return timeoutMs == null ? null : TimeoutContext.startTimeout((Long)timeoutMs);
    }
}

