/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.rx.client.DistinctObservable;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.RxObservables;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

class DistinctObservableImpl<TResult>
implements DistinctObservable<TResult> {
    private final DistinctIterable<TResult> wrapped;
    private final ObservableAdapter observableAdapter;

    DistinctObservableImpl(DistinctIterable<TResult> wrapped, ObservableAdapter observableAdapter) {
        this.wrapped = (DistinctIterable)Assertions.notNull((String)"wrapped", wrapped);
        this.observableAdapter = (ObservableAdapter)Assertions.notNull((String)"observableAdapter", (Object)observableAdapter);
    }

    @Override
    public DistinctObservable<TResult> filter(Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public DistinctObservable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public Observable<TResult> toObservable() {
        return RxObservables.create(Observables.observe(this.wrapped), this.observableAdapter);
    }

    @Override
    public Subscription subscribe(Subscriber<? super TResult> subscriber) {
        return this.toObservable().subscribe(subscriber);
    }
}

