/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.Block;
import com.mongodb.CursorType;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.rx.client.FindObservable;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.RxObservables;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

class FindObservableImpl<TResult>
implements FindObservable<TResult> {
    private final FindIterable<TResult> wrapped;
    private final ObservableAdapter observableAdapter;

    FindObservableImpl(FindIterable<TResult> wrapped, ObservableAdapter observableAdapter) {
        this.wrapped = (FindIterable)Assertions.notNull((String)"wrapped", wrapped);
        this.observableAdapter = (ObservableAdapter)Assertions.notNull((String)"observableAdapter", (Object)observableAdapter);
    }

    @Override
    public Observable<TResult> first() {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<TResult>>(){

            public void apply(SingleResultCallback<TResult> callback) {
                FindObservableImpl.this.wrapped.first(callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public FindObservable<TResult> filter(Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public FindObservable<TResult> limit(int limit) {
        this.wrapped.limit(limit);
        return this;
    }

    @Override
    public FindObservable<TResult> skip(int skip) {
        this.wrapped.skip(skip);
        return this;
    }

    @Override
    public FindObservable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindObservable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindObservable<TResult> modifiers(Bson modifiers) {
        this.wrapped.modifiers(modifiers);
        return this;
    }

    @Override
    public FindObservable<TResult> projection(Bson projection) {
        this.wrapped.projection(projection);
        return this;
    }

    @Override
    public FindObservable<TResult> sort(Bson sort) {
        this.wrapped.sort(sort);
        return this;
    }

    @Override
    public FindObservable<TResult> noCursorTimeout(boolean noCursorTimeout) {
        this.wrapped.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    public FindObservable<TResult> oplogReplay(boolean oplogReplay) {
        this.wrapped.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindObservable<TResult> partial(boolean partial) {
        this.wrapped.partial(partial);
        return this;
    }

    @Override
    public FindObservable<TResult> cursorType(CursorType cursorType) {
        this.wrapped.cursorType(cursorType);
        return this;
    }

    @Override
    public Observable<TResult> toObservable() {
        return RxObservables.create(Observables.observe(this.wrapped), this.observableAdapter);
    }

    @Override
    public Subscription subscribe(Subscriber<? super TResult> subscriber) {
        return this.toObservable().subscribe(subscriber);
    }
}

