/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.rx.client.MapReduceObservable;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.ObservableHelper;
import com.mongodb.rx.client.RxObservables;
import com.mongodb.rx.client.Success;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

class MapReduceObservableImpl<TResult>
implements MapReduceObservable<TResult> {
    private final MapReduceIterable<TResult> wrapped;
    private final ObservableAdapter observableAdapter;

    MapReduceObservableImpl(MapReduceIterable<TResult> wrapped, ObservableAdapter observableAdapter) {
        this.wrapped = (MapReduceIterable)Assertions.notNull((String)"wrapped", wrapped);
        this.observableAdapter = (ObservableAdapter)Assertions.notNull((String)"observableAdapter", (Object)observableAdapter);
    }

    @Override
    public MapReduceObservable<TResult> collectionName(String collectionName) {
        this.wrapped.collectionName(collectionName);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> finalizeFunction(String finalizeFunction) {
        this.wrapped.finalizeFunction(finalizeFunction);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> scope(Bson scope) {
        this.wrapped.scope(scope);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> sort(Bson sort) {
        this.wrapped.sort(sort);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> filter(Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> limit(int limit) {
        this.wrapped.limit(limit);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> jsMode(boolean jsMode) {
        this.wrapped.jsMode(jsMode);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> verbose(boolean verbose) {
        this.wrapped.verbose(verbose);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> action(MapReduceAction action) {
        this.wrapped.action(action);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> databaseName(String databaseName) {
        this.wrapped.databaseName(databaseName);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> sharded(boolean sharded) {
        this.wrapped.sharded(sharded);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> nonAtomic(boolean nonAtomic) {
        this.wrapped.nonAtomic(nonAtomic);
        return this;
    }

    @Override
    public MapReduceObservable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.wrapped.bypassDocumentValidation(bypassDocumentValidation);
        return this;
    }

    @Override
    public Observable<Success> toCollection() {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MapReduceObservableImpl.this.wrapped.toCollection(ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<TResult> toObservable() {
        return RxObservables.create(Observables.observe(this.wrapped), this.observableAdapter);
    }

    @Override
    public Subscription subscribe(Subscriber<? super TResult> subscriber) {
        return this.toObservable().subscribe(subscriber);
    }
}

