/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.rx.client.ListDatabasesObservable;
import com.mongodb.rx.client.ListDatabasesObservableImpl;
import com.mongodb.rx.client.MongoClient;
import com.mongodb.rx.client.MongoDatabase;
import com.mongodb.rx.client.MongoDatabaseImpl;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.RxObservables;
import org.bson.Document;
import rx.Observable;

class MongoClientImpl
implements MongoClient {
    private final com.mongodb.async.client.MongoClient wrapped;
    private final ObservableAdapter observableAdapter;

    MongoClientImpl(com.mongodb.async.client.MongoClient wrapped, ObservableAdapter observableAdapter) {
        this.wrapped = (com.mongodb.async.client.MongoClient)Assertions.notNull((String)"wrapped", (Object)wrapped);
        this.observableAdapter = (ObservableAdapter)Assertions.notNull((String)"observableAdapter", (Object)observableAdapter);
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(this.wrapped.getDatabase(name), this.observableAdapter);
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @Override
    public MongoClientSettings getSettings() {
        return this.wrapped.getSettings();
    }

    @Override
    public Observable<String> listDatabaseNames() {
        return RxObservables.create(Observables.observe((MongoIterable)this.wrapped.listDatabaseNames()), this.observableAdapter);
    }

    @Override
    public ListDatabasesObservable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    @Override
    public <TResult> ListDatabasesObservable<TResult> listDatabases(Class<TResult> clazz) {
        return new ListDatabasesObservableImpl(this.wrapped.listDatabases(clazz), this.observableAdapter);
    }
}

