/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.Block;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.rx.client.AggregateObservable;
import com.mongodb.rx.client.AggregateObservableImpl;
import com.mongodb.rx.client.DistinctObservable;
import com.mongodb.rx.client.DistinctObservableImpl;
import com.mongodb.rx.client.FindObservable;
import com.mongodb.rx.client.FindObservableImpl;
import com.mongodb.rx.client.ListIndexesObservable;
import com.mongodb.rx.client.ListIndexesObservableImpl;
import com.mongodb.rx.client.MapReduceObservable;
import com.mongodb.rx.client.MapReduceObservableImpl;
import com.mongodb.rx.client.MongoCollection;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.ObservableHelper;
import com.mongodb.rx.client.RxObservables;
import com.mongodb.rx.client.Success;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import rx.Observable;

class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final com.mongodb.async.client.MongoCollection<TDocument> wrapped;
    private final ObservableAdapter observableAdapter;

    MongoCollectionImpl(com.mongodb.async.client.MongoCollection<TDocument> wrapped, ObservableAdapter observableAdapter) {
        this.wrapped = (com.mongodb.async.client.MongoCollection)Assertions.notNull((String)"wrapped", wrapped);
        this.observableAdapter = (ObservableAdapter)Assertions.notNull((String)"observableAdapter", (Object)observableAdapter);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.wrapped.getDocumentClass();
    }

    @Override
    public ObservableAdapter getObservableAdapter() {
        return this.observableAdapter;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withDocumentClass(clazz), this.observableAdapter);
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withCodecRegistry(codecRegistry), this.observableAdapter);
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withReadPreference(readPreference), this.observableAdapter);
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withWriteConcern(writeConcern), this.observableAdapter);
    }

    @Override
    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withReadConcern(readConcern), this.observableAdapter);
    }

    @Override
    public MongoCollection<TDocument> withObservableAdapter(ObservableAdapter observableAdapter) {
        return new MongoCollectionImpl<TDocument>(this.wrapped, observableAdapter);
    }

    @Override
    public Observable<Long> count() {
        return this.count((Bson)new BsonDocument(), new CountOptions());
    }

    @Override
    public Observable<Long> count(Bson filter) {
        return this.count(filter, new CountOptions());
    }

    @Override
    public Observable<Long> count(final Bson filter, final CountOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                MongoCollectionImpl.this.wrapped.count(filter, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public <TResult> DistinctObservable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctObservable<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctObservableImpl(this.wrapped.distinct(fieldName, resultClass), this.observableAdapter).filter(filter);
    }

    @Override
    public FindObservable<TDocument> find() {
        return this.find((Bson)new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindObservable<TResult> find(Class<TResult> clazz) {
        return this.find((Bson)new BsonDocument(), clazz);
    }

    @Override
    public FindObservable<TDocument> find(Bson filter) {
        return this.find(filter, this.getDocumentClass());
    }

    @Override
    public <TResult> FindObservable<TResult> find(Bson filter, Class<TResult> clazz) {
        return new FindObservableImpl(this.wrapped.find(filter, clazz), this.observableAdapter);
    }

    @Override
    public AggregateObservable<Document> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <TResult> AggregateObservable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> clazz) {
        return new AggregateObservableImpl(this.wrapped.aggregate(pipeline, clazz), this.observableAdapter);
    }

    @Override
    public MapReduceObservable<Document> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, Document.class);
    }

    @Override
    public <TResult> MapReduceObservable<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> clazz) {
        return new MapReduceObservableImpl(this.wrapped.mapReduce(mapFunction, reduceFunction, clazz), this.observableAdapter);
    }

    @Override
    public Observable<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public Observable<BulkWriteResult> bulkWrite(final List<? extends WriteModel<? extends TDocument>> requests, final BulkWriteOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<BulkWriteResult>>(){

            public void apply(SingleResultCallback<BulkWriteResult> callback) {
                MongoCollectionImpl.this.wrapped.bulkWrite(requests, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<Success> insertOne(final TDocument document) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertOne(document, ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<Success> insertOne(final TDocument document, final InsertOneOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertOne(document, options, ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<Success> insertMany(List<? extends TDocument> documents) {
        return this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public Observable<Success> insertMany(final List<? extends TDocument> documents, final InsertManyOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertMany(documents, options, ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<DeleteResult> deleteOne(final Bson filter) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<DeleteResult>>(){

            public void apply(SingleResultCallback<DeleteResult> callback) {
                MongoCollectionImpl.this.wrapped.deleteOne(filter, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<DeleteResult> deleteMany(final Bson filter) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<DeleteResult>>(){

            public void apply(SingleResultCallback<DeleteResult> callback) {
                MongoCollectionImpl.this.wrapped.deleteMany(filter, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<UpdateResult> replaceOne(Bson filter, TDocument replacement) {
        return this.replaceOne(filter, replacement, new UpdateOptions());
    }

    @Override
    public Observable<UpdateResult> replaceOne(final Bson filter, final TDocument replacement, final UpdateOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.replaceOne(filter, replacement, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<UpdateResult> updateOne(Bson filter, Bson update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public Observable<UpdateResult> updateOne(final Bson filter, final Bson update, final UpdateOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateOne(filter, update, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<UpdateResult> updateMany(Bson filter, Bson update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public Observable<UpdateResult> updateMany(final Bson filter, final Bson update, final UpdateOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateMany(filter, update, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<TDocument> findOneAndDelete(Bson filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public Observable<TDocument> findOneAndDelete(final Bson filter, final FindOneAndDeleteOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndDelete(filter, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<TDocument> findOneAndReplace(Bson filter, TDocument replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Observable<TDocument> findOneAndReplace(final Bson filter, final TDocument replacement, final FindOneAndReplaceOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndReplace(filter, replacement, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<TDocument> findOneAndUpdate(Bson filter, Bson update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Observable<TDocument> findOneAndUpdate(final Bson filter, final Bson update, final FindOneAndUpdateOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndUpdate(filter, update, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<Success> drop() {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.drop(ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<String> createIndex(Bson key) {
        return this.createIndex(key, new IndexOptions());
    }

    @Override
    public Observable<String> createIndex(final Bson key, final IndexOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<String>>(){

            public void apply(SingleResultCallback<String> callback) {
                MongoCollectionImpl.this.wrapped.createIndex(key, options, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<String> createIndexes(final List<IndexModel> indexes) {
        return RxObservables.create(Observables.observeAndFlatten((Block)new Block<SingleResultCallback<List<String>>>(){

            public void apply(SingleResultCallback<List<String>> callback) {
                MongoCollectionImpl.this.wrapped.createIndexes(indexes, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public ListIndexesObservable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesObservable<TResult> listIndexes(Class<TResult> clazz) {
        return new ListIndexesObservableImpl(this.wrapped.listIndexes(clazz), this.observableAdapter);
    }

    @Override
    public Observable<Success> dropIndex(final String indexName) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.dropIndex(indexName, ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<Success> dropIndex(final Bson keys) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.dropIndex(keys, ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<Success> dropIndexes() {
        return this.dropIndex("*");
    }

    @Override
    public Observable<Success> renameCollection(MongoNamespace newCollectionNamespace) {
        return this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Observable<Success> renameCollection(final MongoNamespace newCollectionNamespace, final RenameCollectionOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.renameCollection(newCollectionNamespace, options, ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }
}

