/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.async.client.Observer;
import com.mongodb.async.client.Subscription;
import com.mongodb.rx.client.ObservableAdapter;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

final class RxObservables {
    static <TResult> Observable<TResult> create(final com.mongodb.async.client.Observable<TResult> observable, ObservableAdapter observableAdapter) {
        return observableAdapter.adapt(Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<TResult>(){

            public void call(Subscriber<? super TResult> subscriber) {
                new ObservableToProducer(observable, subscriber);
            }
        }));
    }

    private RxObservables() {
    }

    static final class ObservableToProducer<TResult>
    implements Producer {
        private volatile Subscription subscription;
        private final Subscriber<? super TResult> rxSubscriber;

        public ObservableToProducer(com.mongodb.async.client.Observable<TResult> observable, final Subscriber<? super TResult> rxSubscriber) {
            this.rxSubscriber = rxSubscriber;
            observable.subscribe(new Observer<TResult>(){

                public void onSubscribe(Subscription s) {
                    ObservableToProducer.this.subscription = s;
                    rxSubscriber.add(new rx.Subscription(){
                        private final AtomicBoolean unsubscribed = new AtomicBoolean();

                        public void unsubscribe() {
                            if (!this.unsubscribed.getAndSet(true)) {
                                ObservableToProducer.this.subscription.unsubscribe();
                            }
                        }

                        public boolean isUnsubscribed() {
                            return this.unsubscribed.get();
                        }
                    });
                }

                public void onNext(TResult tResult) {
                    if (ObservableToProducer.this.isSubscribed()) {
                        rxSubscriber.onNext(tResult);
                    }
                }

                public void onError(Throwable t) {
                    if (ObservableToProducer.this.isSubscribed()) {
                        rxSubscriber.onError(t);
                    }
                }

                public void onComplete() {
                    if (ObservableToProducer.this.isSubscribed()) {
                        rxSubscriber.onCompleted();
                    }
                }
            });
            rxSubscriber.setProducer((Producer)this);
        }

        public void request(long n) {
            if (this.isSubscribed()) {
                try {
                    this.subscription.request(n);
                }
                catch (Throwable t) {
                    this.rxSubscriber.onError(t);
                }
            }
        }

        private boolean isSubscribed() {
            return !this.rxSubscriber.isUnsubscribed();
        }
    }
}

