/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.internal.CollectionInfoRetriever;
import com.mongodb.client.internal.CommandMarker;
import com.mongodb.client.internal.KeyManagementService;
import com.mongodb.client.internal.KeyRetriever;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoDataKeyOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

class Crypt
implements Closeable {
    private final MongoCrypt mongoCrypt;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService) {
        this(mongoCrypt, null, null, keyRetriever, keyManagementService, false);
    }

    Crypt(MongoCrypt mongoCrypt, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, KeyRetriever keyRetriever, KeyManagementService keyManagementService, boolean bypassAutoEncryption) {
        this.mongoCrypt = mongoCrypt;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.bypassAutoEncryption = bypassAutoEncryption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawBsonDocument encrypt(String databaseName, RawBsonDocument command) {
        RawBsonDocument rawBsonDocument;
        Assertions.notNull((String)"databaseName", (Object)databaseName);
        Assertions.notNull((String)"command", (Object)command);
        if (this.bypassAutoEncryption) {
            return command;
        }
        MongoCryptContext encryptionContext = this.mongoCrypt.createEncryptionContext(databaseName, (BsonDocument)command);
        try {
            rawBsonDocument = this.executeStateMachine(encryptionContext, databaseName);
        }
        catch (Throwable throwable) {
            try {
                encryptionContext.close();
                throw throwable;
            }
            catch (MongoCryptException e) {
                throw this.wrapInClientException(e);
            }
        }
        encryptionContext.close();
        return rawBsonDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RawBsonDocument decrypt(RawBsonDocument commandResponse) {
        RawBsonDocument rawBsonDocument;
        Assertions.notNull((String)"commandResponse", (Object)commandResponse);
        MongoCryptContext decryptionContext = this.mongoCrypt.createDecryptionContext((BsonDocument)commandResponse);
        try {
            rawBsonDocument = this.executeStateMachine(decryptionContext, null);
        }
        catch (Throwable throwable) {
            try {
                decryptionContext.close();
                throw throwable;
            }
            catch (MongoCryptException e) {
                throw this.wrapInClientException(e);
            }
        }
        decryptionContext.close();
        return rawBsonDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BsonDocument createDataKey(String kmsProvider, DataKeyOptions options) {
        RawBsonDocument rawBsonDocument;
        Assertions.notNull((String)"kmsProvider", (Object)kmsProvider);
        Assertions.notNull((String)"options", (Object)options);
        MongoCryptContext dataKeyCreationContext = this.mongoCrypt.createDataKeyContext(kmsProvider, MongoDataKeyOptions.builder().keyAltNames(options.getKeyAltNames()).masterKey(options.getMasterKey()).build());
        try {
            rawBsonDocument = this.executeStateMachine(dataKeyCreationContext, null);
        }
        catch (Throwable throwable) {
            try {
                dataKeyCreationContext.close();
                throw throwable;
            }
            catch (MongoCryptException e) {
                throw this.wrapInClientException(e);
            }
        }
        dataKeyCreationContext.close();
        return rawBsonDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BsonBinary encryptExplicitly(BsonValue value, EncryptOptions options) {
        BsonBinary bsonBinary;
        Assertions.notNull((String)"value", (Object)value);
        Assertions.notNull((String)"options", (Object)options);
        MongoCryptContext encryptionContext = this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", value), MongoExplicitEncryptOptions.builder().keyId(options.getKeyId()).algorithm(options.getAlgorithm()).build());
        try {
            bsonBinary = this.executeStateMachine(encryptionContext, null).getBinary((Object)"v");
        }
        catch (Throwable throwable) {
            try {
                encryptionContext.close();
                throw throwable;
            }
            catch (MongoCryptException e) {
                throw this.wrapInClientException(e);
            }
        }
        encryptionContext.close();
        return bsonBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BsonValue decryptExplicitly(BsonBinary value) {
        BsonValue bsonValue;
        Assertions.notNull((String)"value", (Object)value);
        MongoCryptContext decryptionContext = this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", (BsonValue)value));
        try {
            bsonValue = this.executeStateMachine(decryptionContext, null).get((Object)"v");
        }
        catch (Throwable throwable) {
            try {
                decryptionContext.close();
                throw throwable;
            }
            catch (MongoCryptException e) {
                throw this.wrapInClientException(e);
            }
        }
        decryptionContext.close();
        return bsonValue;
    }

    @Override
    public void close() {
        this.mongoCrypt.close();
        this.commandMarker.close();
        this.keyRetriever.close();
    }

    private RawBsonDocument executeStateMachine(MongoCryptContext cryptContext, String databaseName) {
        MongoCryptContext.State state;
        block7: while (true) {
            state = cryptContext.getState();
            switch (state) {
                case NEED_MONGO_COLLINFO: {
                    BsonDocument collectionInfo = this.collectionInfoRetriever.filter(databaseName, (BsonDocument)cryptContext.getMongoOperation());
                    if (collectionInfo != null) {
                        cryptContext.addMongoOperationResult(collectionInfo);
                    }
                    cryptContext.completeMongoOperation();
                    continue block7;
                }
                case NEED_MONGO_MARKINGS: {
                    RawBsonDocument markedCommand = this.commandMarker.mark(databaseName, cryptContext.getMongoOperation());
                    cryptContext.addMongoOperationResult((BsonDocument)markedCommand);
                    cryptContext.completeMongoOperation();
                    continue block7;
                }
                case NEED_MONGO_KEYS: {
                    this.fetchKeys(cryptContext);
                    continue block7;
                }
                case NEED_KMS: {
                    this.decryptKeys(cryptContext);
                    continue block7;
                }
                case READY: {
                    return (RawBsonDocument)cryptContext.finish();
                }
            }
            break;
        }
        throw new MongoInternalException("Unsupported encryptor state + " + state);
    }

    private void fetchKeys(MongoCryptContext keyBroker) {
        Iterator<BsonDocument> iterator = this.keyRetriever.find((BsonDocument)keyBroker.getMongoOperation());
        while (iterator.hasNext()) {
            keyBroker.addMongoOperationResult(iterator.next());
        }
        keyBroker.completeMongoOperation();
    }

    private void decryptKeys(MongoCryptContext cryptContext) {
        MongoKeyDecryptor keyDecryptor = cryptContext.nextKeyDecryptor();
        while (keyDecryptor != null) {
            this.decryptKey(keyDecryptor);
            keyDecryptor = cryptContext.nextKeyDecryptor();
        }
        cryptContext.completeKeyDecryptors();
    }

    private void decryptKey(MongoKeyDecryptor keyDecryptor) {
        InputStream inputStream = this.keyManagementService.stream(keyDecryptor.getHostName(), keyDecryptor.getMessage());
        try {
            byte[] bytes = new byte[4096];
            int bytesNeeded = keyDecryptor.bytesNeeded();
            while (bytesNeeded > 0) {
                int bytesRead = inputStream.read(bytes, 0, bytesNeeded);
                keyDecryptor.feed(ByteBuffer.wrap(bytes, 0, bytesRead));
                bytesNeeded = keyDecryptor.bytesNeeded();
            }
        }
        catch (IOException e) {
            throw new MongoSocketReadException("Exception receiving message from key management service", new ServerAddress(keyDecryptor.getHostName(), this.keyManagementService.getPort()), (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private MongoClientException wrapInClientException(MongoCryptException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), (Throwable)e);
    }
}

