/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.BasicDBObject;
import com.mongodb.CursorType;
import com.mongodb.DBObject;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import java.util.concurrent.TimeUnit;

public final class DBCollectionFindOptions {
    private int batchSize;
    private int limit;
    private DBObject modifiers = new BasicDBObject();
    private DBObject projection;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private int skip;
    private DBObject sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean noCursorTimeout;
    private boolean oplogReplay;
    private boolean partial;
    private ReadPreference readPreference;
    private ReadConcern readConcern;
    private Collation collation;

    public DBCollectionFindOptions copy() {
        DBCollectionFindOptions copiedOptions = new DBCollectionFindOptions();
        copiedOptions.batchSize(this.batchSize);
        copiedOptions.limit(this.limit);
        copiedOptions.modifiers(this.modifiers);
        copiedOptions.projection(this.projection);
        copiedOptions.maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        copiedOptions.maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
        copiedOptions.skip(this.skip);
        copiedOptions.sort(this.sort);
        copiedOptions.cursorType(this.cursorType);
        copiedOptions.noCursorTimeout(this.noCursorTimeout);
        copiedOptions.oplogReplay(this.oplogReplay);
        copiedOptions.partial(this.partial);
        copiedOptions.readPreference(this.readPreference);
        copiedOptions.readConcern(this.readConcern);
        copiedOptions.collation(this.collation);
        return copiedOptions;
    }

    public int getLimit() {
        return this.limit;
    }

    public DBCollectionFindOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public DBCollectionFindOptions skip(int skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DBCollectionFindOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        Assertions.isTrueArgument((String)"maxTime > = 0", (maxTime >= 0L ? 1 : 0) != 0);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public DBCollectionFindOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        Assertions.isTrueArgument((String)"maxAwaitTime > = 0", (maxAwaitTime >= 0L ? 1 : 0) != 0);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public DBCollectionFindOptions batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public DBObject getModifiers() {
        return this.modifiers;
    }

    public DBCollectionFindOptions modifiers(DBObject modifiers) {
        this.modifiers = (DBObject)Assertions.notNull((String)"modifiers", (Object)modifiers);
        return this;
    }

    public DBObject getProjection() {
        return this.projection;
    }

    public DBCollectionFindOptions projection(DBObject projection) {
        this.projection = projection;
        return this;
    }

    public DBObject getSort() {
        return this.sort;
    }

    public DBCollectionFindOptions sort(DBObject sort) {
        this.sort = sort;
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public DBCollectionFindOptions noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public boolean isOplogReplay() {
        return this.oplogReplay;
    }

    public DBCollectionFindOptions oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public DBCollectionFindOptions partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public DBCollectionFindOptions cursorType(CursorType cursorType) {
        this.cursorType = (CursorType)Assertions.notNull((String)"cursorType", (Object)cursorType);
        return this;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public DBCollectionFindOptions readPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public DBCollectionFindOptions readConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public DBCollectionFindOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }
}

