/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClientSession;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.SessionContext;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

class ClientSessionContext
implements SessionContext {
    private ClientSession clientSession;

    ClientSessionContext(ClientSession clientSession) {
        this.clientSession = (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession);
    }

    ClientSession getClientSession() {
        return this.clientSession;
    }

    public boolean hasSession() {
        return true;
    }

    public BsonDocument getSessionId() {
        return this.clientSession.getServerSession().getIdentifier();
    }

    public boolean isCausallyConsistent() {
        return this.clientSession.isCausallyConsistent();
    }

    public long advanceTransactionNumber() {
        return this.clientSession.getServerSession().advanceTransactionNumber();
    }

    public BsonTimestamp getOperationTime() {
        return this.clientSession.getOperationTime();
    }

    public void advanceOperationTime(BsonTimestamp operationTime) {
        this.clientSession.advanceOperationTime(operationTime);
    }

    public BsonDocument getClusterTime() {
        return this.clientSession.getClusterTime();
    }

    public void advanceClusterTime(BsonDocument clusterTime) {
        this.clientSession.advanceClusterTime(clusterTime);
    }
}

