/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.google.common.base.Preconditions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.jdbc.BuildInfo;
import com.mongodb.jdbc.MongoConnectionProperties;
import com.mongodb.jdbc.MongoDatabaseMetaData;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoPreparedStatement;
import com.mongodb.jdbc.MongoSerializationException;
import com.mongodb.jdbc.MongoStatement;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.DisableAutoLogging;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import com.mongodb.jdbc.logging.MongoSimpleFormatter;
import com.mongodb.jdbc.mongosql.MongoSQLException;
import com.mongodb.jdbc.mongosql.MongoSQLTranslate;
import com.mongodb.jdbc.oidc.JdbcOidcCallback;
import java.io.File;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.conversions.Bson;

@AutoLoggable
public class MongoConnection
implements Connection,
LoggingAspect$ajcMightHaveAspect {
    private MongoClientSettings mongoClientSettings;
    protected MongoClient mongoClient;
    protected String currentDB;
    protected String url;
    protected String user;
    protected boolean isClosed;
    protected MongoClusterType clusterType;
    private MongoLogger logger;
    protected int connectionId;
    private static AtomicInteger connectionCounter;
    private AtomicInteger stmtCounter;
    private static ConsoleHandler consoleHandler;
    private static Map<String, Integer> handlerCount;
    private static Map<String, FileHandler> fileHandlers;
    private String logDirPath;
    private boolean extJsonMode;
    private UuidRepresentation uuidRepresentation;
    private String appName;
    private MongoSQLTranslate mongosqlTranslate;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoConnection.ajc$preClinit();
        connectionCounter = new AtomicInteger();
        handlerCount = new HashMap<String, Integer>();
        fileHandlers = new HashMap<String, FileHandler>();
    }

    public MongoConnection(MongoClient mongoClient, MongoConnectionProperties connectionProperties) {
        LoggingAspect.ajc$perObjectBind(this);
        this.stmtCounter = new AtomicInteger();
        this.connectionId = connectionCounter.incrementAndGet();
        this.initConnectionLogger(this.connectionId, this.hashCode(), connectionProperties.getLogLevel(), connectionProperties.getLogDir());
        Preconditions.checkNotNull((Object)connectionProperties.getConnectionString());
        this.initializeConnection(connectionProperties);
        this.mongoClientSettings = this.createMongoClientSettings(connectionProperties);
        this.mongoClient = mongoClient == null ? MongoClients.create((MongoClientSettings)this.mongoClientSettings, (MongoDriverInformation)MongoDriverInformation.builder().driverName(MongoDriver.NAME).driverVersion(MongoDriver.getVersion()).build()) : mongoClient;
    }

    public MongoConnection(MongoConnectionProperties connectionProperties) {
        this(null, connectionProperties);
        LoggingAspect.ajc$perObjectBind(this);
    }

    private void initializeConnection(MongoConnectionProperties connectionProperties) {
        try {
            this.url = connectionProperties.getConnectionString().getConnectionString();
            this.user = connectionProperties.getConnectionString().getUsername();
            this.currentDB = connectionProperties.getDatabase();
            this.extJsonMode = connectionProperties.getExtJsonMode();
            this.uuidRepresentation = connectionProperties.getConnectionString().getUuidRepresentation();
            this.appName = this.buildAppName(connectionProperties);
            this.mongosqlTranslate = new MongoSQLTranslate(this.logger);
            this.isClosed = false;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private String buildAppName(MongoConnectionProperties connectionProperties) {
        try {
            String[] clientInfoSplit;
            StringBuilder appNameBuilder = new StringBuilder(MongoDriver.NAME).append("+").append(MongoDriver.getVersion());
            String clientInfo = connectionProperties.getClientInfo();
            if (clientInfo != null && (clientInfoSplit = clientInfo.split("\\+")).length == 2) {
                appNameBuilder.append('|').append(clientInfo);
            }
            return appNameBuilder.toString();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    private MongoClientSettings createMongoClientSettings(MongoConnectionProperties connectionProperties) {
        try {
            MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder().applicationName(this.appName).applyConnectionString(connectionProperties.getConnectionString());
            MongoCredential credential = connectionProperties.getConnectionString().getCredential();
            if (credential != null && MongoDriver.MONGODB_OIDC.equalsIgnoreCase(credential.getMechanism())) {
                JdbcOidcCallback oidcCallback = new JdbcOidcCallback(this.logger);
                credential = MongoCredential.createOidcCredential((String)connectionProperties.getConnectionString().getUsername()).withMechanismProperty("OIDC_HUMAN_CALLBACK", (Object)oidcCallback);
                settingsBuilder.credential(credential);
            }
            return settingsBuilder.build();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    protected MongoSQLTranslate getMongosqlTranslate() {
        try {
            return this.mongosqlTranslate;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    protected MongoClusterType getClusterType() {
        try {
            return this.clusterType;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    protected MongoClient getMongoClient() {
        try {
            return this.mongoClient;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @DisableAutoLogging
    public MongoLogger getLogger() {
        try {
            return this.logger;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    protected int getNextStatementId() {
        try {
            return this.stmtCounter.incrementAndGet();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    protected void checkConnection() throws SQLException {
        try {
            if (this.isClosed) {
                throw new SQLException("Connection is closed.");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    private MongoClusterType determineClusterType() {
        try {
            BsonDocument buildInfoCmd = new BsonDocument();
            buildInfoCmd.put("buildInfo", (BsonValue)new BsonInt32(1));
            BuildInfo buildInfoRes = (BuildInfo)this.mongoClient.getDatabase("admin").withCodecRegistry(MongoDriver.registry).runCommand((Bson)buildInfoCmd, BuildInfo.class);
            if (buildInfoRes.ok != 1) {
                return MongoClusterType.UnknownTarget;
            }
            if (buildInfoRes.dataLake != null) {
                return MongoClusterType.AtlasDataFederation;
            }
            if (buildInfoRes.modules != null && buildInfoRes.modules.contains("enterprise")) {
                return MongoClusterType.Enterprise;
            }
            return MongoClusterType.Community;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this));
            }
            this.checkConnection();
            try {
                return new MongoStatement(this, this.currentDB);
            }
            catch (IllegalArgumentException e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    protected int getDefaultConnectionValidationTimeoutSeconds() {
        try {
            return this.mongoClientSettings.getSocketSettings().getConnectTimeout(TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    boolean getExtJsonMode() {
        try {
            return this.extJsonMode;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    UuidRepresentation getUuidRepresentation() {
        try {
            return this.uuidRepresentation;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    String getURL() {
        try {
            return this.url;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    String getUser() {
        try {
            return this.user;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    String getServerVersion() throws SQLException {
        try {
            this.checkConnection();
            BsonDocument command = new BsonDocument();
            command.put("buildInfo", (BsonValue)new BsonInt32(1));
            try {
                Document result = this.mongoClient.getDatabase("admin").runCommand((Bson)command);
                return (String)result.get((Object)"version");
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    protected MongoDatabase getDatabase(String DBName) {
        try {
            return this.mongoClient.getDatabase(DBName);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this));
            }
            return new MongoDatabaseMetaData(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string));
            }
            try {
                return new MongoPreparedStatement(sql, new MongoStatement(this, this.currentDB));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean bl = autoCommit;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl)));
            }
            this.checkConnection();
            this.logger.log(Level.WARNING, "Changing the auto-commit mode has no effect. The driver doesn't support transactions and is read-only. It will always report auto-commit true. Calling Commit() or Rollback() also has no effect");
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this));
            }
            this.checkConnection();
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this));
            }
            this.checkConnection();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this));
            }
            this.checkConnection();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this));
            }
            if (this.isClosed()) {
                return;
            }
            MongoConnection mongoConnection = this;
            synchronized (mongoConnection) {
                if (handlerCount != null && handlerCount.containsKey(this.logDirPath)) {
                    handlerCount.put(this.logDirPath, handlerCount.get(this.logDirPath) - 1);
                    if (handlerCount.get(this.logDirPath) == 0) {
                        if (fileHandlers != null) {
                            fileHandlers.remove(this.logDirPath);
                        }
                        handlerCount.remove(this.logDirPath);
                    }
                }
            }
            this.isClosed = true;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_26);
            }
            throw exception;
        }
    }

    @Override
    public boolean isClosed() {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this));
            }
            return this.isClosed;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_27);
            }
            throw exception;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        boolean bl = readOnly;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl)));
            }
            this.checkConnection();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_28);
            }
            throw exception;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this));
            }
            this.checkConnection();
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_29);
            }
            throw exception;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String string = catalog;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)string));
            }
            this.checkConnection();
            this.currentDB = catalog;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_30);
            }
            throw exception;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this));
            }
            this.checkConnection();
            return this.currentDB;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_31);
            }
            throw exception;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        int n = level;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkConnection();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_32);
            }
            throw exception;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this));
            }
            this.checkConnection();
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_33);
            }
            throw exception;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this));
            }
            this.checkConnection();
            return null;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_34);
            }
            throw exception;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this));
            }
            this.checkConnection();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_35);
            }
            throw exception;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2)));
            }
            if (resultSetType == 1003 && resultSetConcurrency == 1007) {
                return this.createStatement();
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_36);
            }
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String string = sql;
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object[])objectArray));
            }
            if (resultSetType == 1003 && resultSetConcurrency == 1007) {
                return this.prepareStatement(sql);
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_37);
            }
            throw exception;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String string = sql;
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_38);
            }
            throw exception;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_39);
            }
            throw exception;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        Map<String, Class<?>> map2 = map;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, map2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_40);
            }
            throw exception;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        int n3 = resultSetHoldability;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object[])objectArray));
            }
            if (resultSetType == 1003 && resultSetConcurrency == 1007) {
                return this.createStatement();
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_41);
            }
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String string = sql;
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        int n3 = resultSetHoldability;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_42);
            }
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String string = sql;
        int n = autoGeneratedKeys;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_43);
            }
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String string = sql;
        int[] nArray = columnIndexes;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)string, (Object)nArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_44);
            }
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String string = sql;
        String[] stringArray = columnNames;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)string, (Object)stringArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_45);
            }
            throw exception;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        int n = holdability;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_46);
            }
            throw exception;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_47);
            }
            throw exception;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_48);
            }
            throw exception;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        String string = name;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_49);
            }
            throw exception;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Savepoint savepoint2 = savepoint;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)savepoint2));
            }
            this.checkConnection();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_50);
            }
            throw exception;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Savepoint savepoint2 = savepoint;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)savepoint2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_51);
            }
            throw exception;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String string = sql;
        int n = resultSetType;
        int n2 = resultSetConcurrency;
        int n3 = resultSetHoldability;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_52);
            }
            throw exception;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_53);
            }
            throw exception;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_54);
            }
            throw exception;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_55);
            }
            throw exception;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_56);
            }
            throw exception;
        }
    }

    protected void testConnection(int timeout) throws SQLException, InterruptedException, ExecutionException, TimeoutException {
        try {
            if (timeout < 0) {
                throw new SQLException("Input is invalid.");
            }
            if (this.isClosed) {
                throw new SQLException("Connection is closed.");
            }
            ExecutorService executor = Executors.newCachedThreadPool();
            Future<Void> future = executor.submit(new ConnValidation());
            try {
                if (timeout > 0) {
                    future.get(timeout, TimeUnit.SECONDS);
                } else {
                    future.get();
                }
            }
            finally {
                future.cancel(true);
                executor.shutdown();
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_57);
            }
            throw exception;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        int n = timeout;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            try {
                this.testConnection(timeout);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_58);
            }
            throw exception;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        String string = name;
        String string2 = value;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw new SQLClientInfoException(null);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_59);
            }
            throw exception;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Properties properties2 = properties;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, (Object)properties2));
            }
            throw new SQLClientInfoException(null);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_60);
            }
            throw exception;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String string = name;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_61);
            }
            throw exception;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_62);
            }
            throw exception;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        String string = typeName;
        Object[] objectArray = elements;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, (Object)string, (Object)objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_63);
            }
            throw exception;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        String string = typeName;
        Object[] objectArray = attributes;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, (Object)string, (Object)objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_64);
            }
            throw exception;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        String string = schema;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this, (Object)string));
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_65);
            }
            throw exception;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this));
            }
            return null;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_66);
            }
            throw exception;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        Executor executor2 = executor;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, (Object)executor2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_67);
            }
            throw exception;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        Executor executor2 = executor;
        int n = milliseconds;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this, (Object)executor2, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_68);
            }
            throw exception;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_69);
            }
            throw exception;
        }
    }

    @Override
    public void beginRequest() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_70);
            }
            throw exception;
        }
    }

    @Override
    public void endRequest() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_71, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_71);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Class<?> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_72, (Object)this, (Object)this, clazz));
            }
            return iface.isInstance(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_72);
            }
            throw exception;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Class<T> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_73, (Object)this, (Object)this, clazz));
            }
            return (T)this;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_73);
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectionLogger(Integer connection_id, Integer connectionHashCode, Level logLevel, File logDir) {
        try {
            Logger logger = Logger.getLogger(connectionHashCode + "_" + connection_id + "_" + MongoConnection.class.getCanonicalName());
            try {
                if (logLevel != null) {
                    if (logLevel != Level.OFF) {
                        if (logDir != null) {
                            this.logDirPath = logDir.getAbsolutePath();
                            MongoConnection mongoConnection = this;
                            synchronized (mongoConnection) {
                                if (!fileHandlers.containsKey(this.logDirPath)) {
                                    String logPath = String.valueOf(this.logDirPath) + File.separator + "connection.log";
                                    FileHandler fileHandler = new FileHandler(logPath, 10000000, 1, true);
                                    fileHandler.setLevel(logLevel);
                                    fileHandler.setFormatter(new MongoSimpleFormatter());
                                    fileHandlers.put(this.logDirPath, fileHandler);
                                    if (handlerCount.containsKey(this.logDirPath)) {
                                        handlerCount.put(this.logDirPath, handlerCount.get(this.logDirPath) + 1);
                                    } else {
                                        handlerCount.put(this.logDirPath, 1);
                                    }
                                }
                                logger.addHandler(fileHandlers.get(this.logDirPath));
                            }
                        } else {
                            if (consoleHandler == null) {
                                consoleHandler = new ConsoleHandler();
                                consoleHandler.setFormatter(new SimpleFormatter());
                                consoleHandler.setLevel(logLevel);
                            }
                            logger.addHandler(consoleHandler);
                        }
                    }
                    logger.setLevel(logLevel);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            MongoLogger mongoLogger = new MongoLogger(logger, this.connectionId);
            MongoConnection mongoConnection = this;
            if (LoggingAspect.hasAspect(this)) {
                MongoConnection.logger_aroundBody1$advice(this, mongoConnection, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
            } else {
                mongoConnection.logger = mongoLogger;
            }
            this.logger.log(Level.INFO, "Connecting using MongoDB Atlas SQL interface JDBC Driver " + MongoDriver.getVersion());
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_74);
            }
            throw exception;
        }
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoConnection ajc$this, MongoConnection target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoConnection.java", MongoConnection.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeConnection", "com.mongodb.jdbc.MongoConnection", "com.mongodb.jdbc.MongoConnectionProperties", "connectionProperties", "", "void"), 135);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "buildAppName", "com.mongodb.jdbc.MongoConnection", "com.mongodb.jdbc.MongoConnectionProperties", "connectionProperties", "", "java.lang.String"), 148);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatement", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.sql.Statement"), 246);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getDefaultConnectionValidationTimeoutSeconds", "com.mongodb.jdbc.MongoConnection", "", "", "", "int"), 255);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getExtJsonMode", "com.mongodb.jdbc.MongoConnection", "", "", "", "boolean"), 259);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getUuidRepresentation", "com.mongodb.jdbc.MongoConnection", "", "", "", "org.bson.UuidRepresentation"), 263);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getURL", "com.mongodb.jdbc.MongoConnection", "", "", "", "java.lang.String"), 267);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getUser", "com.mongodb.jdbc.MongoConnection", "", "", "", "java.lang.String"), 271);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getServerVersion", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.lang.String"), 275);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getDatabase", "com.mongodb.jdbc.MongoConnection", "java.lang.String", "DBName", "", "com.mongodb.client.MongoDatabase"), 288);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetaData", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.sql.DatabaseMetaData"), 293);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nativeSQL", "com.mongodb.jdbc.MongoConnection", "java.lang.String", "sql", "java.sql.SQLException", "java.lang.String"), 298);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createMongoClientSettings", "com.mongodb.jdbc.MongoConnection", "com.mongodb.jdbc.MongoConnectionProperties", "connectionProperties", "", "com.mongodb.MongoClientSettings"), 163);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareCall", "com.mongodb.jdbc.MongoConnection", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.CallableStatement"), 304);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.mongodb.jdbc.MongoConnection", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.PreparedStatement"), 310);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAutoCommit", "com.mongodb.jdbc.MongoConnection", "boolean", "autoCommit", "java.sql.SQLException", "void"), 319);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAutoCommit", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "boolean"), 329);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "commit", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "void"), 337);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rollback", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "void"), 343);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.mongodb.jdbc.MongoConnection", "", "", "", "void"), 349);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "com.mongodb.jdbc.MongoConnection", "", "", "", "boolean"), 373);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setReadOnly", "com.mongodb.jdbc.MongoConnection", "boolean", "readOnly", "java.sql.SQLException", "void"), 378);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isReadOnly", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "boolean"), 383);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getMongosqlTranslate", "com.mongodb.jdbc.MongoConnection", "", "", "", "com.mongodb.jdbc.mongosql.MongoSQLTranslate"), 186);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCatalog", "com.mongodb.jdbc.MongoConnection", "java.lang.String", "catalog", "java.sql.SQLException", "void"), 389);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalog", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.lang.String"), 395);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTransactionIsolation", "com.mongodb.jdbc.MongoConnection", "int", "level", "java.sql.SQLException", "void"), 401);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransactionIsolation", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "int"), 406);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWarnings", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.sql.SQLWarning"), 412);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearWarnings", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "void"), 418);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatement", "com.mongodb.jdbc.MongoConnection", "int:int", "resultSetType:resultSetConcurrency", "java.sql.SQLException", "java.sql.Statement"), 424);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.mongodb.jdbc.MongoConnection", "java.lang.String:int:int", "sql:resultSetType:resultSetConcurrency", "java.sql.SQLException", "java.sql.PreparedStatement"), 436);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareCall", "com.mongodb.jdbc.MongoConnection", "java.lang.String:int:int", "sql:resultSetType:resultSetConcurrency", "java.sql.SQLException", "java.sql.CallableStatement"), 448);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTypeMap", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.util.Map"), 455);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getClusterType", "com.mongodb.jdbc.MongoConnection", "", "", "", "com.mongodb.jdbc.MongoConnection$MongoClusterType"), 190);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTypeMap", "com.mongodb.jdbc.MongoConnection", "java.util.Map", "map", "java.sql.SQLException", "void"), 461);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatement", "com.mongodb.jdbc.MongoConnection", "int:int:int", "resultSetType:resultSetConcurrency:resultSetHoldability", "java.sql.SQLException", "java.sql.Statement"), 469);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.mongodb.jdbc.MongoConnection", "java.lang.String:int:int:int", "sql:resultSetType:resultSetConcurrency:resultSetHoldability", "java.sql.SQLException", "java.sql.PreparedStatement"), 482);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.mongodb.jdbc.MongoConnection", "java.lang.String:int", "sql:autoGeneratedKeys", "java.sql.SQLException", "java.sql.PreparedStatement"), 490);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.mongodb.jdbc.MongoConnection", "java.lang.String:[I", "sql:columnIndexes", "java.sql.SQLException", "java.sql.PreparedStatement"), 497);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.mongodb.jdbc.MongoConnection", "java.lang.String:[Ljava.lang.String;", "sql:columnNames", "java.sql.SQLException", "java.sql.PreparedStatement"), 503);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setHoldability", "com.mongodb.jdbc.MongoConnection", "int", "holdability", "java.sql.SQLException", "void"), 510);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHoldability", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "int"), 516);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSavepoint", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.sql.Savepoint"), 522);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSavepoint", "com.mongodb.jdbc.MongoConnection", "java.lang.String", "name", "java.sql.SQLException", "java.sql.Savepoint"), 528);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getMongoClient", "com.mongodb.jdbc.MongoConnection", "", "", "", "com.mongodb.client.MongoClient"), 194);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rollback", "com.mongodb.jdbc.MongoConnection", "java.sql.Savepoint", "savepoint", "java.sql.SQLException", "void"), 534);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "releaseSavepoint", "com.mongodb.jdbc.MongoConnection", "java.sql.Savepoint", "savepoint", "java.sql.SQLException", "void"), 539);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareCall", "com.mongodb.jdbc.MongoConnection", "java.lang.String:int:int:int", "sql:resultSetType:resultSetConcurrency:resultSetHoldability", "java.sql.SQLException", "java.sql.CallableStatement"), 545);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createClob", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.sql.Clob"), 553);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createBlob", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.sql.Blob"), 559);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createNClob", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.sql.NClob"), 565);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createSQLXML", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.sql.SQLXML"), 571);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "testConnection", "com.mongodb.jdbc.MongoConnection", "int", "timeout", "java.sql.SQLException:java.lang.InterruptedException:java.util.concurrent.ExecutionException:java.util.concurrent.TimeoutException", "void"), 623);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isValid", "com.mongodb.jdbc.MongoConnection", "int", "timeout", "java.sql.SQLException", "boolean"), 651);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClientInfo", "com.mongodb.jdbc.MongoConnection", "java.lang.String:java.lang.String", "name:value", "java.sql.SQLClientInfoException", "void"), 662);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLogger", "com.mongodb.jdbc.MongoConnection", "", "", "", "com.mongodb.jdbc.logging.MongoLogger"), 199);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClientInfo", "com.mongodb.jdbc.MongoConnection", "java.util.Properties", "properties", "java.sql.SQLClientInfoException", "void"), 667);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientInfo", "com.mongodb.jdbc.MongoConnection", "java.lang.String", "name", "java.sql.SQLException", "java.lang.String"), 672);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientInfo", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.util.Properties"), 678);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createArrayOf", "com.mongodb.jdbc.MongoConnection", "java.lang.String:[Ljava.lang.Object;", "typeName:elements", "java.sql.SQLException", "java.sql.Array"), 684);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStruct", "com.mongodb.jdbc.MongoConnection", "java.lang.String:[Ljava.lang.Object;", "typeName:attributes", "java.sql.SQLException", "java.sql.Struct"), 690);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSchema", "com.mongodb.jdbc.MongoConnection", "java.lang.String", "schema", "java.sql.SQLException", "void"), 698);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchema", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "java.lang.String"), 704);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "abort", "com.mongodb.jdbc.MongoConnection", "java.util.concurrent.Executor", "executor", "java.sql.SQLException", "void"), 711);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNetworkTimeout", "com.mongodb.jdbc.MongoConnection", "java.util.concurrent.Executor:int", "executor:milliseconds", "java.sql.SQLException", "void"), 717);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNetworkTimeout", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "int"), 723);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getNextStatementId", "com.mongodb.jdbc.MongoConnection", "", "", "", "int"), 203);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "beginRequest", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "void"), 730);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "endRequest", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "void"), 735);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWrapperFor", "com.mongodb.jdbc.MongoConnection", "java.lang.Class", "iface", "java.sql.SQLException", "boolean"), 742);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unwrap", "com.mongodb.jdbc.MongoConnection", "java.lang.Class", "iface", "java.sql.SQLException", "java.lang.Object"), 747);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initConnectionLogger", "com.mongodb.jdbc.MongoConnection", "java.lang.Integer:java.lang.Integer:java.util.logging.Level:java.io.File", "connection_id:connectionHashCode:logLevel:logDir", "", "void"), 751);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkConnection", "com.mongodb.jdbc.MongoConnection", "", "", "java.sql.SQLException", "void"), 207);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineClusterType", "com.mongodb.jdbc.MongoConnection", "", "", "", "com.mongodb.jdbc.MongoConnection$MongoClusterType"), 213);
    }

    class ConnValidation
    implements Callable<Void> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        ConnValidation() {
        }

        @Override
        public Void call() throws SQLException, MongoSQLException, MongoSerializationException {
            try {
                MongoClusterType actualClusterType = MongoConnection.this.determineClusterType();
                switch (actualClusterType) {
                    case AtlasDataFederation: {
                        break;
                    }
                    case Community: {
                        throw new SQLException("Community edition detected. The JDBC driver is intended for use with MongoDB Enterprise edition or Atlas Data Federation.");
                    }
                    case Enterprise: {
                        if (!MongoDriver.isMongoSqlTranslateLibraryLoaded()) {
                            throw new SQLException("Enterprise edition detected, but mongosqltranslate library not found");
                        }
                        String mongosqlTranslateVersion = ((MongoConnection)MongoConnection.this).mongosqlTranslate.getMongosqlTranslateVersion().version;
                        if (!((MongoConnection)MongoConnection.this).mongosqlTranslate.checkDriverVersion().compatible.booleanValue()) {
                            throw new SQLException("Incompatible driver version. The JDBC driver version, " + MongoDriver.getVersion() + ", is not compatible with mongosqltranslate library version, " + mongosqlTranslateVersion);
                        }
                        MongoConnection.this.appName = String.valueOf(MongoConnection.this.appName) + "|libmongosqltranslate+" + mongosqlTranslateVersion;
                        break;
                    }
                    case UnknownTarget: {
                        throw new SQLException("Unknown cluster/target type detected. The JDBC driver is intended for use with MongoDB Enterprise edition or Atlas Data Federation.");
                    }
                }
                MongoConnection.this.clusterType = actualClusterType;
                return null;
            }
            catch (Exception exception) {
                if (LoggingAspect.hasAspect(this)) {
                    LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
                }
                throw exception;
            }
        }

        static {
            ConnValidation.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("MongoConnection.java", ConnValidation.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "call", "com.mongodb.jdbc.MongoConnection$ConnValidation", "", "", "java.sql.SQLException:com.mongodb.jdbc.mongosql.MongoSQLException:com.mongodb.jdbc.MongoSerializationException", "java.lang.Void"), 578);
        }
    }

    protected static enum MongoClusterType {
        AtlasDataFederation,
        Community,
        Enterprise,
        UnknownTarget;

    }
}

