/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoSecurityException;
import com.mongodb.client.MongoClient;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoConnectionProperties;
import com.mongodb.jdbc.Pair;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

public class MongoDriver
implements Driver,
LoggingAspect$ajcMightHaveAspect {
    static final String JDBC = "jdbc:";
    static final String MONGODB_URL_PREFIX = "jdbc:mongodb:";
    static final String MONGODB_SRV_URL_PREFIX = "jdbc:mongodb+srv:";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    static final String MONGODB_PRODUCT_NAME = "MongoDB Atlas";
    static final String MONGO_DRIVER_NAME = "MongoDB Atlas SQL interface JDBC Driver";
    static final String NAME;
    static final String VERSION;
    static final int MAJOR_VERSION;
    static final int MINOR_VERSION;
    static final String LEVELS;
    static final String RELAXED = "RELAXED";
    static final String EXTENDED = "EXTENDED";
    static final String MONGODB_OIDC;
    public static final String LOG_TO_CONSOLE = "console";
    protected static final String CONNECTION_ERROR_SQLSTATE = "08000";
    public static final String AUTHENTICATION_ERROR_SQLSTATE = "28000";
    private static ConcurrentHashMap<Integer, WeakReference<MongoClient>> mongoClientCache;
    private static final ReadWriteLock mongoClientCacheLock;
    private static boolean mongoSqlTranslateLibraryLoaded;
    private static final String MONGOSQL_TRANSLATE_NAME = "mongosqltranslate";
    public static final String MONGOSQL_TRANSLATE_PATH = "MONGOSQL_TRANSLATE_PATH";
    static CodecRegistry registry;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoDriver.ajc$preClinit();
        LEVELS = Arrays.toString(new String[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.FINER.getName(), Level.INFO.getName(), Level.FINE.getName(), Level.WARNING.getName()});
        MONGODB_OIDC = AuthenticationMechanism.MONGODB_OIDC.toString();
        mongoClientCache = new ConcurrentHashMap();
        mongoClientCacheLock = new ReentrantReadWriteLock();
        mongoSqlTranslateLibraryLoaded = false;
        registry = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider(), new ValueCodecProvider(), MongoClientSettings.getDefaultCodecRegistry(), PojoCodecProvider.builder().automatic(true).build()});
        MongoDriver unit = new MongoDriver();
        try {
            DriverManager.registerDriver(unit);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        VERSION = unit.getClass().getPackage().getImplementationVersion();
        if (VERSION != null) {
            String[] verSp = VERSION.split("[.]");
            if (verSp.length < 2) {
                throw new RuntimeException(new SQLException("version was not specified correctly, must contain at least major and minor parts"));
            }
            MAJOR_VERSION = Integer.parseInt(verSp[0]);
            MINOR_VERSION = Integer.parseInt(verSp[1]);
        } else {
            MAJOR_VERSION = 0;
            MINOR_VERSION = 0;
        }
        String name = unit.getClass().getPackage().getImplementationTitle();
        NAME = name != null ? name : "mongodb-jdbc";
        Runtime.getRuntime().addShutdownHook(new Thread(MongoDriver::closeAllClients));
        MongoDriver.initializeMongoSqlTranslateLibrary();
    }

    public MongoDriver() {
        LoggingAspect.ajc$perObjectBind(this);
    }

    public static String getVersion() {
        return VERSION != null ? VERSION : String.valueOf(MAJOR_VERSION) + "." + MINOR_VERSION;
    }

    private static void initializeMongoSqlTranslateLibrary() {
        try {
            String[] libraryPaths;
            String[] stringArray = libraryPaths = MongoDriver.resolveLibraryPaths();
            int n = libraryPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (MongoDriver.loadMongoSqlTranslateLibrary(path)) {
                    mongoSqlTranslateLibraryLoaded = true;
                    return;
                }
                mongoSqlTranslateLibraryLoaded = false;
                ++n2;
            }
        }
        catch (Throwable throwable) {
            mongoSqlTranslateLibraryLoaded = false;
        }
    }

    private static boolean loadMongoSqlTranslateLibrary(String libraryPath) {
        try {
            System.load(libraryPath);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static CodecRegistry getCodecRegistry() {
        return registry;
    }

    private static String[] resolveLibraryPaths() throws Exception {
        String libraryPath = MongoDriver.getLibraryPath();
        String envPath = System.getenv(MONGOSQL_TRANSLATE_PATH);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(libraryPath);
        if (envPath != null && !envPath.isEmpty()) {
            paths.add(envPath);
        }
        return paths.toArray(new String[0]);
    }

    private static String getLibraryPath() throws Exception {
        URL url = MongoDriver.class.getProtectionDomain().getCodeSource().getLocation();
        Path driverPath = Paths.get(url.toURI());
        Path driverDir = driverPath.getParent();
        return driverDir.resolve(System.mapLibraryName(MONGOSQL_TRANSLATE_NAME)).toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            block11: {
                lowerCaseprops = new Properties();
                if (info != null) {
                    keys = info.propertyNames();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement().toString();
                        lowerCaseprops.put(key.toLowerCase(), info.getProperty(key));
                    }
                }
                if ((conn = this.getUnvalidatedConnection(url, lowerCaseprops)) != null) {
                    try {
                        conn.testConnection(conn.getDefaultConnectionValidationTimeoutSeconds());
                        break block11;
                    }
                    catch (TimeoutException v0) {
                        throw new SQLTimeoutException("Couldn't connect due to a timeout. Please check your hostname and port. If necessary, set a longer connection timeout in the MongoDB URI.");
                    }
                    catch (Exception e) {
                        cause /* !! */  = e;
                        ** while (cause /* !! */  != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (cause /* !! */  instanceof MongoSecurityException) {
                            throw new SQLException("Authentication failed. Verify that the credentials are correct.", "28000", e);
                        }
                        cause /* !! */  = cause /* !! */ .getCause();
                        continue;
                    }
lbl23:
                    // 1 sources

                    throw new SQLException("Connection failed.", e);
                }
            }
            return conn;
        }
        catch (Exception var7_8) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(var7_8, MongoDriver.ajc$tjp_0);
            }
            throw var7_8;
        }
    }

    protected MongoConnection getUnvalidatedConnection(String url, Properties info) throws SQLException {
        try {
            Pair<ConnectionString, DriverPropertyInfo[]> p;
            if (!this.acceptsURL(url)) {
                return null;
            }
            if (info == null) {
                info = new Properties();
            }
            if ((p = MongoDriver.getConnectionSettings(url, info)).right().length != 0) {
                throw new SQLException(this.reportMissingProperties(p.right()), CONNECTION_ERROR_SQLSTATE);
            }
            return this.createConnection(p.left(), info);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    private String reportMissingProperties(DriverPropertyInfo[] missingRequiredProperties) {
        try {
            ArrayList<String> propertyNames = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("There are issues with your connection settings : ");
            DriverPropertyInfo[] driverPropertyInfoArray = missingRequiredProperties;
            int n = missingRequiredProperties.length;
            int n2 = 0;
            while (n2 < n) {
                DriverPropertyInfo info = driverPropertyInfoArray[n2];
                if (info.name.equals(USER)) {
                    sb.append("Password specified without user. Please provide '");
                    sb.append(USER);
                    sb.append("' property value.\n");
                } else if (info.name.equals(PASSWORD)) {
                    sb.append("User specified without password. Please provide '");
                    sb.append(PASSWORD);
                    sb.append("' property value.\n");
                } else if (info.name.equals(MongoJDBCProperty.DATABASE.getPropertyName())) {
                    sb.append("Mandatory property '");
                    sb.append(MongoJDBCProperty.DATABASE.getPropertyName());
                    sb.append("' is missing.\n");
                } else {
                    propertyNames.add(info.name);
                }
                ++n2;
            }
            if (!propertyNames.isEmpty()) {
                sb.append("Unexpected driver property info : ");
                sb.append(String.join((CharSequence)", ", propertyNames));
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    private MongoConnection createConnection(ConnectionString cs, Properties info) throws SQLException {
        try {
            MongoClient client;
            WeakReference<MongoClient> clientRef;
            File logDir;
            Level logLevel;
            String database = info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName());
            String logLevelVal = info.getProperty(MongoJDBCProperty.LOG_LEVEL.getPropertyName(), Level.OFF.getName());
            try {
                logLevel = Level.parse(logLevelVal.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SQLException("Invalid " + MongoJDBCProperty.LOG_LEVEL.getPropertyName() + " property value : " + logLevelVal + ". Valid values are : " + LEVELS + ".");
            }
            String logDirVal = info.getProperty(MongoJDBCProperty.LOG_DIR.getPropertyName());
            if (logDirVal != null && LOG_TO_CONSOLE.equalsIgnoreCase(logDirVal.trim())) {
                logDirVal = null;
            }
            File file = logDir = logDirVal == null ? null : new File(logDirVal);
            if (logDir != null && !logDir.isDirectory()) {
                throw new SQLException("Invalid " + MongoJDBCProperty.LOG_DIR.getPropertyName() + " property value : " + logDirVal + ". It must be a directory.");
            }
            String clientInfo = info.getProperty(MongoJDBCProperty.CLIENT_INFO.getPropertyName());
            if (clientInfo != null && clientInfo.split("\\+").length != 2) {
                throw new SQLException("Invalid " + MongoJDBCProperty.CLIENT_INFO.getPropertyName() + " property value : " + clientInfo + ". Expected format <name>+<version>.");
            }
            String extJsonModeVal = info.getProperty(MongoJDBCProperty.EXT_JSON_MODE.getPropertyName());
            boolean extJsonMode = false;
            if (extJsonModeVal != null) {
                if ((extJsonModeVal = extJsonModeVal.toUpperCase().trim()) == EXTENDED) {
                    extJsonMode = true;
                } else if (extJsonModeVal != RELAXED) {
                    throw new SQLException("Invalid JSON mode: " + extJsonModeVal);
                }
            }
            MongoConnectionProperties mongoConnectionProperties = new MongoConnectionProperties(cs, database, logLevel, logDir, clientInfo, extJsonMode);
            Integer key = mongoConnectionProperties.generateKey();
            mongoClientCacheLock.readLock().lock();
            try {
                clientRef = mongoClientCache.get(key);
                MongoClient mongoClient = client = clientRef != null ? (MongoClient)clientRef.get() : null;
                if (client != null) {
                    MongoConnection mongoConnection = new MongoConnection(client, mongoConnectionProperties);
                    return mongoConnection;
                }
            }
            finally {
                mongoClientCacheLock.readLock().unlock();
            }
            mongoClientCacheLock.writeLock().lock();
            try {
                clientRef = mongoClientCache.get(key);
                MongoClient mongoClient = client = clientRef != null ? (MongoClient)clientRef.get() : null;
                if (client != null) {
                    MongoConnection mongoConnection = new MongoConnection(client, mongoConnectionProperties);
                    return mongoConnection;
                }
                MongoConnection newConnection = new MongoConnection(mongoConnectionProperties);
                mongoClientCache.put(key, new WeakReference<MongoClient>(newConnection.getMongoClient()));
                MongoConnection mongoConnection = newConnection;
                return mongoConnection;
            }
            finally {
                mongoClientCacheLock.writeLock().unlock();
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    public static void closeAllClients() {
        mongoClientCacheLock.writeLock().lock();
        try {
            for (WeakReference<MongoClient> clientRef : mongoClientCache.values()) {
                MongoClient client = (MongoClient)clientRef.get();
                if (client == null) continue;
                client.close();
            }
            mongoClientCache.clear();
        }
        finally {
            mongoClientCacheLock.writeLock().unlock();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        try {
            return url.startsWith(MONGODB_URL_PREFIX) || url.startsWith(MONGODB_SRV_URL_PREFIX);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            Pair<ConnectionString, DriverPropertyInfo[]> p = MongoDriver.getConnectionSettings(url, info);
            return p.right();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public int getMajorVersion() {
        try {
            return 1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    public static boolean isMongoSqlTranslateLibraryLoaded() {
        return mongoSqlTranslateLibraryLoaded;
    }

    private static String removePrefix(String prefix, String s) {
        if (s != null && prefix != null && s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    public static Pair<ConnectionString, DriverPropertyInfo[]> getConnectionSettings(String url, Properties info) throws SQLException {
        ConnectionString originalConnectionString;
        if (info == null) {
            info = new Properties();
        }
        String actualURL = MongoDriver.removePrefix(JDBC, url);
        try {
            originalConnectionString = new ConnectionString(actualURL);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        ParseResult result = MongoDriver.normalizeConnectionOptions(originalConnectionString, info);
        String user = result.user;
        char[] password = result.password;
        ArrayList<DriverPropertyInfo> mandatoryConnectionProperties = new ArrayList<DriverPropertyInfo>();
        if ((!info.containsKey(MongoJDBCProperty.DATABASE.getPropertyName()) || info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName()).isEmpty()) && originalConnectionString.getDatabase() != null) {
            info.setProperty(MongoJDBCProperty.DATABASE.getPropertyName(), originalConnectionString.getDatabase());
        }
        if (!info.containsKey(MongoJDBCProperty.DATABASE.getPropertyName()) || info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName()).isEmpty()) {
            mandatoryConnectionProperties.add(new DriverPropertyInfo(MongoJDBCProperty.DATABASE.getPropertyName(), null));
        }
        String authDatabase = info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName());
        if (user == null && password != null) {
            mandatoryConnectionProperties.add(new DriverPropertyInfo(USER, null));
        }
        if (password == null && user != null && !MONGODB_OIDC.equalsIgnoreCase(result.authMechanism)) {
            mandatoryConnectionProperties.add(new DriverPropertyInfo(PASSWORD, null));
        }
        if (mandatoryConnectionProperties.size() > 0) {
            return new Pair<Object, DriverPropertyInfo[]>(null, mandatoryConnectionProperties.toArray(new DriverPropertyInfo[mandatoryConnectionProperties.size()]));
        }
        ConnectionString c = new ConnectionString(MongoDriver.buildNewURI(originalConnectionString.isSrvProtocol(), originalConnectionString.getHosts(), user, password, authDatabase, result.authMechanism, result.normalizedOptions));
        return new Pair<ConnectionString, DriverPropertyInfo[]>(c, new DriverPropertyInfo[0]);
    }

    private static ParseResult normalizeConnectionOptions(ConnectionString clientURI, Properties info) throws SQLException {
        char[] propertyPWD;
        String user = null;
        char[] password = null;
        if (info == null) {
            info = new Properties();
        }
        NullCoalesce<String> s = (left, right) -> {
            if (left == null) {
                return right;
            }
            return left;
        };
        NullCoalesce<char[]> c = (left, right) -> {
            if (left == null) {
                return right;
            }
            return left;
        };
        String authMechanism = clientURI.getCredential() != null ? clientURI.getCredential().getMechanism() : null;
        String uriUser = clientURI.getUsername();
        char[] uriPWD = clientURI.getPassword();
        String propertyUser = info.getProperty(USER);
        String propertyPWDStr = info.getProperty(PASSWORD);
        char[] cArray = propertyPWD = propertyPWDStr != null ? propertyPWDStr.toCharArray() : null;
        if (MONGODB_OIDC.equalsIgnoreCase(authMechanism)) {
            if (uriPWD != null || propertyPWD != null) {
                throw new SQLException("Password should not be specified when using MONGODB-OIDC authentication");
            }
            user = s.coalesce(uriUser, propertyUser);
        } else {
            if (uriUser != null && propertyUser != null && !uriUser.equals(propertyUser)) {
                throw new SQLException("uri and properties disagree on user: '" + uriUser + ", and " + propertyUser + " respectively");
            }
            user = s.coalesce(uriUser, propertyUser);
            if (user != null) {
                info.setProperty(USER, user);
            }
            if (uriPWD != null && propertyPWD != null && !Arrays.equals(uriPWD, propertyPWD)) {
                throw new SQLException("uri and properties disagree on password");
            }
            password = c.coalesce(uriPWD, propertyPWD);
        }
        String optionString = null;
        String[] optionSplit = clientURI.getConnectionString().split("[?]");
        if (optionSplit.length > 1) {
            optionString = optionSplit[1];
        }
        Properties options = new Properties();
        if (optionString != null) {
            String[] optionStrs;
            String[] stringArray = optionStrs = optionString.split("&");
            int n = optionStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String optionStr = stringArray[n2];
                String[] kv = optionStr.split("=");
                if (kv.length != 2) {
                    throw new SQLException("Option String is not valid");
                }
                String normalizedKey = kv[0].toLowerCase();
                if (!normalizedKey.equals(USER) && !normalizedKey.equals(PASSWORD)) {
                    options.put(normalizedKey, kv[1]);
                }
                ++n2;
            }
        }
        for (String key : info.stringPropertyNames()) {
            String normalizedKey = key.toLowerCase();
            if (normalizedKey.equals(USER) || normalizedKey.equals(PASSWORD)) continue;
            String val = info.getProperty(key);
            if (options.containsKey(normalizedKey)) {
                if (options.getProperty(normalizedKey).equals(val)) continue;
                throw new SQLException("uri and properties disagree on " + key);
            }
            options.setProperty(normalizedKey, val);
        }
        return new ParseResult(user, password, authMechanism, options);
    }

    private static String sqlURLEncode(String item) throws SQLException {
        try {
            return URLEncoder.encode(item, "utf-8");
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static boolean isMongoJDBCProperty(String key) {
        return Stream.of(MongoJDBCProperty.values()).anyMatch(v -> v.getPropertyName().equalsIgnoreCase(key));
    }

    private static String buildNewURI(boolean isSrvProtocol, List<String> hosts, String user, char[] password, String authDatabase, String authMechanism, Properties options) throws SQLException {
        String ret;
        String string = ret = isSrvProtocol ? "mongodb+srv://" : "mongodb://";
        if (user != null) {
            ret = String.valueOf(ret) + MongoDriver.sqlURLEncode(user);
            if (password != null) {
                ret = String.valueOf(ret) + ":" + MongoDriver.sqlURLEncode(String.valueOf(password));
            }
            ret = String.valueOf(ret) + "@";
        }
        ret = String.valueOf(ret) + String.join((CharSequence)",", hosts);
        ret = authDatabase != null ? String.valueOf(ret) + "/" + MongoDriver.sqlURLEncode(authDatabase) : String.valueOf(ret) + "/";
        StringBuilder buff = new StringBuilder();
        if (options != null) {
            for (String key : options.stringPropertyNames()) {
                if (key.equals(USER) || key.equals(PASSWORD) || MongoDriver.isMongoJDBCProperty(key)) continue;
                if (buff.length() > 0) {
                    buff.append("&");
                }
                try {
                    buff.append(key).append("=").append(URLEncoder.encode(options.getProperty(key), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException(e);
                }
            }
        }
        if (buff.length() > 0) {
            ret = String.valueOf(ret) + "?" + buff;
        }
        return ret;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoDriver.java", MongoDriver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "connect", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "java.sql.Connection"), 225);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getUnvalidatedConnection", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "com.mongodb.jdbc.MongoConnection"), 265);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reportMissingProperties", "com.mongodb.jdbc.MongoDriver", "[Ljava.sql.DriverPropertyInfo;", "missingRequiredProperties", "", "java.lang.String"), 294);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createConnection", "com.mongodb.jdbc.MongoDriver", "com.mongodb.ConnectionString:java.util.Properties", "cs:info", "java.sql.SQLException", "com.mongodb.jdbc.MongoConnection"), 324);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "acceptsURL", "com.mongodb.jdbc.MongoDriver", "java.lang.String", "url", "java.sql.SQLException", "boolean"), 431);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPropertyInfo", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "[Ljava.sql.DriverPropertyInfo;"), 436);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMajorVersion", "com.mongodb.jdbc.MongoDriver", "", "", "", "int"), 443);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinorVersion", "com.mongodb.jdbc.MongoDriver", "", "", "", "int"), 448);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jdbcCompliant", "com.mongodb.jdbc.MongoDriver", "", "", "", "boolean"), 453);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentLogger", "com.mongodb.jdbc.MongoDriver", "", "", "java.sql.SQLFeatureNotSupportedException", "java.util.logging.Logger"), 460);
    }

    public static final class MongoJDBCProperty
    extends Enum<MongoJDBCProperty> {
        public static final /* enum */ MongoJDBCProperty DATABASE;
        public static final /* enum */ MongoJDBCProperty CLIENT_INFO;
        public static final /* enum */ MongoJDBCProperty LOG_LEVEL;
        public static final /* enum */ MongoJDBCProperty LOG_DIR;
        public static final /* enum */ MongoJDBCProperty EXT_JSON_MODE;
        private final String propertyName;
        private static final /* synthetic */ MongoJDBCProperty[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        static {
            MongoJDBCProperty.ajc$preClinit();
            DATABASE = new MongoJDBCProperty("database");
            CLIENT_INFO = new MongoJDBCProperty("clientinfo");
            LOG_LEVEL = new MongoJDBCProperty("loglevel");
            LOG_DIR = new MongoJDBCProperty("logdir");
            EXT_JSON_MODE = new MongoJDBCProperty("extjsonmode");
            ENUM$VALUES = new MongoJDBCProperty[]{DATABASE, CLIENT_INFO, LOG_LEVEL, LOG_DIR, EXT_JSON_MODE};
        }

        private MongoJDBCProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            try {
                return this.propertyName;
            }
            catch (Exception exception) {
                if (LoggingAspect.hasAspect((Object)this)) {
                    LoggingAspect.aspectOf((Object)this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
                }
                throw exception;
            }
        }

        public static MongoJDBCProperty[] values() {
            MongoJDBCProperty[] mongoJDBCPropertyArray = ENUM$VALUES;
            int n = mongoJDBCPropertyArray.length;
            MongoJDBCProperty[] mongoJDBCPropertyArray2 = new MongoJDBCProperty[n];
            System.arraycopy(ENUM$VALUES, 0, mongoJDBCPropertyArray2, 0, n);
            return mongoJDBCPropertyArray2;
        }

        public static MongoJDBCProperty valueOf(String arg0) {
            return Enum.valueOf(MongoJDBCProperty.class, arg0);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("MongoDriver.java", MongoJDBCProperty.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPropertyName", "com.mongodb.jdbc.MongoDriver$MongoJDBCProperty", "", "", "", "java.lang.String"), 83);
        }
    }

    private static interface NullCoalesce<T> {
        public T coalesce(T var1, T var2);
    }

    private static class ParseResult {
        String user;
        char[] password;
        String authMechanism;
        Properties normalizedOptions;

        ParseResult(String u, char[] p, String a, Properties options) {
            this.user = u;
            this.password = p;
            this.authMechanism = a;
            this.normalizedOptions = options;
        }
    }
}

