/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.google.common.base.Preconditions;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.MongoJsonSchemaResult;
import com.mongodb.jdbc.MongoResultSet;
import com.mongodb.jdbc.MongoSerializationException;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import com.mongodb.jdbc.mongosql.GetNamespacesResult;
import com.mongodb.jdbc.mongosql.MongoSQLException;
import com.mongodb.jdbc.mongosql.MongoSQLTranslate;
import com.mongodb.jdbc.mongosql.TranslateResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@AutoLoggable
public class MongoStatement
implements Statement,
LoggingAspect$ajcMightHaveAspect {
    private static final BsonInt32 BSON_ONE_INT_VALUE;
    private MongoDatabase currentDB;
    private MongoResultSet resultSet;
    private MongoConnection conn;
    protected boolean isClosed;
    protected boolean closeOnCompletion;
    private int fetchSize;
    private int maxQuerySec;
    private String currentDBName;
    private MongoLogger logger;
    private int statementId;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoStatement.ajc$preClinit();
        BSON_ONE_INT_VALUE = new BsonInt32(1);
    }

    public MongoStatement(MongoConnection conn, String databaseName) throws SQLException {
        LoggingAspect.ajc$perObjectBind(this);
        this.isClosed = false;
        this.closeOnCompletion = false;
        this.fetchSize = 0;
        this.maxQuerySec = 0;
        Preconditions.checkNotNull((Object)conn);
        Preconditions.checkNotNull((Object)databaseName);
        this.statementId = conn.getNextStatementId();
        MongoLogger mongoLogger = new MongoLogger(this.getClass().getCanonicalName(), conn.getLogger(), this.statementId);
        MongoStatement mongoStatement = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoStatement.logger_aroundBody1$advice(this, mongoStatement, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoStatement.logger = mongoLogger;
        }
        this.conn = conn;
        this.currentDBName = databaseName;
        try {
            this.currentDB = conn.getDatabase(databaseName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException("Database name %s is invalid", databaseName);
        }
    }

    protected MongoLogger getParentLogger() {
        try {
            return this.conn.getLogger();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    protected int getStatementId() {
        try {
            return this.statementId;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    protected BsonDocument constructQueryDocument(String sql) {
        try {
            BsonDocument stage = new BsonDocument();
            BsonDocument sqlDoc = new BsonDocument();
            sqlDoc.put("statement", (BsonValue)new BsonString(sql));
            stage.put("$sql", (BsonValue)sqlDoc);
            return stage;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    protected void checkClosed() throws SQLException {
        try {
            if (this.isClosed) {
                throw new SQLException("Connection is closed.");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    private BsonDocument constructSQLGetResultSchemaDocument(String sql) {
        try {
            BsonDocument command = new BsonDocument();
            command.put("sqlGetResultSchema", (BsonValue)BSON_ONE_INT_VALUE);
            command.put("query", (BsonValue)new BsonString(sql));
            command.put("schemaVersion", (BsonValue)BSON_ONE_INT_VALUE);
            return command;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public void close() {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this));
            }
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.closeExistingResultSet();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this));
            }
            this.checkClosed();
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        int n = max;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkClosed();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this));
            }
            this.checkClosed();
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        int n = max;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkClosed();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        boolean bl = enable;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl)));
            }
            this.checkClosed();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.maxQuerySec;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        int n = seconds;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkClosed();
            this.maxQuerySec = seconds;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    protected void closeExistingResultSet() {
        try {
            try {
                try {
                    if (this.resultSet != null) {
                        this.resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    this.resultSet = null;
                }
            }
            finally {
                this.resultSet = null;
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this));
            }
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this));
            }
            this.checkClosed();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        String string = name;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string));
            }
            this.checkClosed();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string));
            }
            this.executeQuery(sql);
            return this.resultSet != null;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    private ResultSet executeAtlasDataFederationQuery(String sql) throws SQLException {
        try {
            BsonDocument getSchemaCmd = this.constructSQLGetResultSchemaDocument(sql);
            BsonDocument sqlStage = this.constructQueryDocument(sql);
            AggregateIterable iterable = this.currentDB.aggregate(Collections.singletonList(sqlStage), BsonDocument.class).maxTime((long)this.maxQuerySec, TimeUnit.SECONDS);
            if (this.fetchSize != 0) {
                iterable = iterable.batchSize(this.fetchSize);
            }
            MongoCursor cursor = iterable.cursor();
            MongoJsonSchemaResult schemaResult = (MongoJsonSchemaResult)this.currentDB.withCodecRegistry(MongoDriver.registry).runCommand((Bson)getSchemaCmd, MongoJsonSchemaResult.class);
            MongoJsonSchema schema = schemaResult.schema.mongoJsonSchema;
            List<List<String>> selectOrder = schemaResult.selectOrder;
            this.resultSet = new MongoResultSet(this, (MongoCursor<BsonDocument>)cursor, schema, selectOrder, this.conn.getExtJsonMode(), this.conn.getUuidRepresentation());
            return this.resultSet;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    private ResultSet executeDirectClusterQuery(String sql) throws MongoSQLException, MongoSerializationException, SQLException {
        try {
            MongoSQLTranslate mongoSQLTranslate = this.conn.getMongosqlTranslate();
            String dbName = this.currentDB.getName();
            GetNamespacesResult namespaceResult = mongoSQLTranslate.getNamespaces(this.currentDB.getName(), sql);
            List<GetNamespacesResult.Namespace> collections = namespaceResult.namespaces;
            if (collections == null || collections.isEmpty()) {
                throw new MongoSQLException("No collections found for the current database: " + dbName);
            }
            BsonDocument catalogDoc = mongoSQLTranslate.buildCatalogDocument(this.currentDB, dbName, collections);
            TranslateResult translateResponse = mongoSQLTranslate.translate(sql, dbName, catalogDoc);
            AggregateIterable iterable = this.currentDB.getCollection(translateResponse.targetCollection).aggregate(translateResponse.pipeline, BsonDocument.class).maxTime((long)this.maxQuerySec, TimeUnit.SECONDS);
            if (this.fetchSize != 0) {
                iterable = iterable.batchSize(this.fetchSize);
            }
            this.resultSet = new MongoResultSet(this, (MongoCursor<BsonDocument>)iterable.cursor(), translateResponse.resultSetSchema, translateResponse.selectOrder, this.conn.getExtJsonMode(), this.conn.getUuidRepresentation());
            return this.resultSet;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string));
            }
            this.checkClosed();
            this.closeExistingResultSet();
            try {
                if (this.conn.getClusterType() == MongoConnection.MongoClusterType.AtlasDataFederation) {
                    return this.executeAtlasDataFederationQuery(sql);
                }
                if (this.conn.getClusterType() == MongoConnection.MongoClusterType.Enterprise) {
                    return this.executeDirectClusterQuery(sql);
                }
                throw new SQLException("Unsupported cluster type: " + (Object)((Object)this.conn.clusterType));
            }
            catch (MongoExecutionTimeoutException e) {
                throw new SQLTimeoutException(e);
            }
            catch (MongoSerializationException | MongoSQLException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.resultSet;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this));
            }
            this.checkClosed();
            return -1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this));
            }
            this.checkClosed();
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        int n = direction;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_26);
            }
            throw exception;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        int n = rows;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkClosed();
            this.fetchSize = rows;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_27);
            }
            throw exception;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.fetchSize;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_28);
            }
            throw exception;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this));
            }
            this.checkClosed();
            return 1007;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_29);
            }
            throw exception;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this));
            }
            this.checkClosed();
            return 1003;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_30);
            }
            throw exception;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_31);
            }
            throw exception;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_32);
            }
            throw exception;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_33);
            }
            throw exception;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_34);
            }
            throw exception;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.conn;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_35);
            }
            throw exception;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        int n = current;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkClosed();
            if (current != 1 && current != 2 && current != 3) {
                throw new SQLException("Invalid input.");
            }
            if (current == 2 || current == 3) {
                throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
            }
            if (current == 1) {
                this.closeExistingResultSet();
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_36);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_37);
            }
            throw exception;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String string = sql;
        int n = autoGeneratedKeys;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_38);
            }
            throw exception;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String string = sql;
        int[] nArray = columnIndexes;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)string, (Object)nArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_39);
            }
            throw exception;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        String string = sql;
        String[] stringArray = columnNames;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)string, (Object)stringArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_40);
            }
            throw exception;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        String string = sql;
        int n = autoGeneratedKeys;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n)));
            }
            this.checkClosed();
            if (autoGeneratedKeys == 2) {
                return this.execute(sql);
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_41);
            }
            throw exception;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        String string = sql;
        int[] nArray = columnIndexes;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)string, (Object)nArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_42);
            }
            throw exception;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        String string = sql;
        String[] stringArray = columnNames;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)string, (Object)stringArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_43);
            }
            throw exception;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_44);
            }
            throw exception;
        }
    }

    @Override
    public boolean isClosed() {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this));
            }
            return this.isClosed;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_45);
            }
            throw exception;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        boolean bl = poolable;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl)));
            }
            this.checkClosed();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_46);
            }
            throw exception;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this));
            }
            this.checkClosed();
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_47);
            }
            throw exception;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this));
            }
            this.checkClosed();
            this.closeOnCompletion = true;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_48);
            }
            throw exception;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this));
            }
            this.checkClosed();
            return this.closeOnCompletion;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_49);
            }
            throw exception;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_50);
            }
            throw exception;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        long l = max;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)Conversions.longObject((long)l)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_51);
            }
            throw exception;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this));
            }
            this.checkClosed();
            return 0L;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_52);
            }
            throw exception;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_53);
            }
            throw exception;
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object)string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_54);
            }
            throw exception;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String string = sql;
        int n = autoGeneratedKeys;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_55);
            }
            throw exception;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String string = sql;
        int[] nArray = columnIndexes;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)string, (Object)nArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_56);
            }
            throw exception;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        String string = sql;
        String[] stringArray = columnNames;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)string, (Object)stringArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_57);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Class<?> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, clazz));
            }
            return iface.isInstance(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_58);
            }
            throw exception;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Class<T> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, clazz));
            }
            return (T)this;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_59);
            }
            throw exception;
        }
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoStatement ajc$this, MongoStatement target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoStatement.java", MongoStatement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getParentLogger", "com.mongodb.jdbc.MongoStatement", "", "", "", "com.mongodb.jdbc.logging.MongoLogger"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getStatementId", "com.mongodb.jdbc.MongoStatement", "", "", "", "int"), 72);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxRows", "com.mongodb.jdbc.MongoStatement", "int", "max", "java.sql.SQLException", "void"), 134);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEscapeProcessing", "com.mongodb.jdbc.MongoStatement", "boolean", "enable", "java.sql.SQLException", "void"), 139);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueryTimeout", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 144);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setQueryTimeout", "com.mongodb.jdbc.MongoStatement", "int", "seconds", "java.sql.SQLException", "void"), 150);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "closeExistingResultSet", "com.mongodb.jdbc.MongoStatement", "", "", "", "void"), 156);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWarnings", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "java.sql.SQLWarning"), 169);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearWarnings", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "void"), 175);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCursorName", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "name", "java.sql.SQLException", "void"), 180);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "java.sql.SQLException", "boolean"), 187);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "executeAtlasDataFederationQuery", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.ResultSet"), 192);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "constructQueryDocument", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "", "org.bson.BsonDocument"), 76);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "executeDirectClusterQuery", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "com.mongodb.jdbc.mongosql.MongoSQLException:com.mongodb.jdbc.MongoSerializationException:java.sql.SQLException", "java.sql.ResultSet"), 225);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeQuery", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.ResultSet"), 264);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSet", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 284);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUpdateCount", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 290);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMoreResults", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "boolean"), 296);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchDirection", "com.mongodb.jdbc.MongoStatement", "int", "direction", "java.sql.SQLException", "void"), 305);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchDirection", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 311);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchSize", "com.mongodb.jdbc.MongoStatement", "int", "rows", "java.sql.SQLException", "void"), 317);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchSize", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 323);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSetConcurrency", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 329);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkClosed", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "void"), 84);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSetType", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 335);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBatch", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "java.sql.SQLException", "void"), 341);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearBatch", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "void"), 347);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeBatch", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "[I"), 353);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancel", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "void"), 359);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnection", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "java.sql.Connection"), 365);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMoreResults", "com.mongodb.jdbc.MongoStatement", "int", "current", "java.sql.SQLException", "boolean"), 373);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGeneratedKeys", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 393);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeUpdate", "com.mongodb.jdbc.MongoStatement", "java.lang.String:int", "sql:autoGeneratedKeys", "java.sql.SQLException", "int"), 399);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeUpdate", "com.mongodb.jdbc.MongoStatement", "java.lang.String:[I", "sql:columnIndexes", "java.sql.SQLException", "int"), 405);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "constructSQLGetResultSchemaDocument", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "", "org.bson.BsonDocument"), 90);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeUpdate", "com.mongodb.jdbc.MongoStatement", "java.lang.String:[Ljava.lang.String;", "sql:columnNames", "java.sql.SQLException", "int"), 411);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.mongodb.jdbc.MongoStatement", "java.lang.String:int", "sql:autoGeneratedKeys", "java.sql.SQLException", "boolean"), 417);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.mongodb.jdbc.MongoStatement", "java.lang.String:[I", "sql:columnIndexes", "java.sql.SQLException", "boolean"), 427);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.mongodb.jdbc.MongoStatement", "java.lang.String:[Ljava.lang.String;", "sql:columnNames", "java.sql.SQLException", "boolean"), 433);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSetHoldability", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 439);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "com.mongodb.jdbc.MongoStatement", "", "", "", "boolean"), 445);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPoolable", "com.mongodb.jdbc.MongoStatement", "boolean", "poolable", "java.sql.SQLException", "void"), 450);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isPoolable", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "boolean"), 455);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeOnCompletion", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "void"), 463);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCloseOnCompletion", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "boolean"), 469);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeUpdate", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "java.sql.SQLException", "int"), 101);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLargeUpdateCount", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "long"), 477);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLargeMaxRows", "com.mongodb.jdbc.MongoStatement", "long", "max", "java.sql.SQLException", "void"), 483);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLargeMaxRows", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "long"), 489);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeLargeBatch", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "[J"), 495);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeLargeUpdate", "com.mongodb.jdbc.MongoStatement", "java.lang.String", "sql", "java.sql.SQLException", "long"), 501);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeLargeUpdate", "com.mongodb.jdbc.MongoStatement", "java.lang.String:int", "sql:autoGeneratedKeys", "java.sql.SQLException", "long"), 507);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeLargeUpdate", "com.mongodb.jdbc.MongoStatement", "java.lang.String:[I", "sql:columnIndexes", "java.sql.SQLException", "long"), 513);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeLargeUpdate", "com.mongodb.jdbc.MongoStatement", "java.lang.String:[Ljava.lang.String;", "sql:columnNames", "java.sql.SQLException", "long"), 519);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWrapperFor", "com.mongodb.jdbc.MongoStatement", "java.lang.Class", "iface", "java.sql.SQLException", "boolean"), 525);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unwrap", "com.mongodb.jdbc.MongoStatement", "java.lang.Class", "iface", "java.sql.SQLException", "java.lang.Object"), 530);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.mongodb.jdbc.MongoStatement", "", "", "", "void"), 107);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxFieldSize", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 117);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxFieldSize", "com.mongodb.jdbc.MongoStatement", "int", "max", "java.sql.SQLException", "void"), 123);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxRows", "com.mongodb.jdbc.MongoStatement", "", "", "java.sql.SQLException", "int"), 128);
    }
}

