/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.mongosql;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.jdbc.BsonUtils;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoJsonSchemaResult;
import com.mongodb.jdbc.MongoSerializationException;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import com.mongodb.jdbc.mongosql.BaseResult;
import com.mongodb.jdbc.mongosql.CheckDriverVersionResult;
import com.mongodb.jdbc.mongosql.GetMongosqlTranslateVersionResult;
import com.mongodb.jdbc.mongosql.GetNamespacesResult;
import com.mongodb.jdbc.mongosql.MongoSQLException;
import com.mongodb.jdbc.mongosql.TranslateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonInt32;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@AutoLoggable
public class MongoSQLTranslate {
    public static final String SQL_SCHEMAS_COLLECTION = "__sql_schemas";
    private final MongoLogger logger;
    private final CodecRegistry pojoCodecRegistry;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public native byte[] runCommand(byte[] var1, int var2);

    public MongoSQLTranslate(MongoLogger logger) {
        MongoLogger mongoLogger = logger;
        MongoSQLTranslate mongoSQLTranslate = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoSQLTranslate.logger_aroundBody1$advice(this, mongoSQLTranslate, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoSQLTranslate.logger = mongoLogger;
        }
        this.pojoCodecRegistry = MongoDriver.getCodecRegistry();
    }

    public <T extends BaseResult> T runCommand(BsonDocument command, Class<T> responseClass) throws MongoSerializationException, MongoSQLException {
        try {
            byte[] commandBytes = BsonUtils.serialize(command);
            byte[] responseBytes = this.runCommand(commandBytes, commandBytes.length);
            BsonDocument responseDoc = BsonUtils.deserialize(responseBytes);
            BsonDocumentReader reader = new BsonDocumentReader(responseDoc);
            BaseResult result = (BaseResult)this.pojoCodecRegistry.get(responseClass).decode((BsonReader)reader, DecoderContext.builder().build());
            if (result.hasError()) {
                String errorMessage = String.format("Error executing command: %s. Error is internal: %s", result.getError(), result.getErrorIsInternal());
                throw new MongoSQLException(errorMessage);
            }
            return (T)result;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    public GetMongosqlTranslateVersionResult getMongosqlTranslateVersion() throws MongoSQLException, MongoSerializationException {
        try {
            BsonDocument command = new BsonDocument("command", (BsonValue)new BsonString("getMongosqlTranslateVersion")).append("options", (BsonValue)new BsonDocument());
            GetMongosqlTranslateVersionResult versionResult = this.runCommand(command, GetMongosqlTranslateVersionResult.class);
            this.logger.log(Level.INFO, "mongosqlTranslateVersion: " + versionResult.version);
            return versionResult;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    public CheckDriverVersionResult checkDriverVersion() throws MongoSQLException, MongoSerializationException {
        try {
            BsonDocument options = new BsonDocument("driverVersion", (BsonValue)new BsonString(MongoDriver.getVersion())).append("odbcDriver", (BsonValue)new BsonBoolean(false));
            BsonDocument command = new BsonDocument("command", (BsonValue)new BsonString("checkDriverVersion")).append("options", (BsonValue)options);
            CheckDriverVersionResult checkDriverVersionResult = this.runCommand(command, CheckDriverVersionResult.class);
            this.logger.log(Level.INFO, "Driver Compatibility Status: " + checkDriverVersionResult.compatible);
            return checkDriverVersionResult;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    public TranslateResult translate(String sql, String dbName, BsonDocument schemaCatalog) throws MongoSQLException, MongoSerializationException {
        try {
            BsonDocument options = new BsonDocument("sql", (BsonValue)new BsonString(sql)).append("db", (BsonValue)new BsonString(dbName)).append("excludeNamespaces", (BsonValue)new BsonBoolean(false)).append("relaxSchemaChecking", (BsonValue)new BsonBoolean(true)).append("schemaCatalog", (BsonValue)schemaCatalog);
            BsonDocument translateCommand = new BsonDocument("command", (BsonValue)new BsonString("translate")).append("options", (BsonValue)options);
            return this.runCommand(translateCommand, TranslateResult.class);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    public GetNamespacesResult getNamespaces(String dbName, String sql) throws MongoSQLException, MongoSerializationException {
        try {
            BsonDocument options = new BsonDocument("sql", (BsonValue)new BsonString(sql)).append("db", (BsonValue)new BsonString(dbName));
            BsonDocument command = new BsonDocument("command", (BsonValue)new BsonString("getNamespaces")).append("options", (BsonValue)options);
            return this.runCommand(command, GetNamespacesResult.class);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    public BsonDocument buildCatalogDocument(MongoDatabase mongoDatabase, String dbName, List<GetNamespacesResult.Namespace> collections) throws MongoSQLException {
        try {
            List collectionNames = collections.stream().map(ns -> ns.collection).collect(Collectors.toList());
            Bson matchStage = Aggregates.match((Bson)Filters.in((String)"_id", collectionNames));
            Bson projectStage = Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"schema"}), Projections.include((String[])new String[]{"_id"})}));
            Bson groupStage = Aggregates.group(null, (BsonField[])new BsonField[]{Accumulators.push((String)"collections", (Object)new BsonDocument("collectionName", (BsonValue)new BsonString("$_id")).append("schema", (BsonValue)new BsonString("$schema")))});
            Bson finalProjectStage = Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.excludeId(), Projections.computed((String)dbName, (Object)new BsonDocument("$arrayToObject", (BsonValue)new BsonArray(Arrays.asList(new BsonDocument("$map", (BsonValue)new BsonDocument("input", (BsonValue)new BsonString("$collections")).append("as", (BsonValue)new BsonString("coll")).append("in", (BsonValue)new BsonDocument("k", (BsonValue)new BsonString("$$coll.collectionName")).append("v", (BsonValue)new BsonString("$$coll.schema"))))))))}));
            List<Bson> pipeline = Arrays.asList(matchStage, projectStage, groupStage, finalProjectStage);
            MongoCollection collection = mongoDatabase.getCollection(SQL_SCHEMAS_COLLECTION, BsonDocument.class);
            AggregateIterable result = collection.aggregate(pipeline);
            BsonDocument catalog = null;
            boolean foundResult = false;
            for (BsonDocument doc : result) {
                if (foundResult) {
                    throw new MongoSQLException("Multiple results returned while getting schema; expected only one.");
                }
                catalog = doc;
                foundResult = true;
            }
            if (!foundResult) {
                throw new MongoSQLException("No schema information returned for the requested collections.");
            }
            BsonDocument resultCollections = catalog.getDocument((Object)dbName);
            ArrayList returnedCollections = new ArrayList(resultCollections.keySet());
            List missingCollections = collections.stream().map(ns -> ns.collection).filter(c -> !returnedCollections.contains(c)).collect(Collectors.toList());
            if (!missingCollections.isEmpty()) {
                throw new MongoSQLException("Could not retrieve schema for collections: " + missingCollections);
            }
            return catalog;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    public MongoJsonSchemaResult getSchema(MongoDatabase mongoDatabase, String collectionName) throws MongoSerializationException, MongoSQLException {
        try {
            List<Bson> pipeline = Arrays.asList(Aggregates.match((Bson)Filters.eq((String)"_id", (Object)collectionName)), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.exclude((String[])new String[]{"_id"}), Projections.computed((String)"schema.jsonSchema", (Object)"$schema"), Projections.computed((String)"schema.version", (Object)new BsonInt32(1))})), Aggregates.addFields((Field[])new Field[]{new Field("ok", (Object)new BsonInt32(1))}));
            MongoCollection schemasCollection = mongoDatabase.getCollection(SQL_SCHEMAS_COLLECTION, BsonDocument.class);
            AggregateIterable result = schemasCollection.aggregate(pipeline);
            BsonDocument resultDoc = (BsonDocument)result.first();
            if (resultDoc == null) {
                throw new MongoSQLException("No schema found for collection: " + collectionName);
            }
            BsonDocumentReader reader = new BsonDocumentReader(resultDoc);
            MongoJsonSchemaResult mongoJsonSchemaResult = (MongoJsonSchemaResult)this.pojoCodecRegistry.get(MongoJsonSchemaResult.class).decode((BsonReader)reader, DecoderContext.builder().build());
            return mongoJsonSchemaResult;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    static {
        MongoSQLTranslate.ajc$preClinit();
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoSQLTranslate ajc$this, MongoSQLTranslate target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoSQLTranslate.java", MongoSQLTranslate.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runCommand", "com.mongodb.jdbc.mongosql.MongoSQLTranslate", "org.bson.BsonDocument:java.lang.Class", "command:responseClass", "com.mongodb.jdbc.MongoSerializationException:com.mongodb.jdbc.mongosql.MongoSQLException", "com.mongodb.jdbc.mongosql.BaseResult"), 67);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMongosqlTranslateVersion", "com.mongodb.jdbc.mongosql.MongoSQLTranslate", "", "", "com.mongodb.jdbc.mongosql.MongoSQLException:com.mongodb.jdbc.MongoSerializationException", "com.mongodb.jdbc.mongosql.GetMongosqlTranslateVersionResult"), 99);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkDriverVersion", "com.mongodb.jdbc.mongosql.MongoSQLTranslate", "", "", "com.mongodb.jdbc.mongosql.MongoSQLException:com.mongodb.jdbc.MongoSerializationException", "com.mongodb.jdbc.mongosql.CheckDriverVersionResult"), 120);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "translate", "com.mongodb.jdbc.mongosql.MongoSQLTranslate", "java.lang.String:java.lang.String:org.bson.BsonDocument", "sql:dbName:schemaCatalog", "com.mongodb.jdbc.mongosql.MongoSQLException:com.mongodb.jdbc.MongoSerializationException", "com.mongodb.jdbc.mongosql.TranslateResult"), 148);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNamespaces", "com.mongodb.jdbc.mongosql.MongoSQLTranslate", "java.lang.String:java.lang.String", "dbName:sql", "com.mongodb.jdbc.mongosql.MongoSQLException:com.mongodb.jdbc.MongoSerializationException", "com.mongodb.jdbc.mongosql.GetNamespacesResult"), 175);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildCatalogDocument", "com.mongodb.jdbc.mongosql.MongoSQLTranslate", "com.mongodb.client.MongoDatabase:java.lang.String:java.util.List", "mongoDatabase:dbName:collections", "com.mongodb.jdbc.mongosql.MongoSQLException", "org.bson.BsonDocument"), 187);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchema", "com.mongodb.jdbc.mongosql.MongoSQLTranslate", "com.mongodb.client.MongoDatabase:java.lang.String", "mongoDatabase:collectionName", "com.mongodb.jdbc.MongoSerializationException:com.mongodb.jdbc.mongosql.MongoSQLException", "com.mongodb.jdbc.MongoJsonSchemaResult"), 301);
    }
}

