/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.mongosql;

import com.mongodb.jdbc.JsonSchema;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.mongosql.BaseResult;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public class TranslateResult
extends BaseResult {
    public final String targetDb;
    public final String targetCollection;
    public final List<BsonDocument> pipeline;
    public final MongoJsonSchema resultSetSchema;
    public final List<List<String>> selectOrder;

    @BsonCreator
    public TranslateResult(@BsonProperty(value="target_db") String targetDb, @BsonProperty(value="target_collection") String targetCollection, @BsonProperty(value="pipeline") List<BsonDocument> pipeline, @BsonProperty(value="result_set_schema") JsonSchema resultSetSchema, @BsonProperty(value="select_order") List<List<String>> selectOrder, @BsonProperty(value="error") String error, @BsonProperty(value="error_is_internal") Boolean errorIsInternal) {
        super(error, errorIsInternal);
        this.targetDb = targetDb;
        this.targetCollection = targetCollection;
        this.pipeline = pipeline;
        this.resultSetSchema = resultSetSchema != null ? MongoJsonSchema.toSimplifiedMongoJsonSchema(resultSetSchema) : null;
        this.selectOrder = selectOrder;
    }
}

