/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.oidc;

import com.mongodb.MongoCredential;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import com.mongodb.jdbc.oidc.OidcResponse;
import com.mongodb.jdbc.oidc.OidcTimeoutException;
import com.mongodb.jdbc.oidc.RFC8252HttpServer;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.awt.Desktop;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.RefreshFailedException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class OidcAuthFlow {
    private static final Logger logger;
    private MongoLogger mongoLogger;
    private static final String OFFLINE_ACCESS = "offline_access";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        OidcAuthFlow.ajc$preClinit();
        logger = Logger.getLogger(OidcAuthFlow.class.getName());
    }

    public OidcAuthFlow() {
    }

    public OidcAuthFlow(MongoLogger parentLogger) {
        MongoLogger mongoLogger = new MongoLogger(OidcAuthFlow.class.getName(), parentLogger);
        OidcAuthFlow oidcAuthFlow = this;
        if (LoggingAspect.hasAspect(this)) {
            OidcAuthFlow.mongoLogger_aroundBody1$advice(this, oidcAuthFlow, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            oidcAuthFlow.mongoLogger = mongoLogger;
        }
    }

    public MongoCredential.OidcCallbackResult doAuthCodeFlow(MongoCredential.OidcCallbackContext callbackContext) throws OidcTimeoutException {
        try {
            MongoCredential.IdpInfo idpServerInfo = callbackContext.getIdpInfo();
            String clientID = idpServerInfo.getClientId();
            String issuerURI = idpServerInfo.getIssuer();
            if (!this.validateIdpInfo(idpServerInfo, clientID, issuerURI)) {
                return null;
            }
            RFC8252HttpServer server = new RFC8252HttpServer();
            try {
                OIDCProviderMetadata providerMetadata = OIDCProviderMetadata.resolve((Issuer)new Issuer(issuerURI));
                URI authorizationEndpoint = providerMetadata.getAuthorizationEndpointURI();
                URI tokenEndpoint = providerMetadata.getTokenEndpointURI();
                Scope supportedScopes = providerMetadata.getScopes();
                List scopesList = idpServerInfo.getRequestScopes();
                Scope requestedScopes = new Scope();
                if (scopesList != null) {
                    for (String scope : scopesList) {
                        if (supportedScopes != null && supportedScopes.contains(scope)) {
                            requestedScopes.add((Object)new Scope.Value(scope));
                            continue;
                        }
                        logger.warning("Requested scope '" + scope + "' is not supported by the IdP");
                    }
                }
                if (!scopesList.contains(OFFLINE_ACCESS)) {
                    if (supportedScopes != null && supportedScopes.contains(OFFLINE_ACCESS)) {
                        requestedScopes.add((Object)new Scope.Value(OFFLINE_ACCESS));
                    } else {
                        logger.info("Offline access (refresh token) is not supported by the OIDC provider");
                    }
                }
                server.start();
                URI redirectURI = new URI("http://localhost:27097/redirect");
                State state = new State();
                CodeVerifier codeVerifier = new CodeVerifier();
                AuthorizationRequest request = new AuthorizationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), new ClientID(clientID)).scope(requestedScopes).redirectionURI(redirectURI).state(state).codeChallenge(codeVerifier, CodeChallengeMethod.S256).endpointURI(authorizationEndpoint).build();
                if (!Desktop.isDesktopSupported()) {
                    this.log(Level.SEVERE, "Desktop operations not supported");
                    return null;
                }
                Desktop.getDesktop().browse(request.toURI());
                OidcResponse response = server.getOidcResponse(callbackContext.getTimeout());
                if (response == null || !state.getValue().equals(response.getState())) {
                    this.log(Level.SEVERE, "OIDC response is null or returned an invalid state");
                    return null;
                }
                AuthorizationCode code = new AuthorizationCode(response.getCode());
                AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(code, redirectURI, codeVerifier);
                TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, new ClientID(clientID), (AuthorizationGrant)codeGrant);
                HTTPResponse httpResponse = tokenRequest.toHTTPRequest().send();
                TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
                if (!tokenResponse.indicatesSuccess()) {
                    this.log(Level.SEVERE, "Token request failed with response: " + httpResponse.getBody());
                    return null;
                }
                MongoCredential.OidcCallbackResult oidcCallbackResult = this.getOidcCallbackResultFromTokenResponse((OIDCTokenResponse)tokenResponse);
                return oidcCallbackResult;
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Error during OIDC authentication " + e.getMessage());
                if (e instanceof OidcTimeoutException) {
                    throw (OidcTimeoutException)e;
                }
                return null;
            }
            finally {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    this.log(Level.WARNING, "Thread interrupted " + e.getMessage());
                }
                server.stop();
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private void log(Level level, String message) {
        try {
            if (this.mongoLogger != null) {
                this.mongoLogger.log(level, message);
            } else {
                logger.log(level, message);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    public MongoCredential.OidcCallbackResult doRefresh(MongoCredential.OidcCallbackContext callbackContext) throws RefreshFailedException {
        try {
            MongoCredential.IdpInfo idpServerInfo = callbackContext.getIdpInfo();
            String clientID = idpServerInfo.getClientId();
            String issuerURI = idpServerInfo.getIssuer();
            if (!this.validateIdpInfo(idpServerInfo, clientID, issuerURI)) {
                return null;
            }
            try {
                OIDCProviderMetadata providerMetadata = OIDCProviderMetadata.resolve((Issuer)new Issuer(issuerURI));
                URI tokenEndpoint = providerMetadata.getTokenEndpointURI();
                String refreshToken = callbackContext.getRefreshToken();
                if (refreshToken == null) {
                    throw new IllegalArgumentException("Refresh token is required");
                }
                RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(new RefreshToken(refreshToken));
                TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, new ClientID(clientID), (AuthorizationGrant)refreshTokenGrant);
                HTTPResponse httpResponse = tokenRequest.toHTTPRequest().send();
                try {
                    TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
                    if (!tokenResponse.indicatesSuccess()) {
                        TokenErrorResponse errorResponse = tokenResponse.toErrorResponse();
                        String errorCode = errorResponse.getErrorObject() != null ? errorResponse.getErrorObject().getCode() : null;
                        String errorDescription = errorResponse.getErrorObject() != null ? errorResponse.getErrorObject().getDescription() : null;
                        throw new RefreshFailedException("Token refresh failed with error: code=" + errorCode + ", description=" + errorDescription);
                    }
                    return this.getOidcCallbackResultFromTokenResponse((OIDCTokenResponse)tokenResponse);
                }
                catch (ParseException e) {
                    throw new RefreshFailedException("Failed to parse server response: " + e.getMessage() + " [response=" + httpResponse.getBody() + "]");
                }
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "OpenID Connect: Error during token refresh. " + e.getMessage());
                if (e instanceof RefreshFailedException) {
                    throw (RefreshFailedException)e;
                }
                return null;
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    private boolean validateIdpInfo(MongoCredential.IdpInfo idpInfo, String clientID, String issuerURI) {
        try {
            if (idpInfo == null) {
                this.log(Level.SEVERE, "IdpServerInfo is null");
                return false;
            }
            if (clientID == null || clientID.isEmpty()) {
                this.log(Level.SEVERE, "Client ID is null or empty");
                return false;
            }
            if (!issuerURI.startsWith("https")) {
                this.log(Level.SEVERE, "Issuer URI must be HTTPS");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    private MongoCredential.OidcCallbackResult getOidcCallbackResultFromTokenResponse(OIDCTokenResponse tokenResponse) {
        try {
            OIDCTokens tokens = tokenResponse.getOIDCTokens();
            String accessToken = tokens.getAccessToken().getValue();
            String refreshToken = tokens.getRefreshToken() != null ? tokens.getRefreshToken().getValue() : null;
            Duration expiresIn = Duration.ofSeconds(tokens.getAccessToken().getLifetime());
            return new MongoCredential.OidcCallbackResult(accessToken, expiresIn, refreshToken);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    private static final /* synthetic */ Object mongoLogger_aroundBody1$advice(OidcAuthFlow ajc$this, OidcAuthFlow target, MongoLogger mongoLogger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger2 = arg;
        target.mongoLogger = mongoLogger2;
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OidcAuthFlow.java", OidcAuthFlow.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doAuthCodeFlow", "com.mongodb.jdbc.oidc.OidcAuthFlow", "com.mongodb.MongoCredential$OidcCallbackContext", "callbackContext", "com.mongodb.jdbc.oidc.OidcTimeoutException", "com.mongodb.MongoCredential$OidcCallbackResult"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "log", "com.mongodb.jdbc.oidc.OidcAuthFlow", "java.util.logging.Level:java.lang.String", "level:message", "", "void"), 180);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doRefresh", "com.mongodb.jdbc.oidc.OidcAuthFlow", "com.mongodb.MongoCredential$OidcCallbackContext", "callbackContext", "javax.security.auth.RefreshFailedException", "com.mongodb.MongoCredential$OidcCallbackResult"), 188);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateIdpInfo", "com.mongodb.jdbc.oidc.OidcAuthFlow", "com.mongodb.MongoCredential$IdpInfo:java.lang.String:java.lang.String", "idpInfo:clientID:issuerURI", "", "boolean"), 255);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getOidcCallbackResultFromTokenResponse", "com.mongodb.jdbc.oidc.OidcAuthFlow", "com.nimbusds.openid.connect.sdk.OIDCTokenResponse", "tokenResponse", "", "com.mongodb.MongoCredential$OidcCallbackResult"), 271);
    }
}

