/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.mongosql.auth.plugin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.sql.SQLException;

final class BufferHelper {
    static final Charset UTF_8 = Charset.forName("UTF-8");

    static void writeBytes(ByteArrayOutputStream baos, byte[] bytes) {
        try {
            baos.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("ByteArrayOutputStream doesn't throw IOExeption!", e);
        }
    }

    static void writeByte(ByteArrayOutputStream baos, byte b) throws SQLException {
        baos.write(b);
    }

    static void writeInt(ByteArrayOutputStream baos, int i) throws SQLException {
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
        sizeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        sizeBuffer.putInt(i);
        BufferHelper.writeBytes(baos, sizeBuffer.array());
    }

    private BufferHelper() {
    }
}

