/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.mongosql.auth.plugin;

import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

final class Gssapi {
    private static final String SERVICE_NAME_DEFAULT_VALUE = "mongosql";
    private static final String GSSAPI_OID = "1.2.840.113554.1.2.2";

    static SaslClient createSaslClient(String user, String hostName) throws SaslException {
        HashMap<String, Object> saslClientProperties = new HashMap<String, Object>();
        saslClientProperties.put("javax.security.sasl.maxbuffer", "0");
        saslClientProperties.put("javax.security.sasl.credentials", Gssapi.getGSSCredential(user));
        return Sasl.createSaslClient(new String[]{"GSSAPI"}, user, SERVICE_NAME_DEFAULT_VALUE, hostName, saslClientProperties, null);
    }

    private static GSSCredential getGSSCredential(String userName) throws SaslException {
        try {
            Oid krb5Mechanism = new Oid(GSSAPI_OID);
            GSSManager manager = GSSManager.getInstance();
            GSSName name = manager.createName(userName, GSSName.NT_USER_NAME);
            return manager.createCredential(name, Integer.MAX_VALUE, krb5Mechanism, 1);
        }
        catch (GSSException e) {
            throw new SaslException("Unable to create GSSAPI credential", e);
        }
    }

    private Gssapi() {
    }
}

