/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.mongosql.auth.plugin;

import com.mysql.jdbc.AuthenticationPlugin;
import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.StringUtils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.mongodb.mongosql.auth.plugin.BufferHelper;
import org.mongodb.mongosql.auth.plugin.Gssapi;
import org.mongodb.mongosql.auth.plugin.Plain;
import org.mongodb.mongosql.auth.plugin.ScramSha1;

public class MongoSqlAuthenticationPlugin
implements AuthenticationPlugin {
    private String user;
    private String password;
    private boolean firstChallenge = true;
    private String hostName;
    private final List<SaslClient> saslClients = new ArrayList<SaslClient>();

    public String getProtocolPluginName() {
        return "mongosql_auth";
    }

    public boolean requiresConfidentiality() {
        return false;
    }

    public boolean isReusable() {
        return false;
    }

    public void setAuthenticationParameters(String user, String password) {
        this.user = user.contains("?") ? user.substring(0, user.indexOf("?")) : user;
        this.password = password;
    }

    public void init(Connection conn, Properties props) throws SQLException {
        this.hostName = conn.getHost();
    }

    public void destroy() {
        for (SaslClient saslClient : this.saslClients) {
            try {
                saslClient.dispose();
            }
            catch (SaslException saslException) {}
        }
    }

    public boolean nextAuthenticationStep(Buffer fromServer, List<Buffer> toServer) throws SQLException {
        try {
            toServer.clear();
            if (fromServer == null) {
                throw SQLError.createSQLException((String)"Unexpected empty challenge ", (String)"S1000", null);
            }
            if (this.firstChallenge) {
                this.firstChallenge = false;
                toServer.add(new Buffer(new byte[0]));
                return true;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(fromServer.getByteBuffer(), 0, fromServer.getBufLength());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (this.saslClients.isEmpty()) {
                String mechanism = this.readString(byteBuffer);
                int iterations = byteBuffer.getInt();
                for (int i = 0; i < iterations; ++i) {
                    this.saslClients.add(this.createSaslClient(mechanism));
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (SaslClient saslClient : this.saslClients) {
                byte[] response = saslClient.evaluateChallenge(this.getNextChallenge(byteBuffer));
                BufferHelper.writeByte(baos, (byte)(saslClient.isComplete() ? 1 : 0));
                BufferHelper.writeInt(baos, response.length);
                BufferHelper.writeBytes(baos, response);
            }
            toServer.add(new Buffer(baos.toByteArray()));
            return true;
        }
        catch (SaslException e) {
            throw SQLError.createSQLException((String)"mongosql_auth authentication exception ", (String)"S1000", (Throwable)e, null);
        }
    }

    String getUser() {
        return this.user;
    }

    private SaslClient createSaslClient(String mechanism) throws SaslException {
        if (mechanism.equals("SCRAM-SHA-1")) {
            return ScramSha1.createSaslClient(this.user, this.password);
        }
        if (mechanism.equals("PLAIN")) {
            return Plain.createSaslClient(this.user, this.password);
        }
        if (mechanism.equals("GSSAPI")) {
            return Gssapi.createSaslClient(this.user, this.hostName);
        }
        throw new SaslException("Unsupported SASL mechanism " + mechanism);
    }

    private byte[] getNextChallenge(ByteBuffer fromServer) {
        if (fromServer.remaining() == 0) {
            return new byte[0];
        }
        byte[] challengeBytes = new byte[fromServer.getInt()];
        fromServer.get(challengeBytes);
        return challengeBytes;
    }

    private String readString(ByteBuffer byteBuffer) {
        int len = 0;
        int maxLen = byteBuffer.limit();
        for (int i = byteBuffer.position(); i < maxLen && byteBuffer.get(i) != 0; ++i) {
            ++len;
        }
        String s = StringUtils.toString((byte[])byteBuffer.array(), (int)byteBuffer.position(), (int)len);
        byteBuffer.position(byteBuffer.position() + len + 1);
        return s;
    }
}

