/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.mongosql.auth.plugin;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.mongodb.mongosql.auth.plugin.Base64Codec;
import org.mongodb.mongosql.auth.plugin.BufferHelper;

final class ScramSha1 {
    static SaslClient createSaslClient(String user, String password) {
        return ScramSha1.createSaslClient(user, password, new DefaultRandomStringGenerator());
    }

    static SaslClient createSaslClient(String user, String password, RandomStringGenerator randomStringGenerator) {
        return new ScramSha1SaslClient(user, randomStringGenerator, password);
    }

    private ScramSha1() {
    }

    private static class DefaultRandomStringGenerator
    implements RandomStringGenerator {
        private DefaultRandomStringGenerator() {
        }

        @Override
        public String generate(int length) {
            int comma = 44;
            int low = 33;
            int high = 126;
            int range = high - low;
            SecureRandom random = new SecureRandom();
            char[] text = new char[length];
            for (int i = 0; i < length; ++i) {
                int next = random.nextInt(range) + low;
                while (next == comma) {
                    next = random.nextInt(range) + low;
                }
                text[i] = (char)next;
            }
            return new String(text);
        }
    }

    private static class ScramSha1SaslClient
    implements SaslClient {
        private static final String GS2_HEADER = "n,,";
        private static final int RANDOM_LENGTH = 24;
        private final Base64Codec base64Codec;
        private final String user;
        private final RandomStringGenerator randomStringGenerator;
        private final String password;
        private String clientFirstMessageBare;
        private String rPrefix;
        private byte[] serverSignature;
        private int step;

        ScramSha1SaslClient(String user, RandomStringGenerator randomStringGenerator, String password) {
            this.user = user;
            this.randomStringGenerator = randomStringGenerator;
            this.password = password;
            this.base64Codec = new Base64Codec();
        }

        @Override
        public String getMechanismName() {
            return "SCRAM-SHA-1";
        }

        @Override
        public boolean hasInitialResponse() {
            return true;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
            ++this.step;
            if (this.step == 1) {
                return this.computeClientFirstMessage();
            }
            if (this.step == 2) {
                return this.computeClientFinalMessage(challenge);
            }
            if (this.step == 3) {
                String serverResponse = this.encodeUTF8(challenge);
                HashMap<String, String> map = this.parseServerResponse(serverResponse);
                if (!MessageDigest.isEqual(this.decodeBase64(map.get("v")), this.serverSignature)) {
                    throw new SaslException("Server signature was invalid.");
                }
                return new byte[0];
            }
            throw new SaslException("Too many steps involved in the SCRAM-SHA-1 negotiation.");
        }

        @Override
        public boolean isComplete() {
            return this.step >= 3;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            throw new UnsupportedOperationException("Not implemented ");
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void dispose() throws SaslException {
        }

        private byte[] computeClientFirstMessage() throws SaslException {
            String userName = "n=" + this.prepUserName(this.user);
            this.rPrefix = this.randomStringGenerator.generate(24);
            String nonce = "r=" + this.rPrefix;
            this.clientFirstMessageBare = userName + "," + nonce;
            String clientFirstMessage = GS2_HEADER + this.clientFirstMessageBare;
            return this.decodeUTF8(clientFirstMessage);
        }

        private byte[] computeClientFinalMessage(byte[] challenge) throws SaslException {
            String serverFirstMessage = this.encodeUTF8(challenge);
            HashMap<String, String> map = this.parseServerResponse(serverFirstMessage);
            String r = map.get("r");
            if (!r.startsWith(this.rPrefix)) {
                throw new SaslException("Server sent an invalid nonce.");
            }
            String s = map.get("s");
            String i = map.get("i");
            String channelBinding = "c=" + this.encodeBase64(this.decodeUTF8(GS2_HEADER));
            String nonce = "r=" + r;
            String clientFinalMessageWithoutProof = channelBinding + "," + nonce;
            byte[] saltedPassword = this.hi(this.createAuthenticationHash(this.user, this.password), this.decodeBase64(s), Integer.parseInt(i));
            byte[] clientKey = this.hmac(saltedPassword, "Client Key");
            byte[] storedKey = this.h(clientKey);
            String authMessage = this.clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            byte[] clientSignature = this.hmac(storedKey, authMessage);
            byte[] clientProof = this.xor(clientKey, clientSignature);
            byte[] serverKey = this.hmac(saltedPassword, "Server Key");
            this.serverSignature = this.hmac(serverKey, authMessage);
            String proof = "p=" + this.encodeBase64(clientProof);
            String clientFinalMessage = clientFinalMessageWithoutProof + "," + proof;
            return this.decodeUTF8(clientFinalMessage);
        }

        private byte[] decodeBase64(String str) {
            return this.base64Codec.decode(str);
        }

        private byte[] decodeUTF8(String str) throws SaslException {
            try {
                return str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("UTF-8 is not a supported encoding.", e);
            }
        }

        private String encodeBase64(byte[] bytes) {
            return this.base64Codec.encode(bytes);
        }

        private String encodeUTF8(byte[] bytes) throws SaslException {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("UTF-8 is not a supported encoding.", e);
            }
        }

        private byte[] h(byte[] data) throws SaslException {
            try {
                return MessageDigest.getInstance("SHA-1").digest(data);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("SHA-1 could not be found.", e);
            }
        }

        private byte[] hi(String password, byte[] salt, int iterations) throws SaslException {
            SecretKeyFactory keyFactory;
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, 160);
            try {
                keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Unable to find PBKDF2WithHmacSHA1.", e);
            }
            try {
                return keyFactory.generateSecret(spec).getEncoded();
            }
            catch (InvalidKeySpecException e) {
                throw new SaslException("Invalid key spec for PBKDC2WithHmacSHA1.", e);
            }
        }

        private byte[] hmac(byte[] bytes, String key) throws SaslException {
            Mac mac;
            SecretKeySpec signingKey = new SecretKeySpec(bytes, "HmacSHA1");
            try {
                mac = Mac.getInstance("HmacSHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Could not find HmacSHA1.", e);
            }
            try {
                mac.init(signingKey);
            }
            catch (InvalidKeyException e) {
                throw new SaslException("Could not initialize mac.", e);
            }
            return mac.doFinal(this.decodeUTF8(key));
        }

        private HashMap<String, String> parseServerResponse(String response) {
            String[] pairs;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : pairs = response.split(",")) {
                String[] parts = pair.split("=", 2);
                map.put(parts[0], parts[1]);
            }
            return map;
        }

        private String prepUserName(String userName) {
            return userName.replace("=", "=3D").replace(",", "=2D");
        }

        private byte[] xor(byte[] a, byte[] b) {
            byte[] result = new byte[a.length];
            for (int i = 0; i < a.length; ++i) {
                result[i] = (byte)(a[i] ^ b[i]);
            }
            return result;
        }

        private String createAuthenticationHash(String user, String password) throws SaslException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(user.length() + 20 + password.length());
            BufferHelper.writeBytes(baos, user.getBytes(BufferHelper.UTF_8));
            BufferHelper.writeBytes(baos, ":mongo:".getBytes(BufferHelper.UTF_8));
            BufferHelper.writeBytes(baos, password.getBytes(BufferHelper.UTF_8));
            return this.hexMD5(baos.toByteArray());
        }

        private String hexMD5(byte[] data) throws SaslException {
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.reset();
                md5.update(data);
                byte[] digest = md5.digest();
                return this.toHex(digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("MD5 is an unsupported digest type", e);
            }
        }

        private String toHex(byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                String s = Integer.toHexString(0xFF & b);
                if (s.length() < 2) {
                    sb.append("0");
                }
                sb.append(s);
            }
            return sb.toString();
        }
    }

    static interface RandomStringGenerator {
        public String generate(int var1);
    }
}

