/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.mongosql.auth.plugin;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.mongodb.mongosql.auth.plugin.Base64Codec;
import org.mongodb.mongosql.auth.plugin.BufferHelper;
import org.mongodb.mongosql.auth.plugin.SaslPrep;

final class ScramSha {
    private static final AuthenticationHashGenerator DEFAULT_AUTHENTICATION_HASH_GENERATOR = new AuthenticationHashGenerator(){

        @Override
        public String generate(String user, String password) throws SaslException, IllegalArgumentException {
            if (password == null) {
                throw new IllegalArgumentException("Password must not be null");
            }
            return password;
        }
    };
    private static final AuthenticationHashGenerator LEGACY_AUTHENTICATION_HASH_GENERATOR = new AuthenticationHashGenerator(){

        @Override
        public String generate(String user, String password) throws SaslException, IllegalArgumentException {
            if (user == null || password == null) {
                throw new IllegalArgumentException("Username and password must not be null");
            }
            return ScramSha.createAuthenticationHash(user, password);
        }
    };

    static SaslClient createSaslClient(String user, String password, String mechanism) {
        return ScramSha.createSaslClient(user, password, mechanism, new DefaultRandomStringGenerator(), ScramSha.getAuthenticationHashGenerator(mechanism));
    }

    static SaslClient createSaslClient(String user, String password, String mechanism, RandomStringGenerator randomStringGenerator) {
        return ScramSha.createSaslClient(user, password, mechanism, randomStringGenerator, ScramSha.getAuthenticationHashGenerator(mechanism));
    }

    static SaslClient createSaslClient(String user, String password, String mechanism, RandomStringGenerator randomStringGenerator, AuthenticationHashGenerator authenticationHashGenerator) {
        return new ScramShaSaslClient(user, password, mechanism, randomStringGenerator, authenticationHashGenerator);
    }

    private static AuthenticationHashGenerator getAuthenticationHashGenerator(String authenticationMechanism) {
        return authenticationMechanism.equals("SCRAM-SHA-1") ? LEGACY_AUTHENTICATION_HASH_GENERATOR : DEFAULT_AUTHENTICATION_HASH_GENERATOR;
    }

    private static String createAuthenticationHash(String user, String password) throws SaslException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(user.length() + 20 + password.length());
        BufferHelper.writeBytes(baos, user.getBytes(BufferHelper.UTF_8));
        BufferHelper.writeBytes(baos, ":mongo:".getBytes(BufferHelper.UTF_8));
        BufferHelper.writeBytes(baos, password.getBytes(BufferHelper.UTF_8));
        return ScramSha.hexMD5(baos.toByteArray());
    }

    private static String hexMD5(byte[] data) throws SaslException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(data);
            byte[] digest = md5.digest();
            return ScramSha.toHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("MD5 is an unsupported digest type", e);
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String s = Integer.toHexString(0xFF & b);
            if (s.length() < 2) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private ScramSha() {
    }

    private static class DefaultRandomStringGenerator
    implements RandomStringGenerator {
        private DefaultRandomStringGenerator() {
        }

        @Override
        public String generate(int length) {
            int comma = 44;
            int low = 33;
            int high = 126;
            int range = high - low;
            SecureRandom random = new SecureRandom();
            char[] text = new char[length];
            for (int i = 0; i < length; ++i) {
                int next = random.nextInt(range) + low;
                while (next == comma) {
                    next = random.nextInt(range) + low;
                }
                text[i] = (char)next;
            }
            return new String(text);
        }
    }

    private static class ScramShaSaslClient
    implements SaslClient {
        private static final String GS2_HEADER = "n,,";
        private static final int RANDOM_LENGTH = 24;
        private static final int MINIMUM_ITERATION_COUNT = 4096;
        private static final String SHA_1 = "SCRAM-SHA-1";
        private static final String SHA_256 = "SCRAM-SHA-256";
        private static final byte[] INT_1 = new byte[]{0, 0, 0, 1};
        private final Base64Codec base64Codec;
        private final String user;
        private final String password;
        private final RandomStringGenerator randomStringGenerator;
        private final AuthenticationHashGenerator authenticationHashGenerator;
        private final String hmacAlgorithm;
        private final String hAlgorithm;
        private final String mechanism;
        private String clientFirstMessageBare;
        private String rPrefix;
        private byte[] serverSignature;
        private int step;

        ScramShaSaslClient(String user, String password, String mechanism, RandomStringGenerator randomStringGenerator, AuthenticationHashGenerator authenticationHashGenerator) {
            this.user = user;
            this.password = password;
            this.mechanism = mechanism;
            this.randomStringGenerator = randomStringGenerator;
            this.authenticationHashGenerator = authenticationHashGenerator;
            this.base64Codec = new Base64Codec();
            if (mechanism.equals(SHA_1)) {
                this.hmacAlgorithm = "HmacSHA1";
                this.hAlgorithm = "SHA-1";
            } else {
                this.hmacAlgorithm = "HmacSHA256";
                this.hAlgorithm = "SHA-256";
            }
        }

        @Override
        public String getMechanismName() {
            return this.hmacAlgorithm;
        }

        @Override
        public boolean hasInitialResponse() {
            return true;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
            ++this.step;
            if (this.step == 1) {
                return this.computeClientFirstMessage();
            }
            if (this.step == 2) {
                return this.computeClientFinalMessage(challenge);
            }
            if (this.step == 3) {
                String serverResponse = this.encodeUTF8(challenge);
                HashMap<String, String> map = this.parseServerResponse(serverResponse);
                if (!MessageDigest.isEqual(this.decodeBase64(map.get("v")), this.serverSignature)) {
                    throw new SaslException("Server signature was invalid.");
                }
                return new byte[0];
            }
            throw new SaslException(String.format("Too many steps involved in the %s negotiation.", this.mechanism));
        }

        @Override
        public boolean isComplete() {
            return this.step >= 3;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            throw new UnsupportedOperationException("Not implemented ");
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void dispose() throws SaslException {
        }

        private byte[] computeClientFirstMessage() throws SaslException {
            String userName = "n=" + this.prepUserName(this.user);
            this.rPrefix = this.randomStringGenerator.generate(24);
            String nonce = "r=" + this.rPrefix;
            this.clientFirstMessageBare = userName + "," + nonce;
            String clientFirstMessage = GS2_HEADER + this.clientFirstMessageBare;
            return this.decodeUTF8(clientFirstMessage);
        }

        private byte[] computeClientFinalMessage(byte[] challenge) throws SaslException {
            String serverFirstMessage = this.encodeUTF8(challenge);
            HashMap<String, String> map = this.parseServerResponse(serverFirstMessage);
            String serverNonce = map.get("r");
            if (!serverNonce.startsWith(this.rPrefix)) {
                throw new SaslException("Server sent an invalid nonce.");
            }
            String salt = map.get("s");
            int iterationCount = Integer.parseInt(map.get("i"));
            if (iterationCount < 4096) {
                throw new SaslException("Invalid iteration count.");
            }
            String channelBinding = "c=" + this.encodeBase64(GS2_HEADER);
            String nonce = "r=" + serverNonce;
            String clientFinalMessageWithoutProof = channelBinding + "," + nonce;
            String authMessage = this.clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            String password = this.authenticationHashGenerator.generate(this.user, this.password);
            if (this.mechanism.equals(SHA_256)) {
                password = SaslPrep.saslPrepStored(password);
            }
            byte[] saltedPassword = this.hi(this.decodeUTF8(password), this.decodeBase64(salt), iterationCount);
            byte[] clientKey = this.hmac(saltedPassword, "Client Key");
            byte[] storedKey = this.h(clientKey);
            byte[] clientSignature = this.hmac(storedKey, authMessage);
            byte[] clientProof = this.xor(clientKey, clientSignature);
            byte[] serverKey = this.hmac(saltedPassword, "Server Key");
            this.serverSignature = this.hmac(serverKey, authMessage);
            String proof = "p=" + this.encodeBase64(clientProof);
            String clientFinalMessage = clientFinalMessageWithoutProof + "," + proof;
            return this.decodeUTF8(clientFinalMessage);
        }

        private byte[] decodeBase64(String str) {
            return this.base64Codec.decode(str);
        }

        private byte[] decodeUTF8(String str) throws SaslException {
            try {
                return str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("UTF-8 is not a supported encoding.", e);
            }
        }

        private String encodeBase64(String str) throws SaslException {
            return this.base64Codec.encode(this.decodeUTF8(str));
        }

        private String encodeBase64(byte[] bytes) {
            return this.base64Codec.encode(bytes);
        }

        private String encodeUTF8(byte[] bytes) throws SaslException {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("UTF-8 is not a supported encoding.", e);
            }
        }

        private byte[] h(byte[] data) throws SaslException {
            try {
                return MessageDigest.getInstance(this.hAlgorithm).digest(data);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException(String.format("%s could not be found.", this.hAlgorithm), e);
            }
        }

        private byte[] hi(byte[] password, byte[] salt, int iterations) throws SaslException {
            try {
                SecretKeySpec key = new SecretKeySpec(password, this.hmacAlgorithm);
                Mac mac = Mac.getInstance(this.hmacAlgorithm);
                mac.init(key);
                mac.update(salt);
                mac.update(INT_1);
                byte[] result = mac.doFinal();
                byte[] previous = null;
                for (int i = 1; i < iterations; ++i) {
                    mac.update(previous != null ? previous : result);
                    previous = mac.doFinal();
                    this.xorInPlace(result, previous);
                }
                return result;
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException(String.format("Algorithm for '%s' could not be found.", this.hmacAlgorithm), e);
            }
            catch (InvalidKeyException e) {
                throw new SaslException(String.format("Invalid key for %s", this.hmacAlgorithm), e);
            }
        }

        private byte[] hmac(byte[] bytes, String key) throws SaslException {
            Mac mac;
            SecretKeySpec signingKey = new SecretKeySpec(bytes, this.hmacAlgorithm);
            try {
                mac = Mac.getInstance(this.hmacAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException(String.format("Could not find %s.", this.hmacAlgorithm), e);
            }
            try {
                mac.init(signingKey);
            }
            catch (InvalidKeyException e) {
                throw new SaslException("Could not initialize mac.", e);
            }
            return mac.doFinal(this.decodeUTF8(key));
        }

        private HashMap<String, String> parseServerResponse(String response) {
            String[] pairs;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : pairs = response.split(",")) {
                String[] parts = pair.split("=", 2);
                map.put(parts[0], parts[1]);
            }
            return map;
        }

        private String prepUserName(String userName) {
            String user = userName.replace("=", "=3D").replace(",", "=2C");
            return user;
        }

        private byte[] xorInPlace(byte[] a, byte[] b) {
            for (int i = 0; i < a.length; ++i) {
                int n = i;
                a[n] = (byte)(a[n] ^ b[i]);
            }
            return a;
        }

        private byte[] xor(byte[] a, byte[] b) {
            byte[] result = new byte[a.length];
            for (int i = 0; i < a.length; ++i) {
                result[i] = (byte)(a[i] ^ b[i]);
            }
            return result;
        }
    }

    public static interface AuthenticationHashGenerator {
        public String generate(String var1, String var2) throws SaslException, IllegalArgumentException;
    }

    static interface RandomStringGenerator {
        public String generate(int var1);
    }
}

