/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.scala.bson.codecs.macrocodecs;

import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.mongodb.scala.bson.BsonNull$;
import org.mongodb.scala.bson.codecs.macrocodecs.MacroCodec;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class MacroCodec$class {
    public static boolean hasClassFieldName(MacroCodec $this) {
        return $this.caseClassesMap().size() > 1;
    }

    public static Map caseClassesMapInv(MacroCodec $this) {
        return (Map)$this.caseClassesMap().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Class<?>, String> apply(Tuple2<String, Class<?>> x$1) {
                return x$1.swap();
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public static void encode(MacroCodec $this, BsonWriter writer, Object value, EncoderContext encoderContext) {
        if (value == null) {
            throw new BsonInvalidOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value for ", " found a `null` value."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.encoderClass()})));
        }
        $this.writeValue(writer, value, encoderContext);
    }

    public static Object decode(MacroCodec $this, BsonReader reader, DecoderContext decoderContext) {
        String className = $this.getClassName(reader, decoderContext);
        Map fieldTypeArgsMap = (Map)$this.classFieldTypeArgsMap().apply((Object)className);
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            BoxedUnit boxedUnit;
            List typeArgs;
            String name;
            String string = name = reader.readName();
            String string2 = $this.classFieldName();
            List list = !(string != null ? !string.equals(string2) : string2 != null) ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{String.class})) : (typeArgs = (List)fieldTypeArgsMap.getOrElse((Object)name, (Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final List<Nothing$> apply() {
                    return List$.MODULE$.empty();
                }
            }));
            if (typeArgs.isEmpty()) {
                reader.skipValue();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = map.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), $this.readValue(reader, decoderContext, (Class)typeArgs.head(), (List)typeArgs.tail(), fieldTypeArgsMap)));
        }
        reader.readEndDocument();
        return $this.getInstance(className, (Map<String, Object>)map.toMap(Predef$.MODULE$.$conforms()));
    }

    public static Class getEncoderClass(MacroCodec $this) {
        return $this.encoderClass();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getClassName(MacroCodec $this, BsonReader reader, DecoderContext decoderContext) {
        String string;
        if ($this.hasClassFieldName()) {
            BsonReaderMark mark = reader.getMark();
            reader.readStartDocument();
            Option optionalClassName = MacroCodec$class.readOptionalClassName$1($this, reader, decoderContext);
            mark.reset();
            String className = (String)optionalClassName.getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MacroCodec $outer;

                public final Nothing$ apply() {
                    throw new BsonInvalidOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not decode sealed case class. Missing '", "' field."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.classFieldName()})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (!$this.caseClassesMap().contains((Object)className)) void var5_5;
            throw new BsonInvalidOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not decode sealed case class, unknown class ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5})));
            string = className;
            return string;
        } else {
            string = (String)((Tuple2)$this.caseClassesMap().head())._1();
        }
        return string;
    }

    public static void writeClassFieldName(MacroCodec $this, BsonWriter writer, String className, EncoderContext encoderContext) {
        if ($this.hasClassFieldName()) {
            writer.writeName($this.classFieldName());
            $this.writeValue(writer, className, encoderContext);
        }
    }

    public static void writeFieldValue(MacroCodec $this, String fieldName, BsonWriter writer, Object value, EncoderContext encoderContext) {
        if (value == null) {
            throw new BsonInvalidOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value for ", " found a `null` value."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName})));
        }
        $this.writeValue(writer, value, encoderContext);
    }

    public static void writeValue(MacroCodec $this, BsonWriter writer, Object value, EncoderContext encoderContext) {
        Option option;
        block4: {
            block3: {
                Class<?> clazz;
                block2: {
                    clazz = value.getClass();
                    option = $this.caseClassesMapInv().get(clazz);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String className = (String)some.x();
                    $this.writeCaseClassData(className, writer, value, encoderContext);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Codec codec = $this.registry().get(clazz);
                encoderContext.encodeWithChildContext((Encoder)codec, writer, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static Object readValue(MacroCodec $this, BsonReader reader, DecoderContext decoderContext, Class clazz, List typeArgs, Map fieldTypeArgsMap) {
        Object object;
        BsonType currentType = reader.getCurrentBsonType();
        BsonType bsonType = currentType;
        if (BsonType.DOCUMENT.equals(bsonType)) {
            object = $this.readDocument(reader, decoderContext, clazz, typeArgs, fieldTypeArgsMap);
        } else if (BsonType.ARRAY.equals(bsonType)) {
            object = $this.readArray(reader, decoderContext, clazz, typeArgs, fieldTypeArgsMap);
        } else if (BsonType.NULL.equals(bsonType)) {
            reader.readNull();
            object = null;
        } else {
            object = $this.registry().get(clazz).decode(reader, decoderContext);
        }
        return object;
    }

    public static Object readArray(MacroCodec $this, BsonReader reader, DecoderContext decoderContext, Class clazz, List typeArgs, Map fieldTypeArgsMap) {
        if (typeArgs.isEmpty()) {
            throw new BsonInvalidOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid Bson format for '", "'. Found a list but there is no type data."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getSimpleName()})));
        }
        reader.readStartArray();
        ListBuffer list = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.append((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.readValue(reader, decoderContext, (Class)typeArgs.head(), (List)typeArgs.tail(), fieldTypeArgsMap)}));
        }
        reader.readEndArray();
        return Set.class.isAssignableFrom(clazz) ? list.toSet() : (Vector.class.isAssignableFrom(clazz) ? list.toVector() : (Stream.class.isAssignableFrom(clazz) ? list.toStream() : list.toList()));
    }

    public static Object readDocument(MacroCodec $this, BsonReader reader, DecoderContext decoderContext, Class clazz, List typeArgs, Map fieldTypeArgsMap) {
        Object object;
        if (BoxesRunTime.unboxToBoolean((Object)$this.classToCaseClassMap().getOrElse((Object)clazz, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        })) || typeArgs.isEmpty()) {
            object = $this.registry().get(clazz).decode(reader, decoderContext);
        } else {
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            reader.readStartDocument();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                BoxedUnit boxedUnit;
                String name = reader.readName();
                List fieldClazzTypeArgs = (List)fieldTypeArgsMap.getOrElse((Object)name, (Function0)new Serializable($this, typeArgs){
                    public static final long serialVersionUID = 0L;
                    private final List typeArgs$1;

                    public final List<Class<?>> apply() {
                        return this.typeArgs$1;
                    }
                    {
                        this.typeArgs$1 = typeArgs$1;
                    }
                });
                if (fieldClazzTypeArgs.isEmpty()) {
                    reader.skipValue();
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = map.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), $this.readValue(reader, decoderContext, (Class)fieldClazzTypeArgs.head(), (List)fieldClazzTypeArgs.tail(), fieldTypeArgsMap)));
            }
            reader.readEndDocument();
            object = map.toMap(Predef$.MODULE$.$conforms());
        }
        return object;
    }

    private static final Option readOptionalClassName$1(MacroCodec $this, BsonReader reader$1, DecoderContext decoderContext$1) {
        while (true) {
            block5: {
                None$ none$;
                block4: {
                    block3: {
                        BsonType bsonType = reader$1.readBsonType();
                        BsonType bsonType2 = BsonType.END_OF_DOCUMENT;
                        if (bsonType != null ? !bsonType.equals(bsonType2) : bsonType2 != null) break block3;
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    String string = reader$1.readName();
                    String string2 = $this.classFieldName();
                    if (string != null ? !string.equals(string2) : string2 != null) break block5;
                    none$ = new Some($this.codecRegistry().get(String.class).decode(reader$1, decoderContext$1));
                }
                return none$;
            }
            reader$1.skipValue();
        }
    }

    public static void $init$(MacroCodec $this) {
        $this.org$mongodb$scala$bson$codecs$macrocodecs$MacroCodec$_setter_$classFieldName_$eq("_t");
        $this.org$mongodb$scala$bson$codecs$macrocodecs$MacroCodec$_setter_$registry_$eq(CodecRegistries.fromRegistries((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CodecRegistry[]{$this.codecRegistry(), CodecRegistries.fromCodecs((Codec[])new Codec[]{$this})}))).asJava())));
        $this.org$mongodb$scala$bson$codecs$macrocodecs$MacroCodec$_setter_$bsonNull_$eq(BsonNull$.MODULE$.apply());
    }
}

