/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.scala;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Reason;
import com.mongodb.reactivestreams.client.ClientSession;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.mongodb.scala.ChangeStreamObservable;
import org.mongodb.scala.ListDatabasesObservable;
import org.mongodb.scala.MongoCluster$;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.Observable;
import org.mongodb.scala.SingleObservable;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.package$;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t-t!B\u000f\u001f\u0011\u0003)c!B\u0014\u001f\u0011\u0003A\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\td\u0001B\u0014\u001f\u0001MB\u0001\u0002\u000e\u0003\u0003\u0006\u0004%I!\u000e\u0005\t\u0001\u0012\u0011\t\u0011)A\u0005m!)a\u0006\u0002C\u0001\u0003\"A1\t\u0002EC\u0002\u0013\u0005A\t\u0003\u0005P\t!\u0015\r\u0011\"\u0001Q\u0011!)F\u0001#b\u0001\n\u00031\u0006\u0002\u0003.\u0005\u0011\u000b\u0007I\u0011A.\t\u0011}#\u0001R1A\u0005\u0002\u0001DQA\u001f\u0003\u0005\u0002mDQ! \u0003\u0005\u0002yDq!!\u0001\u0005\t\u0003\t\u0019\u0001C\u0004\u0002\b\u0011!\t!!\u0003\t\u000f\u00055A\u0001\"\u0001\u0002\u0010!9\u0011q\u0003\u0003\u0005\u0002\u0005e\u0001bBA\f\t\u0011\u0005\u0011q\u0006\u0005\b\u0003w!A\u0011AA\u001f\u0011\u001d\ty\u0006\u0002C\u0001\u0003CBq!a\u0018\u0005\t\u0003\tI\u0007C\u0004\u0002p\u0011!\t!!\u001d\t\u000f\u0005=D\u0001\"\u0001\u0002N\"9\u00111\u001d\u0003\u0005\u0002\u0005\u0015\bbBAr\t\u0011\u0005\u0011q \u0005\b\u0003G$A\u0011\u0001B\u001e\u0011\u001d\t\u0019\u000f\u0002C\u0001\u0005#\nA\"T8oO>\u001cE.^:uKJT!a\b\u0011\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u0005\u0012\u0013aB7p]\u001e|GM\u0019\u0006\u0002G\u0005\u0019qN]4\u0004\u0001A\u0011a%A\u0007\u0002=\taQj\u001c8h_\u000ecWo\u001d;feN\u0011\u0011!\u000b\t\u0003U1j\u0011a\u000b\u0006\u0002?%\u0011Qf\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0013!B1qa2LHc\u0001\u001a\u0003jA\u0011a\u0005B\n\u0003\t%\nqa\u001e:baB,G-F\u00017!\t9t(D\u00019\u0015\tI$(\u0001\u0004dY&,g\u000e\u001e\u0006\u0003wq\nqB]3bGRLg/Z:ue\u0016\fWn\u001d\u0006\u0003CuR\u0011AP\u0001\u0004G>l\u0017BA\u00149\u0003!9(/\u00199qK\u0012\u0004CC\u0001\u001aC\u0011\u0015!t\u00011\u00017\u00035\u0019w\u000eZ3d%\u0016<\u0017n\u001d;ssV\tQ\t\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u0006i1m\u001c8gS\u001e,(/\u0019;j_:T!AS&\u0002\r\r|G-Z2t\u0015\ta%%\u0001\u0003cg>t\u0017B\u0001(H\u00055\u0019u\u000eZ3d%\u0016<\u0017n\u001d;ss\u0006q!/Z1e!J,g-\u001a:f]\u000e,W#A)\u0011\u0005I\u001bV\"\u0001\u001f\n\u0005Qc$A\u0004*fC\u0012\u0004&/\u001a4fe\u0016t7-Z\u0001\roJLG/Z\"p]\u000e,'O\\\u000b\u0002/B\u0011!\u000bW\u0005\u00033r\u0012Ab\u0016:ji\u0016\u001cuN\\2fe:\f1B]3bI\u000e{gnY3s]V\tA\f\u0005\u0002S;&\u0011a\f\u0010\u0002\f%\u0016\fGmQ8oG\u0016\u0014h.A\u0004uS6,w.\u001e;\u0016\u0003\u0005\u00042A\u000b2e\u0013\t\u00197F\u0001\u0004PaRLwN\u001c\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003S.\n!bY8oGV\u0014(/\u001a8u\u0013\tYgM\u0001\u0005EkJ\fG/[8oQ\u0011aQn\u001d;\u0011\u00059\fX\"A8\u000b\u0005Ad\u0014aC1o]>$\u0018\r^5p]NL!A]8\u0003\u000b\u0005c\u0007\u000f[1\u0002\u000bY\fG.^3-\u0003U$\u0013A^\u0005\u0003ob\faa\u0011'J\u000b:#&BA=p\u0003\u0019\u0011V-Y:p]\u0006\tr/\u001b;i\u0007>$Wm\u0019*fO&\u001cHO]=\u0015\u0005Ib\b\"B\"\u000e\u0001\u0004)\u0015AE<ji\"\u0014V-\u00193Qe\u00164WM]3oG\u0016$\"AM@\t\u000b=s\u0001\u0019A)\u0002!]LG\u000f[,sSR,7i\u001c8dKJtGc\u0001\u001a\u0002\u0006!)Qk\u0004a\u0001/\u0006yq/\u001b;i%\u0016\fGmQ8oG\u0016\u0014h\u000eF\u00023\u0003\u0017AQA\u0017\tA\u0002q\u000b1b^5uQRKW.Z8viR\u0019!'!\u0005\t\u000b}\u000b\u0002\u0019\u00013)\u000bEi7/!\u0006-\u0003U\fAb\u001d;beR\u001cVm]:j_:$\"!a\u0007\u0011\u000b\u0019\ni\"!\t\n\u0007\u0005}aD\u0001\tTS:<G.Z(cg\u0016\u0014h/\u00192mKB!\u00111EA\u0015\u001d\r1\u0013QE\u0005\u0004\u0003Oq\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003W\tiCA\u0007DY&,g\u000e^*fgNLwN\u001c\u0006\u0004\u0003OqB\u0003BA\u000e\u0003cAq!a\r\u0014\u0001\u0004\t)$A\u0004paRLwN\\:\u0011\t\u0005\r\u0012qG\u0005\u0005\u0003s\tiC\u0001\u000bDY&,g\u000e^*fgNLwN\\(qi&|gn]\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002@\u0005\u0015\u0003c\u0001\u0014\u0002B%\u0019\u00111\t\u0010\u0003\u001b5{gnZ8ECR\f'-Y:f\u0011\u001d\t9\u0005\u0006a\u0001\u0003\u0013\nAA\\1nKB!\u00111JA-\u001d\u0011\ti%!\u0016\u0011\u0007\u0005=3&\u0004\u0002\u0002R)\u0019\u00111\u000b\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\t9fK\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0013Q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]3&A\tmSN$H)\u0019;bE\u0006\u001cXMT1nKN$\"!a\u0019\u0011\u000b\u0019\n)'!\u0013\n\u0007\u0005\u001ddD\u0001\u0006PEN,'O^1cY\u0016$B!a\u0019\u0002l!9\u0011Q\u000e\fA\u0002\u0005\u0005\u0012!D2mS\u0016tGoU3tg&|g.A\u0007mSN$H)\u0019;bE\u0006\u001cXm]\u000b\u0005\u0003g\n\t\t\u0006\u0002\u0002vQ1\u0011qOAJ\u0003{\u0003RAJA=\u0003{J1!a\u001f\u001f\u0005]a\u0015n\u001d;ECR\f'-Y:fg>\u00137/\u001a:wC\ndW\r\u0005\u0003\u0002\u0000\u0005\u0005E\u0002\u0001\u0003\b\u0003\u0007;\"\u0019AAC\u0005\u001d!&+Z:vYR\fB!a\"\u0002\u000eB\u0019!&!#\n\u0007\u0005-5FA\u0004O_RD\u0017N\\4\u0011\u0007)\ny)C\u0002\u0002\u0012.\u00121!\u00118z\u0011\u001d\t)j\u0006a\u0002\u0003/\u000b\u0011!\u001a\t\t\u00033\u000b\t,! \u00028:!\u00111TAV\u001d\u0011\ti*!+\u000f\t\u0005}\u0015q\u0015\b\u0005\u0003C\u000b)K\u0004\u0003\u0002P\u0005\r\u0016\"A\u0012\n\u0005\u0005\u0012\u0013BA\u0010!\u0013\tae$\u0003\u0003\u0002.\u0006=\u0016!\u0004#fM\u0006,H\u000e\u001e%fYB,'O\u0003\u0002M=%!\u00111WA[\u0005)!UMZ1vYR\u001cHk\u001c\u0006\u0005\u0003[\u000by\u000b\u0005\u0003\u0002$\u0005e\u0016\u0002BA^\u0003[\u0011\u0001\u0002R8dk6,g\u000e\u001e\u0005\b\u0003\u007f;\u00029AAa\u0003\t\u0019G\u000f\u0005\u0004\u0002D\u0006%\u0017QP\u0007\u0003\u0003\u000bT1!a2,\u0003\u001d\u0011XM\u001a7fGRLA!a3\u0002F\nA1\t\\1tgR\u000bw-\u0006\u0003\u0002P\u0006]G\u0003BAi\u0003C$b!a5\u0002Z\u0006u\u0007#\u0002\u0014\u0002z\u0005U\u0007\u0003BA@\u0003/$q!a!\u0019\u0005\u0004\t)\tC\u0004\u0002\u0016b\u0001\u001d!a7\u0011\u0011\u0005e\u0015\u0011WAk\u0003oCq!a0\u0019\u0001\b\ty\u000e\u0005\u0004\u0002D\u0006%\u0017Q\u001b\u0005\b\u0003[B\u0002\u0019AA\u0011\u0003\u00159\u0018\r^2i+\u0011\t9/a=\u0015\u0005\u0005%HCBAv\u0003o\fY\u0010E\u0003'\u0003[\f\t0C\u0002\u0002pz\u0011ac\u00115b]\u001e,7\u000b\u001e:fC6|%m]3sm\u0006\u0014G.\u001a\t\u0005\u0003\u007f\n\u0019\u0010B\u0004\u0002vf\u0011\r!!\"\u0003\u0003\rCq!!&\u001a\u0001\b\tI\u0010\u0005\u0005\u0002\u001a\u0006E\u0016\u0011_A\\\u0011\u001d\ty,\u0007a\u0002\u0003{\u0004b!a1\u0002J\u0006EX\u0003\u0002B\u0001\u0005\u0013!BAa\u0001\u0003\u0014Q1!Q\u0001B\u0006\u0005\u001f\u0001RAJAw\u0005\u000f\u0001B!a \u0003\n\u00119\u0011Q\u001f\u000eC\u0002\u0005\u0015\u0005bBAK5\u0001\u000f!Q\u0002\t\t\u00033\u000b\tLa\u0002\u00028\"9\u0011q\u0018\u000eA\u0004\tE\u0001CBAb\u0003\u0013\u00149\u0001C\u0004\u0003\u0016i\u0001\rAa\u0006\u0002\u0011AL\u0007/\u001a7j]\u0016\u0004bA!\u0007\u0003\"\t\u001db\u0002\u0002B\u000e\u0005?qA!a\u0014\u0003\u001e%\tq$C\u0002\u0002(-JAAa\t\u0003&\t\u00191+Z9\u000b\u0007\u0005\u001d2\u0006\u0005\u0003\u0003*\tUb\u0002\u0002B\u0016\u0005cqA!a'\u0003.%!!qFAX\u0003-\u0019wN\u001c<feNLwN\\:\n\t\u0005\u001d\"1\u0007\u0006\u0005\u0005_\ty+\u0003\u0003\u00038\te\"\u0001\u0002\"t_:TA!a\n\u00034U!!Q\bB#)\u0011\u0011yDa\u0014\u0015\r\t\u0005#q\tB&!\u00151\u0013Q\u001eB\"!\u0011\tyH!\u0012\u0005\u000f\u0005U8D1\u0001\u0002\u0006\"9\u0011QS\u000eA\u0004\t%\u0003\u0003CAM\u0003c\u0013\u0019%a.\t\u000f\u0005}6\u0004q\u0001\u0003NA1\u00111YAe\u0005\u0007Bq!!\u001c\u001c\u0001\u0004\t\t#\u0006\u0003\u0003T\tmCC\u0002B+\u0005K\u00129\u0007\u0006\u0004\u0003X\tu#\u0011\r\t\u0006M\u00055(\u0011\f\t\u0005\u0003\u007f\u0012Y\u0006B\u0004\u0002vr\u0011\r!!\"\t\u000f\u0005UE\u0004q\u0001\u0003`AA\u0011\u0011TAY\u00053\n9\fC\u0004\u0002@r\u0001\u001dAa\u0019\u0011\r\u0005\r\u0017\u0011\u001aB-\u0011\u001d\ti\u0007\ba\u0001\u0003CAqA!\u0006\u001d\u0001\u0004\u00119\u0002C\u00035\u0007\u0001\u0007a\u0007")
public class MongoCluster {
    private CodecRegistry codecRegistry;
    private ReadPreference readPreference;
    private WriteConcern writeConcern;
    private ReadConcern readConcern;
    @Alpha(value={Reason.CLIENT})
    private Option<Duration> timeout;
    private final com.mongodb.reactivestreams.client.MongoCluster wrapped;
    private volatile byte bitmap$0;

    public static MongoCluster apply(com.mongodb.reactivestreams.client.MongoCluster wrapped) {
        return MongoCluster$.MODULE$.apply(wrapped);
    }

    private com.mongodb.reactivestreams.client.MongoCluster wrapped() {
        return this.wrapped;
    }

    private CodecRegistry codecRegistry$lzycompute() {
        MongoCluster mongoCluster = this;
        synchronized (mongoCluster) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.codecRegistry = this.wrapped().getCodecRegistry();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.codecRegistry;
    }

    public CodecRegistry codecRegistry() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.codecRegistry$lzycompute() : this.codecRegistry;
    }

    private ReadPreference readPreference$lzycompute() {
        MongoCluster mongoCluster = this;
        synchronized (mongoCluster) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readPreference = this.wrapped().getReadPreference();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readPreference;
    }

    public ReadPreference readPreference() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.readPreference$lzycompute() : this.readPreference;
    }

    private WriteConcern writeConcern$lzycompute() {
        MongoCluster mongoCluster = this;
        synchronized (mongoCluster) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.writeConcern = this.wrapped().getWriteConcern();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.writeConcern;
    }

    public WriteConcern writeConcern() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.writeConcern$lzycompute() : this.writeConcern;
    }

    private ReadConcern readConcern$lzycompute() {
        MongoCluster mongoCluster = this;
        synchronized (mongoCluster) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.readConcern = this.wrapped().getReadConcern();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.readConcern;
    }

    public ReadConcern readConcern() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.readConcern$lzycompute() : this.readConcern;
    }

    private Option<Duration> timeout$lzycompute() {
        MongoCluster mongoCluster = this;
        synchronized (mongoCluster) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.timeout = Option$.MODULE$.apply((Object)this.wrapped().getTimeout(TimeUnit.MILLISECONDS)).map((Function1 & Serializable)t -> Duration$.MODULE$.apply(Predef$.MODULE$.Long2long(t), TimeUnit.MILLISECONDS));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.timeout;
    }

    public Option<Duration> timeout() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.timeout$lzycompute() : this.timeout;
    }

    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return MongoCluster$.MODULE$.apply(this.wrapped().withCodecRegistry(codecRegistry));
    }

    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return MongoCluster$.MODULE$.apply(this.wrapped().withReadPreference(readPreference));
    }

    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return MongoCluster$.MODULE$.apply(this.wrapped().withWriteConcern(writeConcern));
    }

    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return MongoCluster$.MODULE$.apply(this.wrapped().withReadConcern(readConcern));
    }

    @Alpha(value={Reason.CLIENT})
    public MongoCluster withTimeout(Duration timeout) {
        return MongoCluster$.MODULE$.apply(this.wrapped().withTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS));
    }

    public SingleObservable<ClientSession> startSession() {
        return package$.MODULE$.ToSingleObservablePublisher((Function0 & Serializable)() -> this.wrapped().startSession());
    }

    public SingleObservable<ClientSession> startSession(ClientSessionOptions options) {
        return package$.MODULE$.ToSingleObservablePublisher((Function0 & Serializable)() -> this.wrapped().startSession(options));
    }

    public MongoDatabase getDatabase(String name) {
        return new MongoDatabase(this.wrapped().getDatabase(name));
    }

    public Observable<String> listDatabaseNames() {
        return package$.MODULE$.ToObservableString((Function0<Publisher<String>>)(Function0 & Serializable)() -> this.wrapped().listDatabaseNames());
    }

    public Observable<String> listDatabaseNames(ClientSession clientSession) {
        return package$.MODULE$.ToObservableString((Function0<Publisher<String>>)(Function0 & Serializable)() -> this.wrapped().listDatabaseNames(clientSession));
    }

    public <TResult> ListDatabasesObservable<TResult> listDatabases(DefaultHelper.DefaultsTo<TResult, Document> e, ClassTag<TResult> ct) {
        return new ListDatabasesObservable(this.wrapped().listDatabases(package$.MODULE$.classTagToClassOf(ct)));
    }

    public <TResult> ListDatabasesObservable<TResult> listDatabases(ClientSession clientSession, DefaultHelper.DefaultsTo<TResult, Document> e, ClassTag<TResult> ct) {
        return new ListDatabasesObservable(this.wrapped().listDatabases(clientSession, package$.MODULE$.classTagToClassOf(ct)));
    }

    public <C> ChangeStreamObservable<C> watch(DefaultHelper.DefaultsTo<C, Document> e, ClassTag<C> ct) {
        return new ChangeStreamObservable(this.wrapped().watch(package$.MODULE$.classTagToClassOf(ct)));
    }

    public <C> ChangeStreamObservable<C> watch(Seq<Bson> pipeline, DefaultHelper.DefaultsTo<C, Document> e, ClassTag<C> ct) {
        return new ChangeStreamObservable(this.wrapped().watch((List)JavaConverters$.MODULE$.seqAsJavaListConverter(pipeline).asJava(), package$.MODULE$.classTagToClassOf(ct)));
    }

    public <C> ChangeStreamObservable<C> watch(ClientSession clientSession, DefaultHelper.DefaultsTo<C, Document> e, ClassTag<C> ct) {
        return new ChangeStreamObservable(this.wrapped().watch(clientSession, package$.MODULE$.classTagToClassOf(ct)));
    }

    public <C> ChangeStreamObservable<C> watch(ClientSession clientSession, Seq<Bson> pipeline, DefaultHelper.DefaultsTo<C, Document> e, ClassTag<C> ct) {
        return new ChangeStreamObservable(this.wrapped().watch(clientSession, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(pipeline).asJava(), package$.MODULE$.classTagToClassOf(ct)));
    }

    public MongoCluster(com.mongodb.reactivestreams.client.MongoCluster wrapped) {
        this.wrapped = wrapped;
    }
}

